/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.AtlTypesProcessor;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Operation;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.StringType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.UnitType;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;

public class ModuleType
extends UnitType {
    private static List<Operation> operations;

    public ModuleType(IFile file, AtlSourceManager manager) {
        super(file, manager, new OclType("Module"));
    }

    @Override
    protected List<Operation> getTypeOperations() {
        ModuleType moduleType = this;
        ArrayList<Operation> res = new ArrayList<Operation>();
        if (operations == null) {
            operations = new ArrayList<Operation>(moduleType){
                {
                    this.add(new Operation("resolveTemp", moduleType2, null, new HashMap<String, OclAnyType>(){
                        {
                            this.put("var", OclAnyType.getInstance());
                            this.put("target_pattern_name", StringType.getInstance());
                        }
                    }){

                        @Override
                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            return OclAnyType.getInstance();
                        }
                    });
                }
            };
        }
        res.addAll(operations);
        res.addAll(this.getRulesAsOperations());
        return res;
    }

    private List<Operation> getRulesAsOperations() {
        ArrayList<Operation> res = new ArrayList<Operation>();
        if (this.sourceManager.getModel() != null) {
            EList helpersAndRules = (EList)AtlTypesProcessor.eGet(this.sourceManager.getModel(), "elements");
            for (EObject element : helpersAndRules) {
                Operation ruleOperation;
                if (AtlTypesProcessor.oclIsKindOf(element, "LazyMatchedRule")) {
                    ruleOperation = Operation.createFromLazyRule(this, element, this);
                    if (ruleOperation == null) continue;
                    res.add(ruleOperation);
                    continue;
                }
                if (!AtlTypesProcessor.oclIsKindOf(element, "CalledRule") || (ruleOperation = Operation.createFromCalledRule(this, element, this)) == null) continue;
                res.add(ruleOperation);
            }
        }
        return res;
    }

    public EObject getRule(String ruleName) {
        if (this.sourceManager.getModel() != null) {
            EList helpersAndRules = (EList)AtlTypesProcessor.eGet(this.sourceManager.getModel(), "elements");
            for (EObject element : helpersAndRules) {
                String name;
                if (!AtlTypesProcessor.oclIsKindOf(element, "Rule") || !ruleName.equals(name = (String)AtlTypesProcessor.eGet(element, "name"))) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    protected Collection<EObject> getHelpersObjects() {
        return (Collection)AtlTypesProcessor.eGet(this.sourceManager.getModel(), "elements");
    }
}

