/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.views.inspector;

import com.ibm.icu.text.Collator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.accessibility.AccessibleCompositeAdapter;
import org.eclipse.mat.ui.accessibility.AccessibleToolbarAdapter;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.snapshot.ImageHelper;
import org.eclipse.mat.ui.snapshot.editor.HeapEditor;
import org.eclipse.mat.ui.snapshot.editor.ISnapshotEditorInput;
import org.eclipse.mat.ui.snapshot.views.inspector.FieldsContentProvider;
import org.eclipse.mat.ui.snapshot.views.inspector.FieldsLabelProvider;
import org.eclipse.mat.ui.snapshot.views.inspector.InspectorContextProvider;
import org.eclipse.mat.ui.snapshot.views.inspector.LazyFields;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.QueryContextMenu;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class InspectorView
extends ViewPart
implements IPartListener,
ISelectionChangedListener {
    private HeapEditor editor;
    ISnapshot snapshot;
    private Composite top;
    private Composite visualViewer;
    private TableViewer topTableViewer;
    private CTabFolder tabFolder;
    private TableViewer attributesTable;
    private TableViewer staticsTable;
    private TreeViewer classHierarchyTree;
    private StyledText resolvedValue;
    private boolean pinSelection = false;
    private Font font;
    private Map<ISnapshot, Stack<IContextObject>> prev = new WeakHashMap<ISnapshot, Stack<IContextObject>>();
    private IContextObject current;
    private List<Menu> contextMenus = new ArrayList<Menu>();
    boolean keepInSync = true;
    private boolean blankArrays;

    public void createPartControl(Composite parent) {
        SashForm form = new SashForm(parent, 512);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(1, 1).applyTo((Composite)form);
        this.top = new Composite((Composite)form, 128);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(1, 1).applyTo(this.top);
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.createSyncAction());
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)JFaceResources.getDefaultFont());
        fontDescriptor = fontDescriptor.setStyle(1);
        this.font = fontDescriptor.createFont((Device)this.top.getDisplay());
        this.createTopTable(this.top);
        this.createTabFolder(this.top);
        this.createVisualViewer((Composite)form);
        form.setWeights(new int[]{95, 5});
        this.getSite().getPage().addPartListener((IPartListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.workbench_inspector");
        this.hookContextMenu();
        this.showBootstrapPart();
    }

    private void createVisualViewer(Composite parent) {
        this.visualViewer = new Composite(parent, 128);
        this.visualViewer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Object toShow = InspectorView.this.visualViewer.getData("toShow");
                if (toShow == null) {
                    return;
                }
                if (toShow instanceof Image) {
                    paintEvent.gc.drawImage((Image)toShow, 0, 0);
                } else if (toShow instanceof RGB) {
                    Color color = new Color((Device)paintEvent.display, (RGB)toShow);
                    paintEvent.gc.setBackground(color);
                    paintEvent.gc.fillRectangle(0, 0, ((InspectorView)InspectorView.this).visualViewer.getSize().x, ((InspectorView)InspectorView.this).visualViewer.getSize().y);
                    color.dispose();
                }
            }
        });
        this.visualViewer.setVisible(false);
    }

    private Action createSyncAction() {
        Action syncAction = new Action(null, 2){

            public void run() {
                if (!InspectorView.this.keepInSync) {
                    InspectorView.this.showBootstrapPart();
                    if (InspectorView.this.editor != null) {
                        InspectorView.this.updateOnSelection(InspectorView.this.editor.getSelection());
                    }
                    InspectorView.this.keepInSync = true;
                } else {
                    InspectorView.this.keepInSync = false;
                }
                this.setChecked(!InspectorView.this.keepInSync);
            }
        };
        syncAction.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/synced.gif"));
        syncAction.setToolTipText(Messages.InspectorView_LinkWithSnapshot);
        return syncAction;
    }

    private void createTopTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.topTableViewer = new TableViewer(composite, 65538);
        Table table = this.topTableViewer.getTable();
        AccessibleCompositeAdapter.access(table);
        TableColumnLayout columnLayout = new TableColumnLayout();
        composite.setLayout((Layout)columnLayout);
        TableColumn column = new TableColumn(table, 16384);
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, 10));
        int itemHeight = table.getItemHeight() + 1;
        if (itemHeight < 17) {
            itemHeight = 17;
        }
        int scrollbarHeight = 2;
        if (!"win32".equals(Platform.getOS())) {
            scrollbarHeight = table.getHorizontalBar().getSize().y;
        }
        int detailsHeight = 9 * itemHeight + scrollbarHeight;
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        this.topTableViewer.setLabelProvider((IBaseLabelProvider)new TopTableLabelProvider());
        this.topTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        GridDataFactory.fillDefaults().hint(-1, detailsHeight).grab(true, false).applyTo((Control)composite);
    }

    private void createTabFolder(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 0x800080);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.tabFolder);
        ToolBar toolBar = new ToolBar((Composite)this.tabFolder, 0x800100);
        toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleToolbarAdapter(toolBar));
        this.tabFolder.setTopRight((Control)toolBar);
        this.tabFolder.setTabHeight(Math.max(toolBar.computeSize((int)-1, (int)-1).y, this.tabFolder.getTabHeight()));
        final ToolItem pinItem = new ToolItem(toolBar, 32);
        pinItem.setImage(MemoryAnalyserPlugin.getImage("$nl$/icons/pinned.gif"));
        pinItem.setToolTipText(Messages.InspectorView_PinTab);
        pinItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InspectorView.this.pinSelection = !InspectorView.this.pinSelection;
                pinItem.setSelection(InspectorView.this.pinSelection);
            }
        });
        toolBar.pack();
        CTabItem staticsTab = new CTabItem(this.tabFolder, 0);
        staticsTab.setText(Messages.InspectorView_Statics);
        this.staticsTable = this.createTable((Composite)this.tabFolder);
        staticsTab.setControl((Control)this.staticsTable.getTable().getParent());
        CTabItem instancesTab = new CTabItem(this.tabFolder, 0);
        instancesTab.setText(Messages.InspectorView_Attributes);
        this.attributesTable = this.createTable((Composite)this.tabFolder);
        instancesTab.setControl((Control)this.attributesTable.getTable().getParent());
        CTabItem classHierarchyTab = new CTabItem(this.tabFolder, 0);
        classHierarchyTab.setText(Messages.InspectorView_ClassHierarchy);
        this.classHierarchyTree = this.createHierarchyTree(this.tabFolder);
        classHierarchyTab.setControl((Control)this.classHierarchyTree.getTree().getParent());
        CTabItem valueTab = new CTabItem(this.tabFolder, 0);
        valueTab.setText(Messages.InspectorView_Value);
        this.resolvedValue = this.createValue(this.tabFolder);
        valueTab.setControl((Control)this.resolvedValue);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(){

            public void run() {
                if (InspectorView.this.topTableViewer.getControl().isFocusControl()) {
                    Copy.copyToClipboard(InspectorView.this.topTableViewer.getControl());
                } else {
                    int s = InspectorView.this.tabFolder.getSelectionIndex();
                    switch (s) {
                        case 0: {
                            Copy.copyToClipboard(InspectorView.this.staticsTable.getControl());
                            break;
                        }
                        case 1: {
                            Copy.copyToClipboard(InspectorView.this.attributesTable.getControl());
                            break;
                        }
                        case 2: {
                            Copy.copyToClipboard(InspectorView.this.classHierarchyTree.getControl());
                            break;
                        }
                        case 3: {
                            String buffer = InspectorView.this.resolvedValue.getSelectionText();
                            Copy.copyToClipboard(buffer, InspectorView.this.resolvedValue.getDisplay());
                            break;
                        }
                    }
                }
            }
        });
        this.tabFolder.setSelection(0);
    }

    private StyledText createValue(CTabFolder parent) {
        StyledText ret = new StyledText((Composite)parent, 74);
        return ret;
    }

    private TreeViewer createHierarchyTree(CTabFolder parent) {
        Composite composite = new Composite((Composite)parent, 0);
        TreeViewer classHierarchyTree = new TreeViewer(composite, 65538);
        classHierarchyTree.setContentProvider((IContentProvider)new HierarchyTreeContentProvider());
        classHierarchyTree.setLabelProvider((IBaseLabelProvider)new HierarchyLabelProvider(-1));
        Tree tree = classHierarchyTree.getTree();
        AccessibleCompositeAdapter.access(tree);
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        composite.setLayout((Layout)columnLayout);
        TreeColumn column = new TreeColumn(tree, 16384);
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, 10));
        return classHierarchyTree;
    }

    private TableViewer createTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        TableColumnLayout columnLayout = new TableColumnLayout();
        composite.setLayout((Layout)columnLayout);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        TableViewer viewer = new TableViewer(composite, 66306);
        Table table = viewer.getTable();
        AccessibleCompositeAdapter.access(table);
        viewer.setContentProvider((IContentProvider)new FieldsContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new FieldsLabelProvider(this, table.getFont()));
        viewer.setComparator((ViewerComparator)new FieldsViewerComparator());
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(Messages.InspectorView_Type);
        tableColumn.setWidth(50);
        tableColumn.addSelectionListener((SelectionListener)new ColumnSelectionListener(() -> ((TableViewer)viewer).refresh()));
        columnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(10, 50, false));
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setWidth(80);
        tableColumn.setText(Messages.InspectorView_Name);
        tableColumn.addSelectionListener((SelectionListener)new ColumnSelectionListener(() -> ((TableViewer)viewer).refresh()));
        columnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(30, 80));
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setWidth(250);
        tableColumn.setText(Messages.InspectorView_Value);
        tableColumn.addSelectionListener((SelectionListener)new ColumnSelectionListener(() -> ((TableViewer)viewer).refresh()));
        columnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(60, 250, true));
        table.setHeaderVisible(true);
        return viewer;
    }

    private void hookContextMenu() {
        this.createMenu((StructuredViewer)this.staticsTable);
        this.createMenu((StructuredViewer)this.attributesTable);
        this.createMenu((StructuredViewer)this.topTableViewer);
        this.createMenu((StructuredViewer)this.classHierarchyTree);
    }

    private void createMenu(StructuredViewer viewer) {
        Menu menu = new Menu(viewer.getControl());
        menu.addMenuListener((org.eclipse.swt.events.MenuListener)new MenuListener(menu, viewer));
        viewer.getControl().setMenu(menu);
        this.contextMenus.add(menu);
    }

    private void fillContextMenu(PopupMenu manager, StructuredViewer viewer) {
        Object firstElement;
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (this.editor != null) {
            InspectorContextProvider contextProvider = new InspectorContextProvider(this.snapshot);
            final IContextObject firstElement2 = contextProvider.getContext(selection.getFirstElement());
            IContextObject currentElement = this.current;
            boolean isObject = firstElement2 != null && (firstElement2.getObjectId() != currentElement.getObjectId() || firstElement2.getObjectId() == -1 && firstElement2 instanceof IContextObjectSet && currentElement instanceof IContextObjectSet && ((IContextObjectSet)firstElement2).getObjectIds().length == 0 && ((IContextObjectSet)currentElement).getObjectIds().length == 0 && ((IContextObjectSet)currentElement).getOQL() != null && !((IContextObjectSet)currentElement).getOQL().equals(((IContextObjectSet)firstElement2).getOQL()));
            boolean addedInto = false;
            if (isObject) {
                manager.add(new Action(Messages.InspectorView_GoInto){

                    public void run() {
                        if (!InspectorView.this.prev.containsKey(InspectorView.this.snapshot)) {
                            InspectorView.this.prev.put(InspectorView.this.snapshot, new Stack());
                        }
                        if (InspectorView.this.current != null) {
                            ((Stack)InspectorView.this.prev.get(InspectorView.this.snapshot)).push(InspectorView.this.current);
                        }
                        InspectorView.this.updateOnSelection((ISelection)new StructuredSelection((Object)firstElement2));
                    }
                });
                addedInto = true;
            }
            if (this.prev.containsKey(this.snapshot) && this.prev.get(this.snapshot).size() >= 1) {
                manager.add(new Action(Messages.InspectorView_GoBack){

                    public void run() {
                        InspectorView.this.updateOnSelection((ISelection)new StructuredSelection(((Stack)InspectorView.this.prev.get(InspectorView.this.snapshot)).pop()));
                    }
                });
                addedInto = true;
            }
            if (addedInto) {
                manager.addSeparator();
            }
            QueryContextMenu contextMenu = new QueryContextMenu((MultiPaneEditor)this.editor, (ContextProvider)contextProvider);
            contextMenu.addContextActions(manager, selection, viewer.getControl());
        }
        if ((firstElement = selection.getFirstElement()) instanceof FieldsContentProvider.MoreNode) {
            manager.addSeparator();
            ((FieldsContentProvider.MoreNode)firstElement).getActions().forEach(manager::add);
        }
    }

    private void showBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            this.partActivated((IWorkbenchPart)page.getActiveEditor());
        }
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof HeapEditor;
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removeSelectionChangedListener(this);
            this.editor = null;
        }
        for (Menu menu : this.contextMenus) {
            if (menu == null || menu.isDisposed()) continue;
            menu.dispose();
            Object var1_2 = null;
        }
        if (this.font != null) {
            this.font.dispose();
        }
        this.getSite().getPage().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.tabFolder.getSelection().getControl().setFocus();
    }

    public void partActivated(IWorkbenchPart part) {
        if (!this.isImportant(part)) {
            return;
        }
        if (!this.keepInSync) {
            return;
        }
        HeapEditor heapEditor = (HeapEditor)part;
        if (this.editor != heapEditor) {
            if (this.editor != null) {
                this.editor.removeSelectionChangedListener(this);
            }
            this.editor = heapEditor;
            final ISnapshotEditorInput input = heapEditor.getSnapshotInput();
            if (input.hasSnapshot()) {
                this.setSnapshot(input.getSnapshot());
            } else {
                this.setSnapshot(null);
                input.addChangeListener(new ISnapshotEditorInput.IChangeListener(){

                    @Override
                    public void onBaselineLoaded(ISnapshot snapshot) {
                    }

                    @Override
                    public void onSnapshotLoaded(ISnapshot snapshot) {
                        if (InspectorView.this.snapshot == null) {
                            InspectorView.this.setSnapshot(snapshot);
                        }
                        input.removeChangeListener(this);
                    }
                });
            }
            this.editor.addSelectionChangedListener(this);
            this.updateOnSelection(this.editor.getSelection());
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.partActivated(part);
    }

    public void partClosed(IWorkbenchPart part) {
        if (!this.isImportant(part)) {
            return;
        }
        HeapEditor heapEditor = (HeapEditor)part;
        if (this.editor == heapEditor) {
            this.editor.removeSelectionChangedListener(this);
            this.clearInput();
            this.setSnapshot(null);
            this.editor = null;
            this.prev.clear();
            if (!this.keepInSync) {
                this.keepInSync = true;
                this.showBootstrapPart();
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.keepInSync) {
            ISelection selection = event.getSelection();
            this.updateOnSelection(selection);
        }
    }

    private void updateOnSelection(final ISelection selection) {
        String oql;
        Object object;
        IContextObject objectSet = null;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IContextObject) {
            objectSet = (IContextObject)object;
        }
        long addr = 0L;
        if (objectSet instanceof IContextObjectSet && (oql = ((IContextObjectSet)objectSet).getOQL()) != null && ((IContextObjectSet)objectSet).getObjectIds().length == 0) {
            String addr0 = OQL.forAddress((long)0L);
            if (oql.startsWith((addr0 = addr0.substring(0, addr0.length() - 1)).substring(0, addr0.length())) && oql.substring(addr0.length() - 2).matches("0[xX][0-9a-fA-F]+")) {
                addr = Long.parseUnsignedLong(oql.substring(addr0.length()), 16);
            } else {
                Pattern p = Pattern.compile("^SELECT .* FROM OBJECTS (0x[0-9a-fA-F]+) ?[a-zA-Z][a-zA-Z0-9]*$");
                Matcher m = p.matcher(oql);
                if (m.find()) {
                    addr = Long.parseUnsignedLong(m.group(1).substring(2), 16);
                }
            }
        }
        if (objectSet == null || objectSet.getObjectId() < 0 && addr == 0L) {
            this.clearInput();
        } else {
            long currentAddr;
            Object addr0;
            int current;
            final int objectId = objectSet.getObjectId();
            Object data = this.topTableViewer.getData("input");
            if (data != null && (current = ((Integer)data).intValue()) == objectId && (addr0 = this.topTableViewer.getData("address")) != null && (currentAddr = ((Long)addr0).longValue()) == addr) {
                return;
            }
            final long objectAddress = addr;
            final ISnapshot savedSnapshot = this.snapshot;
            Job job = new Job(Messages.InspectorView_UpdateObjectDetails){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (InspectorView.this.snapshot == null || savedSnapshot != InspectorView.this.snapshot) {
                            return Status.OK_STATUS;
                        }
                        InspectorView.this.current = (IContextObject)((IStructuredSelection)selection).getFirstElement();
                        final IObject object = objectId >= 0 ? savedSnapshot.getObject(objectId) : new ObjectReference(savedSnapshot, objectAddress).getObject();
                        final List<Object> classInfos = this.prepareClassInfo(object);
                        final LazyFields<?> staticFields = this.prepareStaticFields(object);
                        final LazyFields<?> attributeFields = this.prepareAttributes(object);
                        final Object toShow = this.prepareVisualInfo(object);
                        InspectorView.this.topTableViewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                int selectionIndex;
                                InspectorView.this.topTableViewer.setInput((Object)classInfos);
                                InspectorView.this.topTableViewer.setData("input", (Object)objectId);
                                InspectorView.this.topTableViewer.setData("address", (Object)object.getObjectAddress());
                                InspectorView.this.staticsTable.setInput((Object)staticFields);
                                InspectorView.this.attributesTable.setInput((Object)attributeFields);
                                this.updateVisualViewer(toShow);
                                IClass input = object instanceof IClass ? (IClass)object : object.getClazz();
                                try {
                                    InspectorView.this.classHierarchyTree.getTree().setRedraw(false);
                                    InspectorView.this.classHierarchyTree.setInput(null);
                                    InspectorView.this.classHierarchyTree.setLabelProvider((IBaseLabelProvider)new HierarchyLabelProvider(input.getObjectId()));
                                    InspectorView.this.classHierarchyTree.setInput((Object)new IClass[]{input});
                                    InspectorView.this.classHierarchyTree.expandAll();
                                }
                                finally {
                                    InspectorView.this.classHierarchyTree.getTree().setRedraw(true);
                                }
                                String txt = object.getClassSpecificName();
                                InspectorView.this.resolvedValue.setText(txt != null ? txt : "");
                                if (!InspectorView.this.pinSelection && (selectionIndex = InspectorView.this.tabFolder.getSelectionIndex()) <= 1) {
                                    int newSelectionIndex;
                                    int n = newSelectionIndex = object instanceof IClass ? 0 : 1;
                                    if (selectionIndex != newSelectionIndex) {
                                        InspectorView.this.tabFolder.setSelection(newSelectionIndex);
                                    }
                                }
                            }

                            private void updateVisualViewer(Object toShow2) {
                                Object previous = InspectorView.this.visualViewer.getData("toShow");
                                if (previous instanceof Image) {
                                    ((Image)previous).dispose();
                                }
                                if (toShow2 != null) {
                                    if (toShow2 instanceof ImageData) {
                                        Image image = new Image((Device)InspectorView.this.visualViewer.getDisplay(), (ImageData)toShow2);
                                        InspectorView.this.visualViewer.setData("toShow", (Object)image);
                                    } else if (toShow2 instanceof RGB) {
                                        InspectorView.this.visualViewer.setData("toShow", toShow2);
                                    }
                                    InspectorView.this.visualViewer.redraw();
                                }
                                InspectorView.this.visualViewer.setVisible(toShow2 != null);
                                InspectorView.this.visualViewer.getParent().layout();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (SnapshotException e) {
                        return new Status(4, "org.eclipse.mat.ui", Messages.InspectorView_ErrorUpdatingInspector, (Throwable)e);
                    }
                }

                private Object prepareVisualInfo(IObject object) throws SnapshotException {
                    String kind = object.getClazz().getName();
                    if ("org.eclipse.swt.graphics.RGB".equals(kind)) {
                        Integer red = (Integer)object.resolveValue("red");
                        Integer green = (Integer)object.resolveValue("green");
                        Integer blue = (Integer)object.resolveValue("blue");
                        if (red == null || green == null || blue == null) {
                            return null;
                        }
                        return new RGB(red.intValue(), green.intValue(), blue.intValue());
                    }
                    if ("org.eclipse.swt.graphics.ImageData".equals(kind)) {
                        IPrimitiveArray data = (IPrimitiveArray)object.resolveValue("data");
                        Integer width = (Integer)object.resolveValue("width");
                        Integer height = (Integer)object.resolveValue("height");
                        Integer depth = (Integer)object.resolveValue("depth");
                        Integer scanlinePad = (Integer)object.resolveValue("scanlinePad");
                        Integer transparentPixel = (Integer)object.resolveValue("transparentPixel");
                        if (data == null || width == null || height == null || depth == null || scanlinePad == null || transparentPixel == null) {
                            return null;
                        }
                        PaletteData paletteData = this.makePaletteData((IInstance)object.resolveValue("palette"));
                        if (paletteData == null) {
                            return null;
                        }
                        byte[] dataArray = (byte[])data.getValueArray();
                        byte[] dataCopy = new byte[dataArray.length];
                        System.arraycopy(dataArray, 0, dataCopy, 0, dataArray.length);
                        ImageData imageData = new ImageData(width.intValue(), height.intValue(), depth.intValue(), paletteData, scanlinePad.intValue(), dataCopy);
                        imageData.transparentPixel = transparentPixel;
                        IPrimitiveArray alphaBytes = (IPrimitiveArray)object.resolveValue("alphaData");
                        if (alphaBytes != null) {
                            byte[] alphaDataArray = (byte[])alphaBytes.getValueArray();
                            byte[] alphaDataCopy = new byte[alphaDataArray.length];
                            System.arraycopy(alphaDataArray, 0, alphaDataCopy, 0, alphaDataArray.length);
                            imageData.alphaData = alphaDataCopy;
                        }
                        return imageData;
                    }
                    return null;
                }

                private LazyFields<?> prepareAttributes(IObject object) {
                    LazyFields fields = null;
                    fields = object instanceof IInstance ? new LazyFields.Instance((IInstance)object) : (object instanceof IPrimitiveArray ? (InspectorView.this.blankArrays ? new LazyFields.PrimitiveArrayBlank((IPrimitiveArray)object) : new LazyFields.PrimitiveArray((IPrimitiveArray)object)) : (object instanceof IObjectArray ? new LazyFields.ObjectArray((IObjectArray)object) : (object instanceof IClass ? new LazyFields.Class((IClass)object, true, false) : LazyFields.EMPTY)));
                    return fields;
                }

                private LazyFields<?> prepareStaticFields(IObject object) {
                    LazyFields.Class fields = null;
                    fields = object instanceof IClass ? new LazyFields.Class((IClass)object, false, false) : (object instanceof IInstance ? new LazyFields.Class(object.getClazz(), false, true) : LazyFields.EMPTY);
                    return fields;
                }

                private List<Object> prepareClassInfo(IObject object) throws SnapshotException {
                    GCRootInfo[] gc;
                    IClass superClass;
                    ArrayList<Object> details = new ArrayList<Object>();
                    details.add(new InfoItem(object, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/id.gif"), "0x" + Long.toHexString(object.getObjectAddress())));
                    String className = object instanceof IClass ? ((IClass)object).getName() : object.getClazz().getName();
                    int p = className.lastIndexOf(46);
                    if (p < 0) {
                        InfoItem item = new InfoItem(object, ImageHelper.getImageDescriptor(ImageHelper.getType(object)), className);
                        details.add(item);
                        details.add(new InfoItem(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/package.gif"), ""));
                    } else {
                        details.add(new InfoItem(object, ImageHelper.getImageDescriptor(ImageHelper.getType(object)), className.substring(p + 1)));
                        details.add(new InfoItem(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/package.gif"), className.substring(0, p)));
                    }
                    details.add(new ObjectNode((IObject)object.getClazz()));
                    IClass iClass = superClass = object instanceof IClass ? ((IClass)object).getSuperClass() : object.getClazz().getSuperClass();
                    if (superClass != null) {
                        details.add(new InfoItem((IObject)superClass, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/heapobjects/superclass.gif"), superClass.getName()));
                    }
                    ISnapshot snapshot = object.getSnapshot();
                    if (object instanceof IClass) {
                        details.add(new ObjectNode(snapshot.getObject(((IClass)object).getClassLoaderId())));
                    } else {
                        details.add(new ObjectNode(snapshot.getObject(object.getClazz().getClassLoaderId())));
                    }
                    details.add(new InfoItem(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/size.gif"), MessageUtil.format((String)Messages.InspectorView_shallowSize, (Object[])new Object[]{object.getUsedHeapSize()})));
                    details.add(new InfoItem(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/size.gif"), MessageUtil.format((String)Messages.InspectorView_retainedSize, (Object[])new Object[]{object.getRetainedHeapSize()})));
                    boolean unindexed = false;
                    try {
                        gc = object.getGCRootInfo();
                    }
                    catch (SnapshotException e) {
                        gc = null;
                        unindexed = true;
                    }
                    if (unindexed) {
                        details.add(new InfoItem(InspectorView.this.getSite().getWorkbenchWindow().getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING"), Messages.InspectorView_Unindexed));
                    } else {
                        details.add(gc != null ? gc : new InfoItem(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/decorations/gc_root.gif"), Messages.InspectorView_noGCRoot));
                    }
                    return details;
                }

                private PaletteData makePaletteData(IInstance palette) throws SnapshotException {
                    Boolean isDirect = (Boolean)palette.resolveValue("isDirect");
                    if (isDirect == null) {
                        return null;
                    }
                    if (isDirect.booleanValue()) {
                        Integer redMask = (Integer)palette.resolveValue("redMask");
                        Integer greenMask = (Integer)palette.resolveValue("greenMask");
                        Integer blueMask = (Integer)palette.resolveValue("blueMask");
                        if (redMask == null || greenMask == null || blueMask == null) {
                            return null;
                        }
                        return new PaletteData(redMask.intValue(), greenMask.intValue(), blueMask.intValue());
                    }
                    IObjectArray array = (IObjectArray)palette.resolveValue("colors");
                    if (array == null) {
                        return null;
                    }
                    RGB[] rgbs = new RGB[array.getLength()];
                    long[] refs = array.getReferenceArray();
                    ISnapshot snapshot = palette.getSnapshot();
                    int ii = 0;
                    while (ii < refs.length) {
                        ObjectReference ref = new ObjectReference(snapshot, refs[ii]);
                        IObject obj = ref.getObject();
                        if (obj == null) {
                            return null;
                        }
                        Integer red = (Integer)obj.resolveValue("red");
                        Integer green = (Integer)obj.resolveValue("green");
                        Integer blue = (Integer)obj.resolveValue("blue");
                        if (red == null || green == null || blue == null) {
                            return null;
                        }
                        rgbs[ii] = new RGB(red.intValue(), green.intValue(), blue.intValue());
                        ++ii;
                    }
                    return new PaletteData(rgbs);
                }
            };
            job.setPriority(50);
            job.schedule();
        }
    }

    private void setSnapshot(ISnapshot snapshot) {
        this.snapshot = snapshot;
        this.setBlankArrays();
    }

    private void setBlankArrays() {
        Serializable currentHeapFormat;
        if (this.snapshot != null && "DTFJ-PHD".equals(currentHeapFormat = this.snapshot.getSnapshotInfo().getProperty("$heapFormat"))) {
            this.blankArrays = true;
            return;
        }
        this.blankArrays = false;
    }

    private void clearInput() {
        this.topTableViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (InspectorView.this.topTableViewer.getContentProvider() != null) {
                    InspectorView.this.topTableViewer.setInput((Object)new Object[]{new Object()});
                    InspectorView.this.topTableViewer.setData("input", null);
                }
                if (InspectorView.this.staticsTable.getContentProvider() != null) {
                    InspectorView.this.staticsTable.setInput(LazyFields.EMPTY);
                }
                if (InspectorView.this.attributesTable.getContentProvider() != null) {
                    InspectorView.this.attributesTable.setInput(LazyFields.EMPTY);
                }
                if (InspectorView.this.classHierarchyTree.getContentProvider() != null) {
                    InspectorView.this.classHierarchyTree.setInput((Object)new Object[]{new Object()});
                }
                if (!InspectorView.this.resolvedValue.isDisposed()) {
                    InspectorView.this.resolvedValue.setText("");
                }
                for (Menu menu : InspectorView.this.contextMenus) {
                    if (menu.isDisposed()) continue;
                    InspectorView.this.disposeItems(menu);
                }
            }
        });
    }

    private void disposeItems(Menu menu) {
        MenuItem[] items;
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            if (!menuItem.isDisposed()) {
                menuItem.dispose();
            }
            ++n2;
        }
    }

    static class BaseNode {
        int objectId;
        long addr;

        public BaseNode(int objectId) {
            this(objectId, 0L);
        }

        public BaseNode(int objectId, long addr) {
            this.objectId = objectId;
            this.addr = addr;
        }

        static int objectID(IObject object) {
            if (object == null) {
                return -1;
            }
            try {
                return object.getObjectId();
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof SnapshotException) {
                    return -1;
                }
                throw e;
            }
        }
    }

    private static final class ColumnSelectionListener
    implements SelectionListener {
        private final Runnable afterColumnSelected;

        private ColumnSelectionListener(Runnable afterColumnSelected) {
            this.afterColumnSelected = afterColumnSelected;
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.widget;
            Table table = column.getParent();
            int direction = table.getSortDirection();
            boolean isSorted = column == table.getSortColumn();
            direction = this.nextSortDirection(direction, isSorted);
            table.setSortColumn(column);
            table.setSortDirection(direction);
            this.afterColumnSelected.run();
        }

        private int nextSortDirection(int direction, boolean isSorted) {
            if (!isSorted) {
                return 128;
            }
            switch (direction) {
                case 128: {
                    return 1024;
                }
                case 1024: {
                    return 0;
                }
            }
            return 128;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private static final class FieldsViewerComparator
    extends ViewerComparator {
        public FieldsViewerComparator() {
            super((Comparator)Collator.getInstance());
        }

        public int category(Object element) {
            if (element instanceof FieldsContentProvider.MoreNode) {
                return 1;
            }
            return 0;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            TableViewer tableViewer = (TableViewer)viewer;
            int direction = tableViewer.getTable().getSortDirection();
            if (direction == 0) {
                return 0;
            }
            int index = this.getSortColumnIndex(tableViewer.getTable());
            if (index == -1) {
                return 0;
            }
            String name1 = this.getLabel(viewer, e1, index);
            String name2 = this.getLabel(viewer, e2, index);
            return direction == 128 ? this.getComparator().compare(name1, name2) : this.getComparator().reversed().compare(name1, name2);
        }

        private int getSortColumnIndex(Table table) {
            TableColumn[] columns = table.getColumns();
            TableColumn sortColumn = table.getSortColumn();
            int index = -1;
            int i = 0;
            while (i < columns.length) {
                if (Objects.equals(sortColumn, columns[i])) {
                    index = i;
                }
                ++i;
            }
            return index;
        }

        private String getLabel(Viewer viewer, Object e, int index) {
            ITableLabelProvider provider = (ITableLabelProvider)((ContentViewer)viewer).getLabelProvider();
            String label = provider.getColumnText(e, index);
            if (label == null) {
                label = "";
            }
            return label;
        }
    }

    private class HierarchyLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private int classId;

        public HierarchyLabelProvider(int classId) {
            this.classId = classId;
        }

        public Image getImage(Object element) {
            return element instanceof IClass ? ImageHelper.getImage(8) : null;
        }

        public String getText(Object element) {
            return element instanceof IClass ? ((IClass)element).getName() : "";
        }

        public Font getFont(Object element) {
            if (element instanceof IClass && ((IClass)element).getObjectId() == this.classId) {
                return InspectorView.this.font;
            }
            return null;
        }
    }

    private static class HierarchyTreeContentProvider
    implements ITreeContentProvider {
        LinkedList<IClass> supers;

        private HierarchyTreeContentProvider() {
        }

        public Object[] getChildren(Object element) {
            int index = this.supers.indexOf(element);
            if (index >= 0 && index + 1 < this.supers.size()) {
                return new Object[]{this.supers.get(index + 1)};
            }
            return ((IClass)element).getSubclasses().toArray();
        }

        public IClass getParent(Object element) {
            return ((IClass)element).getSuperClass();
        }

        public boolean hasChildren(Object element) {
            return !((IClass)element).getSubclasses().isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            if (this.supers.isEmpty()) {
                return new Object[0];
            }
            return new Object[]{this.supers.get(0)};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.supers = new LinkedList();
            if (newInput instanceof IClass[]) {
                IClass[] input = (IClass[])newInput;
                this.supers = new LinkedList();
                this.supers.add(input[0]);
                while (input[0].hasSuperClass()) {
                    input[0] = input[0].getSuperClass();
                    this.supers.addFirst(input[0]);
                }
            }
        }
    }

    public static class InfoItem
    extends BaseNode {
        private ImageDescriptor descriptor;
        private String text;

        public InfoItem(ImageDescriptor descriptor, String text) {
            this(null, descriptor, text);
        }

        public InfoItem(IObject object, ImageDescriptor descriptor, String text) {
            super(InfoItem.objectID(object), object != null ? object.getObjectAddress() : Long.MIN_VALUE);
            this.descriptor = descriptor;
            this.text = text;
        }

        public ImageDescriptor getDescriptor() {
            return this.descriptor;
        }

        public String getText() {
            return this.text;
        }
    }

    private class MenuListener
    extends MenuAdapter {
        private Menu menu;
        private StructuredViewer viewer;

        public MenuListener(Menu menu, StructuredViewer viewer) {
            this.menu = menu;
            this.viewer = viewer;
        }

        public void menuShown(MenuEvent e) {
            MenuItem[] items = this.menu.getItems();
            int ii = 0;
            while (ii < items.length) {
                items[ii].dispose();
                ++ii;
            }
            PopupMenu popup = new PopupMenu();
            InspectorView.this.fillContextMenu(popup, this.viewer);
            popup.addToMenu(InspectorView.this.getViewSite().getActionBars().getStatusLineManager(), this.menu);
        }
    }

    private static class ObjectNode
    extends BaseNode {
        String label;
        int imageType;

        public ObjectNode(IObject object) {
            super(ObjectNode.objectID(object), object.getObjectAddress());
            this.label = object.getTechnicalName();
            this.imageType = ImageHelper.getType(object);
        }

        public String getLabel() {
            return this.label;
        }

        public int getImageType() {
            return this.imageType;
        }
    }

    private static final class TableContentProvider
    implements IStructuredContentProvider {
        Object[] elements;

        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.elements = newInput instanceof Collection ? ((Collection)newInput).toArray() : (Object[])newInput;
        }
    }

    private static class TopTableLabelProvider
    extends LabelProvider {
        private TopTableLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof InfoItem) {
                return ((InfoItem)element).getText();
            }
            if (element instanceof ObjectNode) {
                return ((ObjectNode)element).getLabel();
            }
            if (element instanceof GCRootInfo[]) {
                return String.valueOf(Messages.InspectorView_GCroot) + GCRootInfo.getTypeSetAsString((GCRootInfo[])((GCRootInfo[])element));
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof InfoItem) {
                return MemoryAnalyserPlugin.getDefault().getImage(((InfoItem)element).getDescriptor());
            }
            if (element instanceof ObjectNode) {
                return ImageHelper.getImage(((ObjectNode)element).getImageType());
            }
            if (element instanceof GCRootInfo[]) {
                return MemoryAnalyserPlugin.getImage("$nl$/icons/decorations/gc_root.gif");
            }
            return null;
        }
    }
}

