/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensingException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class GearAware<G, S extends Supplier<G>> {
    public final <T> Optional<T> withGear(Unsafe<G, T> with) throws LicensingException {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        Collection<Object> references = Collections.emptyList();
        try {
            references = context.getServiceReferences(this.supplier(), null);
        }
        catch (InvalidSyntaxException e) {
            throw new LicensingException("Failed to resolve service references", (Throwable)e);
        }
        if (references.isEmpty()) {
            throw new LicensingException("No reference of service " + this.supplier().getName());
        }
        ServiceReference any = (ServiceReference)references.iterator().next();
        try {
            Optional<T> optional = with.apply(((Supplier)context.getService(any)).get());
            return optional;
        }
        catch (Exception e) {
            throw new LicensingException("Error on service invocation", (Throwable)e);
        }
        finally {
            context.ungetService(any);
        }
    }

    protected abstract Class<S> supplier();

    @FunctionalInterface
    public static interface Unsafe<G, T> {
        public Optional<T> apply(G var1) throws Exception;
    }
}

