/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.editor.properties.sections.style.nodestyledescription;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.StylePackage;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractCheckBoxGroupPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class NodeStyleDescriptionResizeKindPropertySectionSpec
extends AbstractCheckBoxGroupPropertySection {
    private static final String HORIZONTALLY = "Horizontally";
    private static final String VERTICALLY = "Vertically";
    private static final String TOOL_TIP = "Authorized resize directions for the node";

    public NodeStyleDescriptionResizeKindPropertySectionSpec() {
        this.buttonGroup = false;
    }

    protected boolean isEqual(List<?> newList) {
        List<String> value = NodeStyleDescriptionResizeKindPropertySectionSpec.convertPropertiesToUI(((NodeStyleDescription)this.eObject).getResizeKind());
        return value.equals(newList);
    }

    protected List<?> getChoiceOfValues() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(HORIZONTALLY);
        values.add(VERTICALLY);
        return values;
    }

    protected EStructuralFeature getFeature() {
        return StylePackage.eINSTANCE.getNodeStyleDescription_ResizeKind();
    }

    protected String getDefaultLabelText() {
        return "Allow resizing";
    }

    protected String getFeatureAsText() {
        return this.getDefaultFeatureAsText();
    }

    protected String getDefaultFeatureAsText() {
        Object returnStr = "";
        if (this.eObject instanceof NodeStyleDescription) {
            for (String str : NodeStyleDescriptionResizeKindPropertySectionSpec.convertPropertiesToUI(((NodeStyleDescription)this.eObject).getResizeKind())) {
                returnStr = ((String)returnStr).length() > 0 ? (String)returnStr + ", " + str : str;
            }
        }
        return returnStr;
    }

    protected String getLabelText() {
        return this.getDefaultLabelText() + "*:";
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite fakeGroup = this.getWidgetFactory().createComposite(this.composite);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginLeft = 0;
        rowLayout.spacing = 5;
        fakeGroup.setLayout((Layout)rowLayout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        fakeGroup.setLayoutData((Object)data);
        int i = 0;
        while (i < this.button.length) {
            this.button[i].setParent(fakeGroup);
            this.button[i].setLayoutData(null);
            ++i;
        }
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)fakeGroup, -25);
        data.top = new FormAttachment((Control)fakeGroup, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.nameLabel.setToolTipText(TOOL_TIP);
        this.nameLabel.setFont(SiriusEditor.getFontRegistry().get("required"));
        data = new FormData();
        CLabel help = this.getWidgetFactory().createCLabel(this.composite, "");
        data.top = new FormAttachment((Control)this.nameLabel, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        help.setLayoutData((Object)data);
        help.setImage(this.getHelpIcon());
        help.setToolTipText(TOOL_TIP);
    }

    public void handleSelectionChanged() {
        boolean equals = this.isEqual(this.getSelectedValues());
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            ResizeKind value = this.getSelectedValue();
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    protected EAttribute getAttribute() {
        EAttribute attribute = null;
        for (EAttribute eAttribute : DiagramPackage.eINSTANCE.getNodeStyle().getEAllAttributes()) {
            if (!eAttribute.getEType().equals(this.getFeatures())) continue;
            attribute = eAttribute;
            break;
        }
        return attribute;
    }

    public static List<String> convertPropertiesToUI(ResizeKind resizeKind) {
        ArrayList<String> formats = new ArrayList<String>();
        if (resizeKind.getValue() == 1) {
            formats.add(HORIZONTALLY);
            formats.add(VERTICALLY);
        } else if (resizeKind.getValue() == 2) {
            formats.add(VERTICALLY);
        } else if (resizeKind.getValue() == 3) {
            formats.add(HORIZONTALLY);
        }
        return formats;
    }

    protected ResizeKind getSelectedValue() {
        List<?> possibleValues = this.getChoiceOfValues();
        ArrayList selectedValues = new ArrayList();
        int i = 0;
        while (i < this.button.length) {
            if (this.button[i].getSelection()) {
                selectedValues.add(possibleValues.get(i));
            }
            ++i;
        }
        ResizeKind resizeKind = selectedValues.isEmpty() ? ResizeKind.NONE_LITERAL : (selectedValues.size() == 1 ? (selectedValues.get(0).equals(HORIZONTALLY) ? ResizeKind.EAST_WEST_LITERAL : ResizeKind.NORTH_SOUTH_LITERAL) : ResizeKind.NSEW_LITERAL);
        return resizeKind;
    }

    protected EEnum getFeatures() {
        return DiagramPackage.eINSTANCE.getResizeKind();
    }
}

