/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.widgets;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableColumnInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableItemInfo;

public class TableInfo
extends CompositeInfo {
    public TableInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    public Table getWidget() {
        return (Table)this.getObject();
    }

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        this.addBroadcastListener(new JavaEventListener(){

            public void clipboardCopy(JavaInfo javaInfo, List<ClipboardCommand> commands) throws Exception {
                if (javaInfo == TableInfo.this) {
                    for (TableColumnInfo column : TableInfo.this.getColumns()) {
                        final JavaInfoMemento columnMemento = JavaInfoMemento.createMemento((JavaInfo)column);
                        commands.add(new ClipboardCommand(){
                            private static final long serialVersionUID = 0L;

                            public void execute(JavaInfo javaInfo) throws Exception {
                                JavaInfo column = columnMemento.create(javaInfo);
                                JavaInfoUtils.add((JavaInfo)column, null, (JavaInfo)javaInfo, null);
                                columnMemento.apply();
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    protected void refresh_fetch() throws Exception {
        super.refresh_fetch();
        Table table = this.getWidget();
        int headerHeight = table.getHeaderHeight();
        int itemHeight = table.getItemHeight();
        int x = 0;
        for (TableColumnInfo column : this.getColumns()) {
            int columnWidth = column.getWidget().getWidth();
            int y = 0;
            if (!EnvironmentUtils.IS_WINDOWS) {
                y -= headerHeight;
            }
            column.setModelBounds(new Rectangle(x, y, columnWidth, headerHeight));
            x += columnWidth;
        }
        int y = EnvironmentUtils.IS_WINDOWS ? headerHeight : 0;
        int width = this.getClientArea().width;
        for (TableItemInfo item : this.getItems()) {
            item.setModelBounds(new Rectangle(0, y, width, itemHeight));
            y += itemHeight;
        }
    }

    public List<TableColumnInfo> getColumns() {
        return this.getChildren(TableColumnInfo.class);
    }

    public List<TableItemInfo> getItems() {
        return this.getChildren(TableItemInfo.class);
    }
}

