/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceQuery;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResultEvents;
import org.eclipse.xtext.util.IAcceptor;

public class ReferenceSearchResult
implements ISearchResult,
IAcceptor<IReferenceDescription> {
    private ReferenceQuery query;
    private List<IReferenceDescription> matchingReferences;
    private List<ISearchResultListener> listeners;
    private Set<URI> removedURIs;

    protected ReferenceSearchResult(ReferenceQuery query) {
        this.query = query;
        this.matchingReferences = Lists.newArrayList();
        this.listeners = Lists.newArrayList();
        this.removedURIs = Sets.newHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvent(SearchResultEvent searchResultEvent) {
        List<ISearchResultListener> list = this.listeners;
        synchronized (list) {
            for (ISearchResultListener listener : this.listeners) {
                listener.searchResultChanged(searchResultEvent);
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getLabel() {
        return String.format("%s - (%s %s)", this.query.getLabel(), this.matchingReferences.size(), Messages.ReferenceSearchResult_Matches);
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public void accept(IReferenceDescription referenceDescription) {
        if (this.query.getFilter().apply((Object)referenceDescription) && !this.removedURIs.contains(referenceDescription.getSourceEObjectUri())) {
            this.matchingReferences.add(referenceDescription);
            this.fireEvent(new ReferenceSearchResultEvents.Added(this, referenceDescription));
        }
    }

    public void remove(IReferenceDescription[] referenceDescriptions) {
        if (this.matchingReferences.removeAll(Arrays.asList(referenceDescriptions))) {
            Arrays.stream(referenceDescriptions).map(d -> d.getSourceEObjectUri()).forEach(uri -> {
                boolean bl = this.removedURIs.add((URI)uri);
            });
            this.fireEvent(new ReferenceSearchResultEvents.Removed(this, referenceDescriptions));
        }
    }

    public List<IReferenceDescription> getMatchingReferences() {
        return this.matchingReferences;
    }

    public void reset() {
        this.matchingReferences.clear();
        this.fireEvent(new ReferenceSearchResultEvents.Reset(this));
    }

    public void finish() {
        this.fireEvent(new ReferenceSearchResultEvents.Finish(this));
    }
}

