/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.voice.preferences;

import org.eclipse.actf.ai.tts.TTSRegistry;
import org.eclipse.actf.ai.voice.IVoice;
import org.eclipse.actf.ai.voice.VoiceUtil;
import org.eclipse.actf.ai.voice.internal.Messages;
import org.eclipse.actf.ai.voice.internal.Voice;
import org.eclipse.actf.ai.voice.internal.VoicePlugin;
import org.eclipse.actf.ai.voice.preferences.util.GroupFieldEditorVoicePreferencePage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class VoicePreferencePage
extends GroupFieldEditorVoicePreferencePage
implements IWorkbenchPreferencePage {
    private static final String SAMPLE_TEXT = "Hello. This is test.";
    private static IVoice voice = VoiceUtil.getVoice();

    public VoicePreferencePage() {
        this.setPreferenceStore(VoicePlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.voice_description);
    }

    public void createFieldEditors() {
        String[][] stringArray = TTSRegistry.getLabelAndIds();
        RadioGroupFieldEditor radioGroupFieldEditor = new RadioGroupFieldEditor("activeEngine", Messages.voice_engine, 1, stringArray, this.getFieldEditorParent());
        this.addField((FieldEditor)radioGroupFieldEditor);
        Composite composite = radioGroupFieldEditor.getRadioBoxControl(this.getFieldEditorParent());
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n][1].length() == 0) {
                composite.getChildren()[n].setEnabled(false);
            }
            ++n;
        }
        final ScaleFieldEditor scaleFieldEditor = new ScaleFieldEditor("defaultSpeed", Messages.voice_speed, this.getFieldEditorParent(), 0, 100, 5, 25);
        this.addField((FieldEditor)scaleFieldEditor);
        Composite composite2 = new Composite(this.getFieldEditorParent(), 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(128);
        gridData.horizontalSpan = scaleFieldEditor.getNumberOfControls();
        composite2.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 0);
        button.setText(Messages.voice_test);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                voice.setSpeed(scaleFieldEditor.getScaleControl().getSelection());
                voice.speak(VoicePreferencePage.SAMPLE_TEXT, false);
            }
        });
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void dispose() {
        super.dispose();
        ((Voice)voice).setSpeed();
    }
}

