/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.ResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.dialog.NewLibraryDialog;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.framework.Bundle;

public class NewLibraryAction
extends ResourceAction {
    public NewLibraryAction(LibraryExplorerTreeViewPage page) {
        super(Messages.getString((String)"NewLibraryAction.Text"), page);
        this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"New library"));
    }

    public boolean isEnabled() {
        try {
            return this.canInsertIntoSelectedContainer();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void run() {
        try {
            File container = this.getSelectedContainer();
            if (container == null) {
                return;
            }
            NewLibraryDialog dialog = new NewLibraryDialog(this.getUniqueFile(container, Messages.getString((String)"NewLibraryWizard.displayName.NewReportFileNamePrefix"), Messages.getString((String)"NewLibraryWizard.displayName.NewReportFileExtension")));
            if (dialog.open() == 0) {
                this.createLibrary(dialog.getPath());
            }
        }
        catch (IOException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    private File getUniqueFile(File path, String prefix, String ext) {
        int i = 0;
        File file = null;
        do {
            String filename = i == 0 ? String.valueOf(prefix) + ext : String.valueOf(prefix) + "_" + i + ext;
            file = new File(path, filename);
            ++i;
        } while (file != null && file.exists());
        return file;
    }

    private void createLibrary(final String fileName) throws IOException {
        final String templateName = this.getLibraryTemplateName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewLibraryAction.this.doFinish(fileName, templateName, monitor);
                    }
                    catch (SemanticException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (DesignFileException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, op);
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        catch (InterruptedException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    private String getLibraryTemplateName() throws IOException {
        Bundle resourceBundle = Platform.getBundle((String)"org.eclipse.birt.resources");
        URL url = resourceBundle == null ? null : FileLocator.find((Bundle)resourceBundle, (IPath)new Path("/templates/blank_library.rpttemplate"), null);
        return url == null ? null : FileLocator.resolve(url).getPath();
    }

    private void doFinish(String libraryName, String templateName, IProgressMonitor monitor) throws DesignFileException, SemanticException, IOException {
        monitor.beginTask(null, -1);
        try {
            this.makeLibrary(libraryName, templateName);
            this.openLibrary(new File(libraryName), true);
        }
        finally {
            monitor.done();
        }
    }

    private void makeLibrary(String fileName, String templateName) throws DesignFileException, SemanticException, IOException {
        String description;
        LibraryHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().createLibraryFromTemplate(templateName);
        if (ReportPlugin.getDefault().getEnableCommentPreference()) {
            handle.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference());
        }
        if (this.inPredifinedTemplateFolder(templateName) && (description = handle.getDescription()) != null && description.trim().length() > 0) {
            handle.setDescription(Messages.getString((String)description));
        }
        handle.saveAs(fileName);
        handle.close();
    }

    private boolean inPredifinedTemplateFolder(String templateName) {
        String predifinedDir = UIUtil.getFragmentDirectory();
        File predifinedFile = new File(predifinedDir);
        File sourceFile = new File(templateName);
        return sourceFile.getAbsolutePath().startsWith(predifinedFile.getAbsolutePath());
    }
}

