/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFTextDescription;
import org.eclipse.eef.EEFTextStyle;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.common.ui.api.SWTUtils;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IEEFTextController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.eef.ide.ui.internal.widgets.styles.EEFColor;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EEFTextLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int TEXT_AREA_WIDTH_HINT = 300;
    private EEFTextDescription description;
    private StyledText text;
    private IEEFTextController controller;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private EEFWidgetFactory widgetFactory;
    private Color defaultBackgroundColor;
    private ModifyListener modifyListener;
    private AtomicBoolean updateInProgress = new AtomicBoolean(false);
    private String referenceValue = "";
    private boolean isDirty;

    public EEFTextLifecycleManager(EEFTextDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.widgetFactory = formContainer.getWidgetFactory();
        this.defaultBackgroundColor = parent.getBackground();
        int lineCount = this.description.getLineCount();
        if (lineCount > 1) {
            this.text = this.widgetFactory.createStyledText(parent, 834);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.heightHint = lineCount * this.text.getLineHeight();
            gridData.widthHint = 300;
            gridData.horizontalIndent = 5;
            this.text.setLayoutData((Object)gridData);
        } else {
            this.text = this.widgetFactory.createStyledText(parent, 4);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalIndent = 5;
            this.text.setLayoutData((Object)gridData);
        }
        this.text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createTextController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    @Override
    protected int getLabelVerticalAlignment() {
        if (this.description.getLineCount() > 1) {
            return 2;
        }
        return 4;
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.modifyListener = event -> {
            if (!this.container.isRenderingInProgress() && !this.updateInProgress.get()) {
                this.isDirty = true;
            }
        };
        this.text.addModifyListener(this.modifyListener);
        this.focusListener = SWTUtils.focusLostAdapter(event -> {
            if (!this.container.isRenderingInProgress() && this.isDirty) {
                this.updateValue(false);
            }
        });
        this.text.addFocusListener(this.focusListener);
        if (this.description.getLineCount() <= 1) {
            this.keyListener = SWTUtils.keyReleasedAdapter(event -> {
                if (event.character == '\r' || event.character == '\n') {
                    this.updateValue(false);
                }
            });
            this.text.addKeyListener(this.keyListener);
        }
        this.controller.onNewValue(value -> {
            if (!this.text.isDisposed()) {
                String display = "";
                if (value != null) {
                    display = Util.firstNonNull((String[])new String[]{value.toString(), display});
                }
                if (this.text.getText() == null || !this.text.getText().equals(display)) {
                    this.text.setText(display);
                    this.referenceValue = this.text.getText();
                }
                this.setStyle();
                if (!this.text.isEnabled()) {
                    this.text.setEnabled(true);
                }
            }
        });
    }

    private void updateValue(boolean force) {
        boolean shouldUpdateWhileRendering;
        boolean bl = shouldUpdateWhileRendering = !this.container.isRenderingInProgress() || force;
        if (!this.text.isDisposed() && this.isDirty && shouldUpdateWhileRendering && this.updateInProgress.compareAndSet(false, true)) {
            try {
                IStatus result = this.controller.updateValue(this.text.getText());
                if (result != null && result.getSeverity() == 4) {
                    EEFIdeUiPlugin.INSTANCE.log(result);
                    this.text.setText(this.referenceValue);
                } else {
                    this.referenceValue = this.text.getText();
                    this.refresh();
                }
                this.isDirty = false;
                this.setStyle();
            }
            finally {
                this.updateInProgress.set(false);
            }
        }
    }

    private void setStyle() {
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle widgetStyle = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (widgetStyle instanceof EEFTextStyle) {
            EEFTextStyle textStyle = (EEFTextStyle)widgetStyle;
            EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.text);
            styleHelper.applyTextStyle(textStyle.getFontNameExpression(), textStyle.getFontSizeExpression(), textStyle.getFontStyleExpression(), this.text.getFont(), textStyle.getBackgroundColorExpression(), textStyle.getForegroundColorExpression(), callback);
        }
    }

    @Override
    protected Control getValidationControl() {
        return this.text;
    }

    @Override
    public void aboutToBeHidden() {
        if (this.isDirty) {
            this.updateValue(true);
        }
        super.aboutToBeHidden();
        if (!this.text.isDisposed()) {
            this.text.removeFocusListener(this.focusListener);
        }
        this.controller.removeNewValueConsumer();
        if (!this.text.isDisposed()) {
            this.text.removeModifyListener(this.modifyListener);
        }
        if (!this.text.isDisposed() && this.description.getLineCount() <= 1) {
            this.text.removeKeyListener(this.keyListener);
        }
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        if (!this.text.isDisposed()) {
            this.text.setEnabled(isEnabled);
            this.text.setEditable(isEnabled);
            this.text.setBackground(this.getBackgroundColor(isEnabled));
        }
    }

    private Color getBackgroundColor(boolean isEnabled) {
        Color color = this.defaultBackgroundColor;
        if (!isEnabled) {
            color = this.widgetFactory.getColors().getInactiveBackground();
        } else {
            EEFTextStyle style;
            String backgroundColorCode;
            EEFWidgetStyle widgetStyle = new EEFStyleHelper(this.interpreter, this.variableManager).getWidgetStyle((EEFWidgetDescription)this.description);
            if (widgetStyle instanceof EEFTextStyle && !Util.isBlank((String)(backgroundColorCode = (style = (EEFTextStyle)widgetStyle).getBackgroundColorExpression()))) {
                EEFColor backgroundColor = new EEFColor(backgroundColorCode);
                color = backgroundColor.getColor();
            }
        }
        return color;
    }
}

