/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.handlers;

import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.logging.aeri.core.IServerConnection;
import org.osgi.framework.Bundle;

import com.google.common.base.Throwables;

public class CreateServerConnectionHandler {

    @Execute
    public IServerConnection execute(IServerDescriptor server, IEclipseContext context) {
        String contributor = server.getContributor();
        Bundle ext = Platform.getBundle(contributor);
        String clazzName = server.getClazz();
        try {
            Class<? extends IServerConnection> clazz = (Class<? extends IServerConnection>) ext.loadClass(clazzName);
            IServerConnection object = ContextInjectionFactory.make(clazz, context);
            server.setConnection(object);
            return object;
        } catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}
