/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.contentassist;

import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.clustermode.ClusterMode;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.dir.DirType;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeOp;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.layout.Layout;
import org.eclipse.gef.dot.internal.language.outputmode.OutputMode;
import org.eclipse.gef.dot.internal.language.pagedir.Pagedir;
import org.eclipse.gef.dot.internal.language.rankdir.Rankdir;
import org.eclipse.gef.dot.internal.language.services.DotGrammarAccess;
import org.eclipse.gef.dot.internal.language.splines.Splines;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.contentassist.AbstractDotProposalProvider;
import org.eclipse.gef.dot.internal.ui.language.contentassist.DotProposalProviderDelegator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class DotProposalProvider
extends AbstractDotProposalProvider {
    @Inject
    DotGrammarAccess dotGrammarAccess;
    private static Map<DotAttributes.Context, List<String>> dotAttributeNames;
    private String[] booleanAttributeValuesProposals = new String[]{"true", "false"};

    public DotProposalProvider() {
        if (dotAttributeNames == null) {
            dotAttributeNames = this.getDotAttributeNames();
        }
    }

    protected ICompletionProposal createCompletionProposal(String proposal, StyledString displayString, Image image, int priority, String prefix, ContentAssistContext context) {
        INode currentNode;
        String text;
        if (context.getCurrentModel() instanceof DotGraph && ((DotGraph)context.getCurrentModel()).getType() == GraphType.DIGRAPH && proposal.equals(EdgeOp.UNDIRECTED.toString())) {
            return null;
        }
        if (context.getCurrentModel() instanceof DotGraph && ((DotGraph)context.getCurrentModel()).getType() == GraphType.GRAPH && proposal.equals(EdgeOp.DIRECTED.toString())) {
            return null;
        }
        if (context.getPrefix().equals("=") && proposal.equals("=")) {
            return null;
        }
        if (context.getPrefix().equals("[") && proposal.equals("[")) {
            return null;
        }
        ICompletionProposal completionProposal = super.createCompletionProposal(proposal, displayString, image, priority, prefix, context);
        if (completionProposal instanceof ConfigurableCompletionProposal && context.getCurrentModel() instanceof Attribute && (text = (currentNode = context.getCurrentNode()).getText()).startsWith("\"")) {
            ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
            configurableCompletionProposal.setReplacementOffset(configurableCompletionProposal.getReplacementOffset() + 1);
            configurableCompletionProposal.setReplacementLength(configurableCompletionProposal.getReplacementLength() - 1);
        }
        return completionProposal;
    }

    protected boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        if (context.getCurrentModel() instanceof Attribute && prefix.startsWith("\"")) {
            return super.isValidProposal(proposal, prefix.substring(1), context);
        }
        return super.isValidProposal(proposal, prefix, context);
    }

    @Override
    public void completePort_Compass_pt(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (Keyword k : EcoreUtil2.getAllContentsOfType((EObject)this.dotGrammarAccess.getCOMPASS_PTRule().getAlternatives(), Keyword.class)) {
            acceptor.accept(this.createCompletionProposal(k.getValue(), context));
        }
        super.completePort_Compass_pt(model, assignment, context, acceptor);
    }

    @Override
    public void completeAttribute_Name(EObject model, Assignment assignment, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        super.completeAttribute_Name(model, assignment, contentAssistContext, acceptor);
        if (model instanceof AttrList) {
            DotAttributes.Context attributeContext = DotAttributes.getContext((EObject)model);
            this.proposeAttributeNames(attributeContext, contentAssistContext, acceptor);
        } else if (model instanceof DotGraph || model instanceof NodeStmt) {
            this.proposeAttributeNames(DotAttributes.Context.GRAPH, contentAssistContext, acceptor);
        }
    }

    @Override
    public void completeAttribute_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block130: {
            block127: {
                block135: {
                    Attribute attribute;
                    block133: {
                        block131: {
                            block128: {
                                if (!(model instanceof Attribute)) break block127;
                                attribute = (Attribute)model;
                                if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.EDGE) break block128;
                                switch (attribute.getName().toValue()) {
                                    case "arrowhead": 
                                    case "arrowtail": {
                                        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotArrowType", context, acceptor);
                                        break;
                                    }
                                    case "fontcolor": 
                                    case "fillcolor": 
                                    case "color": 
                                    case "labelfontcolor": {
                                        this.proposeColorAttributeValues(attribute, context, acceptor);
                                        break;
                                    }
                                    case "colorscheme": {
                                        this.proposeAttributeValues(DotColors.getColorSchemes(), context, acceptor);
                                        break;
                                    }
                                    case "dir": {
                                        this.proposeAttributeValues(DirType.values(), context, acceptor);
                                        break;
                                    }
                                    case "tail_lp": 
                                    case "lp": 
                                    case "xlp": 
                                    case "head_lp": {
                                        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPoint", context, acceptor);
                                        break;
                                    }
                                    case "xlabel": 
                                    case "headlabel": 
                                    case "taillabel": 
                                    case "label": {
                                        this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                                        break;
                                    }
                                    case "pos": {
                                        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotSplineType", context, acceptor);
                                        break;
                                    }
                                    case "style": {
                                        this.proposeAttributeValues(EdgeStyle.VALUES, context, acceptor);
                                        break;
                                    }
                                    default: {
                                        super.completeAttribute_Value(model, assignment, context, acceptor);
                                        break;
                                    }
                                }
                                break block130;
                            }
                            if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.GRAPH) break block131;
                            switch (attribute.getName().toValue()) {
                                case "fontcolor": 
                                case "bgcolor": {
                                    this.proposeColorAttributeValues(attribute, context, acceptor);
                                    break;
                                }
                                case "clusterrank": {
                                    this.proposeAttributeValues(ClusterMode.values(), context, acceptor);
                                    break;
                                }
                                case "colorscheme": {
                                    this.proposeAttributeValues(DotColors.getColorSchemes(), context, acceptor);
                                    break;
                                }
                                case "forcelabels": {
                                    this.proposeAttributeValues(this.booleanAttributeValuesProposals, context, acceptor);
                                    break;
                                }
                                case "label": {
                                    this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                                    break;
                                }
                                case "layout": {
                                    this.proposeAttributeValues(Layout.values(), context, acceptor);
                                    break;
                                }
                                case "lp": {
                                    this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPoint", context, acceptor);
                                    break;
                                }
                                case "outputorder": {
                                    this.proposeAttributeValues(OutputMode.values(), context, acceptor);
                                    break;
                                }
                                case "pagedir": {
                                    this.proposeAttributeValues(Pagedir.values(), context, acceptor);
                                    break;
                                }
                                case "rankdir": {
                                    this.proposeAttributeValues(Rankdir.values(), context, acceptor);
                                    break;
                                }
                                case "splines": {
                                    this.proposeAttributeValues(Splines.values(), context, acceptor);
                                    break;
                                }
                                default: {
                                    super.completeAttribute_Value(model, assignment, context, acceptor);
                                    break;
                                }
                            }
                            break block130;
                        }
                        if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.NODE) break block133;
                        switch (attribute.getName().toValue()) {
                            case "fontcolor": 
                            case "fillcolor": 
                            case "color": {
                                this.proposeColorAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "colorscheme": {
                                this.proposeAttributeValues(DotColors.getColorSchemes(), context, acceptor);
                                break;
                            }
                            case "fixedsize": {
                                this.proposeAttributeValues(this.booleanAttributeValuesProposals, context, acceptor);
                                break;
                            }
                            case "xlabel": 
                            case "label": {
                                this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "pos": 
                            case "xlp": {
                                this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPoint", context, acceptor);
                                break;
                            }
                            case "shape": {
                                this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotShape", context, acceptor);
                                break;
                            }
                            case "style": {
                                this.proposeAttributeValues(NodeStyle.VALUES, context, acceptor);
                                break;
                            }
                        }
                        break block130;
                    }
                    if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.CLUSTER && DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.SUBGRAPH) break block135;
                    switch (attribute.getName().toValue()) {
                        case "label": {
                            this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                        }
                    }
                    break block130;
                }
                super.completeAttribute_Value(model, assignment, context, acceptor);
                break block130;
            }
            super.completeAttribute_Value(model, assignment, context, acceptor);
        }
    }

    private void proposeAttributeNames(DotAttributes.Context attributeContext, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        for (String attributeName : dotAttributeNames.get(attributeContext)) {
            ICompletionProposal completionProposal = this.createCompletionProposal(attributeName, contentAssistContext);
            acceptor.accept(completionProposal);
        }
    }

    private void proposeAttributeValues(String subgrammarName, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String text = context.getPrefix();
        if (text.startsWith("\"")) {
            text = ID.fromString((String)text, (ID.Type)ID.Type.QUOTED_STRING).toValue();
            context = context.copy().setPrefix(text).toContext();
        }
        if (text.startsWith("<")) {
            text = ID.fromString((String)text, (ID.Type)ID.Type.HTML_STRING).toValue();
            context = context.copy().setPrefix(text).toContext();
        }
        List<ConfigurableCompletionProposal> configurableCompletionProposals = new DotProposalProviderDelegator(subgrammarName).computeConfigurableCompletionProposals(text, text.length());
        for (ConfigurableCompletionProposal configurableCompletionProposal : configurableCompletionProposals) {
            configurableCompletionProposal.setReplacementOffset(context.getOffset() - configurableCompletionProposal.getReplaceContextLength());
            acceptor.accept((ICompletionProposal)configurableCompletionProposal);
        }
    }

    private void proposeAttributeValues(Object[] values, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeAttributeValues(Arrays.asList(values), context, acceptor);
    }

    private void proposeAttributeValues(List<?> values, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (Object value : values) {
            String proposedValue = ID.fromValue((String)value.toString()).toString();
            acceptor.accept(this.createCompletionProposal(proposedValue, context));
        }
    }

    private void proposeColorAttributeValues(Attribute attribute, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotColor", context, acceptor);
        List<String> validColorNames = this.getColorNames(attribute);
        this.proposeAttributeValues(validColorNames, context, acceptor);
    }

    private void proposeHtmlLabelAttributeValues(Attribute attribute, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (attribute.getValue() != null && attribute.getValue().getType() == ID.Type.HTML_STRING) {
            this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotHtmlLabel", context, acceptor);
        }
    }

    private Map<DotAttributes.Context, List<String>> getDotAttributeNames() {
        Field[] declaredFields;
        ArrayList<String> edgeAttributeNames = new ArrayList<String>();
        ArrayList<String> graphAttributeNames = new ArrayList<String>();
        ArrayList<String> nodeAttributeNames = new ArrayList<String>();
        Field[] fieldArray = declaredFields = DotAttributes.class.getDeclaredFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && field.getType().equals(String.class)) {
                String fieldName = field.getName();
                String dotClassifier = fieldName.substring(fieldName.lastIndexOf("_") + 1);
                if (!fieldName.startsWith("_")) {
                    String dotAttributeName = null;
                    try {
                        dotAttributeName = (String)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    if (dotAttributeName != null) {
                        if (dotClassifier.contains("E")) {
                            edgeAttributeNames.add(dotAttributeName);
                        }
                        if (dotClassifier.contains("G")) {
                            graphAttributeNames.add(dotAttributeName);
                        }
                        if (dotClassifier.contains("N")) {
                            nodeAttributeNames.add(dotAttributeName);
                        }
                    }
                }
            }
            ++n2;
        }
        HashMap<DotAttributes.Context, List<String>> dotAttributeNames = new HashMap<DotAttributes.Context, List<String>>();
        dotAttributeNames.put(DotAttributes.Context.EDGE, edgeAttributeNames);
        dotAttributeNames.put(DotAttributes.Context.GRAPH, graphAttributeNames);
        dotAttributeNames.put(DotAttributes.Context.NODE, nodeAttributeNames);
        return dotAttributeNames;
    }

    private List<String> getColorNames(Attribute attribute) {
        ID colorScheme;
        ID colorScheme2;
        EObject container = EcoreUtil2.getContainerOfType((EObject)attribute, EdgeStmtNode.class);
        if (container != null && (colorScheme2 = DotAstHelper.getAttributeValue((List)((EdgeStmtNode)container).getAttrLists(), (String)"colorscheme")) != null) {
            return DotColors.getColorNames((String)colorScheme2.toValue());
        }
        container = EcoreUtil2.getContainerOfType((EObject)attribute, NodeStmt.class);
        if (container != null && (colorScheme2 = DotAstHelper.getAttributeValue((List)((NodeStmt)container).getAttrLists(), (String)"colorscheme")) != null) {
            return DotColors.getColorNames((String)colorScheme2.toValue());
        }
        container = EcoreUtil2.getContainerOfType((EObject)attribute, DotGraph.class);
        if (container != null && (colorScheme2 = DotAstHelper.getAttributeValue((DotGraph)((DotGraph)container), (String)"colorscheme")) != null) {
            return DotColors.getColorNames((String)colorScheme2.toValue());
        }
        AttrStmt attrStmt = (AttrStmt)EcoreUtil2.getContainerOfType((EObject)attribute, AttrStmt.class);
        if (attrStmt != null && (colorScheme = DotAstHelper.getAttributeValue((List)attrStmt.getAttrLists(), (String)"colorscheme")) != null) {
            return DotColors.getColorNames((String)colorScheme.toValue());
        }
        return DotColors.getColorNames((String)"x11");
    }
}

