/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.AddSourceFolderWizardPage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SetFilterWizardPage;
import org.eclipse.jface.wizard.IWizardPage;

public class AddSourceFolderWizard
extends BuildPathWizard {
    private AddSourceFolderWizardPage fAddFolderPage;
    private SetFilterWizardPage fFilterPage;
    private final boolean fLinkedMode;
    private boolean fAllowConflict;
    private final boolean fAllowRemoveProjectFolder;
    private final boolean fAllowAddExclusionPatterns;
    private final boolean fCanCommitConflict;
    private final IContainer fParent;

    public AddSourceFolderWizard(CPListElement[] existingEntries, CPListElement newEntry, IPath outputLocation, boolean linkedMode, boolean canCommitConflict, boolean allowConflict, boolean allowRemoveProjectFolder, boolean allowAddExclusionPatterns) {
        this(existingEntries, newEntry, outputLocation, linkedMode, canCommitConflict, allowConflict, allowRemoveProjectFolder, allowAddExclusionPatterns, (IContainer)newEntry.getJavaProject().getProject());
    }

    public AddSourceFolderWizard(CPListElement[] existingEntries, CPListElement newEntry, IPath outputLocation, boolean linkedMode, boolean canCommitConflict, boolean allowConflict, boolean allowRemoveProjectFolder, boolean allowAddExclusionPatterns, IContainer parent) {
        super(existingEntries, newEntry, outputLocation, AddSourceFolderWizard.getTitel(newEntry, linkedMode), JavaPluginImages.DESC_WIZBAN_NEWSRCFOLDR);
        this.fLinkedMode = linkedMode;
        this.fCanCommitConflict = canCommitConflict;
        this.fAllowConflict = allowConflict;
        this.fAllowRemoveProjectFolder = allowRemoveProjectFolder;
        this.fAllowAddExclusionPatterns = allowAddExclusionPatterns;
        this.fParent = parent;
    }

    private static String getTitel(CPListElement newEntry, boolean linkedMode) {
        if (newEntry.getPath() == null) {
            if (linkedMode) {
                return NewWizardMessages.NewSourceFolderCreationWizard_link_title;
            }
            return NewWizardMessages.NewSourceFolderCreationWizard_title;
        }
        return NewWizardMessages.NewSourceFolderCreationWizard_edit_title;
    }

    public void addPages() {
        super.addPages();
        this.fAddFolderPage = new AddSourceFolderWizardPage(this.getEntryToEdit(), this.getExistingEntries(), this.getOutputLocation(), this.fLinkedMode, this.fCanCommitConflict, this.fAllowConflict, this.fAllowRemoveProjectFolder, this.fAllowAddExclusionPatterns, this.fParent);
        this.addPage((IWizardPage)this.fAddFolderPage);
        this.fFilterPage = new SetFilterWizardPage(this.getEntryToEdit(), this.getExistingEntries(), this.getOutputLocation());
        this.addPage((IWizardPage)this.fFilterPage);
    }

    @Override
    public List<CPListElement> getInsertedElements() {
        List<CPListElement> result = super.getInsertedElements();
        if (this.getEntryToEdit().getOrginalPath() == null) {
            result.add(this.getEntryToEdit());
        }
        return result;
    }

    @Override
    public List<CPListElement> getRemovedElements() {
        return this.fAddFolderPage.getRemovedElements();
    }

    @Override
    public List<CPListElement> getModifiedElements() {
        return this.fAddFolderPage.getModifiedElements();
    }

    @Override
    public boolean performFinish() {
        this.getEntryToEdit().setAttribute("inclusion", this.fFilterPage.getInclusionPattern());
        this.getEntryToEdit().setAttribute("exclusion", this.fFilterPage.getExclusionPattern());
        this.setOutputLocation(this.fAddFolderPage.getOutputLocation());
        boolean res = super.performFinish();
        if (res) {
            this.selectAndReveal(this.fAddFolderPage.getCorrespondingResource());
        }
        return res;
    }

    @Override
    public void cancel() {
        this.fAddFolderPage.restore();
    }
}

