/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jubula.autagent.commands.AbstractStartJavaAutServer;
import org.eclipse.jubula.autagent.commands.AbstractStartToolkitAut;
import org.eclipse.jubula.tools.internal.utils.MonitoringUtil;
import org.osgi.framework.Bundle;

public class StartSwingAutServerCommand
extends AbstractStartJavaAutServer {
    private String m_autServerClasspath = "AutServerClasspath";

    @Override
    protected String[] createCmdArray(String baseCmd, Map<String, String> parameters) {
        Vector<String> cmds = new Vector<String>();
        cmds.add(baseCmd);
        StringBuffer autServerClasspath = new StringBuffer();
        this.createServerClasspath(autServerClasspath);
        ArrayList<String> autAgentArgs = new ArrayList<String>();
        autAgentArgs.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autAgentHost")));
        autAgentArgs.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autAgentPort")));
        autAgentArgs.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autName")));
        if (!this.isRunningFromExecutable(parameters)) {
            this.createAutServerLauncherClasspath(cmds, autServerClasspath, parameters);
            this.createAutServerClasspath(autServerClasspath, cmds, parameters);
            cmds.addAll(autAgentArgs);
            cmds.add("false");
        } else {
            String serverBasePath = this.createServerBasePath();
            autServerClasspath.append(PATH_SEPARATOR).append(serverBasePath).append(PATH_SEPARATOR).append(this.getRcBundleClassPath());
            this.m_autServerClasspath = autServerClasspath.toString();
        }
        cmds.addAll(this.createAutArguments(parameters));
        return cmds.toArray(new String[cmds.size()]);
    }

    @Override
    protected String[] createEnvArray(Map<String, String> parameters, boolean isAgentSet) {
        if (this.isRunningFromExecutable(parameters) || MonitoringUtil.shouldAndCanRunWithMonitoring(parameters)) {
            this.setEnv(parameters, this.m_autServerClasspath);
            boolean agentActive = true;
            return super.createEnvArray(parameters, agentActive);
        }
        return super.createEnvArray(parameters, isAgentSet);
    }

    @Override
    protected String getRcBundleClassPath() {
        Bundle rcBundle = AbstractStartToolkitAut.getBundleForID(this.getRcBundleId());
        List<String> classList = AbstractStartToolkitAut.getPathforBundle(rcBundle);
        return AbstractStartToolkitAut.createClassPath(classList.toArray(new String[classList.size()]));
    }

    @Override
    public String getRcBundleId() {
        return "org.eclipse.jubula.rc.swing";
    }

    @Override
    protected String getAbsoluteAgentJarPath() {
        return AbstractStartToolkitAut.getClasspathForBundleId("org.eclipse.jubula.rc.common.agent");
    }

    @Override
    protected String getServerClassName() {
        return "org.eclipse.jubula.rc.swing.SwingAUTServer";
    }
}

