/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IProjectNamePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.utils.NameValidationUtil;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectNameBP {
    private static Logger log = LoggerFactory.getLogger(ProjectNameBP.class);
    private static ProjectNameBP instance = null;
    private Map<String, String> m_names = new HashMap<String, String>();
    private Map<String, String> m_transientNames = new HashMap<String, String>();

    private ProjectNameBP() {
    }

    public String getName(String guid) {
        return this.getName(guid, true);
    }

    public String getName(String guid, boolean useCache) {
        if (guid == null) {
            return null;
        }
        String res = null;
        if (useCache && (res = this.m_transientNames.get(guid)) == null && this.m_names.containsKey(guid)) {
            return this.m_names.get(guid);
        }
        if (res == null) {
            try {
                res = this.readProjectNameFromDB(guid);
            }
            catch (PMException e) {
                log.warn(e.getLocalizedMessage(), (Throwable)((Object)e));
            }
        }
        this.m_names.put(guid, res);
        return res;
    }

    private synchronized String readProjectNameFromDB(String projectGuid) throws PMException {
        if (projectGuid == null) {
            return null;
        }
        EntityManager session = Persistor.instance().openSession();
        try {
            Query q = session.createQuery("select projectName from ProjectNamePO as projectName where projectName.hbmGuid = :projectGuid");
            q.setParameter("projectGuid", (Object)projectGuid);
            try {
                String string = ((IProjectNamePO)q.getSingleResult()).getName();
                return string;
            }
            catch (NoResultException noResultException) {
                try {
                }
                catch (PersistenceException e) {
                    PersistenceManager.handleDBExceptionForAnySession(null, e, session);
                }
            }
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
        return null;
    }

    public synchronized Map<String, String> readAllProjectNamesFromDB() throws PMException {
        EntityManager session = Persistor.instance().openSession();
        try {
            Query q = session.createQuery("select name from ProjectNamePO name");
            List projectNameList = q.getResultList();
            HashMap<String, String> guidToNameMap = new HashMap<String, String>();
            for (IProjectNamePO projectName : projectNameList) {
                guidToNameMap.put(projectName.getGuid(), projectName.getName());
            }
            HashMap<String, String> hashMap = guidToNameMap;
            return hashMap;
        }
        catch (PersistenceException e) {
            PersistenceManager.handleDBExceptionForAnySession(null, e, session);
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
        return null;
    }

    public void checkAndDeleteName(String guid) throws PMException, ProjectDeletedException {
        EntityManager session = null;
        try {
            try {
                session = Persistor.instance().openSession();
                EntityTransaction tx = Persistor.instance().getTransaction(session);
                if (!this.isGuidBeingUsed(session, guid)) {
                    this.deleteName(session, guid);
                }
                Persistor.instance().commitTransaction(session, tx);
                this.m_names.remove(guid);
                this.m_transientNames.remove(guid);
            }
            catch (PersistenceException he) {
                StringBuilder msgbuid = new StringBuilder();
                msgbuid.append(Messages.CouldNotDeleteProjectName);
                msgbuid.append("(");
                msgbuid.append(Messages.ForGuid);
                msgbuid.append(guid);
                msgbuid.append(")");
                msgbuid.append(Messages.FromTheDatabase);
                msgbuid.append(".");
                log.error(msgbuid.toString(), (Throwable)he);
                Persistor.instance().dropSession(session);
            }
        }
        finally {
            Persistor.instance().dropSession(session);
        }
    }

    private synchronized boolean isGuidBeingUsed(EntityManager session, String guid) {
        Long hits = null;
        Query q = session.createQuery("select count(project) from ProjectPO as project where project.guid = :guid");
        q.setParameter("guid", (Object)guid);
        hits = (Long)q.getSingleResult();
        return hits != null && hits.intValue() > 0;
    }

    private synchronized void deleteName(EntityManager session, String guid) {
        Query q = session.createQuery("delete from ProjectNamePO name where name.hbmGuid = :guid");
        q.setParameter("guid", (Object)guid);
        q.executeUpdate();
    }

    public void setName(String guid, String newProjectName, boolean doPersist) {
        block8: {
            if (guid == null || newProjectName == null) {
                return;
            }
            if (doPersist) {
                EntityManager session = Persistor.instance().openSession();
                try {
                    try {
                        EntityTransaction tx = Persistor.instance().getTransaction(session);
                        this.setName(session, guid, newProjectName);
                        Persistor.instance().commitTransaction(session, tx);
                        break block8;
                    }
                    catch (PMException e) {
                        throw new JBFatalException(String.valueOf(Messages.SavingProjectFailed) + ".", (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
                    }
                    catch (ProjectDeletedException e) {
                        throw new JBFatalException(String.valueOf(Messages.SavingProjectFailed) + ".", (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
                    }
                }
                finally {
                    Persistor.instance().dropSession(session);
                }
            }
            this.setTransientName(guid, newProjectName);
        }
    }

    private void setTransientName(String guid, String newProjectName) {
        if (this.m_names.containsKey(guid)) {
            log.debug("setTransientName() " + Messages.CalledForPersistantObject + ".");
            this.m_names.put(guid, newProjectName);
        } else {
            this.m_transientNames.put(guid, newProjectName);
        }
    }

    public synchronized void storeTransientNames(EntityManager s) {
        HashMap<String, String> workMap = new HashMap<String, String>(this.m_transientNames);
        for (Map.Entry name : workMap.entrySet()) {
            this.setName(s, (String)name.getKey(), (String)name.getValue());
        }
        this.m_transientNames.clear();
    }

    public synchronized void setName(EntityManager session, String guid, String newProjectName) {
        if (guid == null || newProjectName == null) {
            return;
        }
        Query q = session.createQuery("select projectName from ProjectNamePO projectName where projectName.hbmGuid = :projectGuid");
        q.setParameter("projectGuid", (Object)guid);
        IProjectNamePO projectName = null;
        try {
            projectName = (IProjectNamePO)q.getSingleResult();
        }
        catch (NoResultException noResultException) {
            projectName = PoMaker.createProjectNamePO(guid, newProjectName);
            session.persist((Object)projectName);
        }
        projectName.setName(newProjectName);
        this.m_names.put(projectName.getGuid(), projectName.getName());
        this.m_transientNames.remove(guid);
    }

    public void clearCache() {
        this.m_names.clear();
        this.m_transientNames.clear();
    }

    public static ProjectNameBP getInstance() {
        if (instance == null) {
            instance = new ProjectNameBP();
        }
        return instance;
    }

    public static boolean isValidProjectName(String name, boolean checkSpaces) {
        if (checkSpaces) {
            if (name.startsWith(" ")) {
                return false;
            }
            if (name.endsWith(" ")) {
                return false;
            }
        }
        return NameValidationUtil.containsNoIllegalChars(name);
    }
}

