/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.ProjectCompNameCache;
import org.eclipse.jubula.client.core.datastructure.CompNameUsageMap;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITcParamDescriptionPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.ComponentNameExistsException;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.messagehandling.MessageInfo;

public class MultipleNodePM
extends PersistenceManager {
    private static MultipleNodePM persManager = null;

    public static MultipleNodePM getInstance() {
        if (persManager == null) {
            persManager = new MultipleNodePM();
        }
        return persManager;
    }

    public MessageInfo executeCommands(List<AbstractCmdHandle> cmds) throws PMException, ProjectDeletedException {
        return this.executeCommands(cmds, GeneralStorage.getInstance().getMasterSession());
    }

    public MessageInfo executeCommands(List<AbstractCmdHandle> cmds, EntityManager sess) throws PMException, ProjectDeletedException {
        Persistor persistor = Persistor.instance();
        EntityTransaction tx = null;
        HashSet<IPersistentObject> objectsToLock = new HashSet<IPersistentObject>();
        IPersistentObject actObj = null;
        for (AbstractCmdHandle cmd : cmds) {
            objectsToLock.addAll(cmd.getObjsToLock());
        }
        try {
            tx = persistor.getTransaction(sess);
            persistor.lockPOSet(sess, objectsToLock);
            ParamNameBPDecorator dec = null;
            for (AbstractCmdHandle cmd : cmds) {
                MessageInfo errorMessage = cmd.execute(sess);
                if (errorMessage != null) {
                    persistor.rollbackTransaction(sess, tx);
                    return errorMessage;
                }
                if (!(cmd instanceof DeleteTCHandle)) continue;
                dec = ((DeleteTCHandle)cmd).getDec();
            }
            if (dec != null) {
                this.deleteParamNames(dec, sess);
            }
            persistor.commitTransaction(sess, tx);
            if (dec != null) {
                Long projId = GeneralStorage.getInstance().getProject().getId();
                dec.updateStandardMapperAndCleanup(projId);
            }
            EntityManager master = GeneralStorage.getInstance().getMasterSession();
            for (AbstractCmdHandle cmd : cmds) {
                if (!(cmd instanceof UpdateParamNamesHandle)) continue;
                UpdateParamNamesHandle paramCmd = (UpdateParamNamesHandle)cmd;
                for (IParamNamePO paramName : paramCmd.getParamNames()) {
                    master.detach((Object)paramName);
                }
            }
            for (IPersistentObject next : objectsToLock) {
                IPersistentObject obj = (IPersistentObject)master.find(next.getClass(), (Object)next.getId());
                if (obj == null) continue;
                try {
                    master.refresh((Object)obj);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    master.detach((Object)obj);
                }
            }
        }
        catch (PersistenceException e1) {
            PersistenceManager.handleDBExceptionForMasterSession(actObj, e1);
        }
        return null;
    }

    private void deleteParamNames(ParamNameBPDecorator dec, EntityManager s) {
        try {
            dec.persist(s, GeneralStorage.getInstance().getProject().getId());
        }
        catch (PMException e) {
            throw new PersistenceException((Throwable)((Object)e));
        }
    }

    private static boolean isNestedNode(INodePO node) {
        boolean isNested = false;
        INodePO parent = node.getParentNode();
        if (parent != null && parent != ISpecObjContPO.TCB_ROOT_NODE && parent != IExecObjContPO.TSB_ROOT_NODE) {
            isNested = true;
        }
        return isNested;
    }

    public static void collectAffectedNodes(List<INodePO> affectedNodes, INodePO node) {
        ISpecTestCasePO specTcPO;
        affectedNodes.add(node);
        if (node instanceof ICategoryPO) {
            Iterator<INodePO> iter = node.getNodeListIterator();
            while (iter.hasNext()) {
                MultipleNodePM.collectAffectedNodes(affectedNodes, iter.next());
            }
        } else if (node instanceof ISpecTestCasePO && !(specTcPO = (ISpecTestCasePO)node).getAllEventEventExecTC().isEmpty()) {
            affectedNodes.addAll(specTcPO.getAllEventEventExecTC());
        }
    }

    public static boolean allExecsFromList(Collection<INodePO> affectedNodes, List<IExecTestCasePO> execTestCases) {
        if (execTestCases.isEmpty()) {
            return true;
        }
        for (IExecTestCasePO execTc : execTestCases) {
            INodePO parent = execTc.getSpecAncestor();
            if (affectedNodes.contains(parent)) continue;
            return false;
        }
        return true;
    }

    public static abstract class AbstractCmdHandle {
        private final Set<IPersistentObject> m_objsToLock = new HashSet<IPersistentObject>();

        public final Set<IPersistentObject> getObjsToLock() {
            return this.m_objsToLock;
        }

        public abstract MessageInfo execute(EntityManager var1);
    }

    public static class AddExecTCHandle
    extends AbstractCmdHandle {
        private INodePO m_parent;
        private Integer m_index;
        private IExecTestCasePO m_newExec;

        public AddExecTCHandle(INodePO parent, IExecTestCasePO newExec, Integer index) {
            this.getObjsToLock().add(parent);
            this.m_parent = parent;
            this.m_index = index;
            this.m_newExec = newExec;
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            sess.persist((Object)this.m_newExec);
            INodePO parent = (INodePO)sess.find(this.m_parent.getClass(), (Object)this.m_parent.getId());
            if (this.m_newExec instanceof IEventExecTestCasePO) {
                if (parent instanceof ISpecTestCasePO) {
                    ISpecTestCasePO spec = (ISpecTestCasePO)parent;
                    try {
                        spec.addEventTestCase((IEventExecTestCasePO)this.m_newExec);
                        return null;
                    }
                    catch (InvalidDataException e) {
                        return new MessageInfo(e.getErrorId(), null);
                    }
                }
                return new MessageInfo(MessageIDs.E_EVENT_SUPPORT, null);
            }
            parent.addNode(this.m_index, this.m_newExec);
            return null;
        }
    }

    public static class DeleteCatHandle
    extends AbstractCmdHandle {
        private ICategoryPO m_category;

        public DeleteCatHandle(ICategoryPO cat) {
            this.m_category = cat;
            this.getObjsToLock().add(cat);
            if (MultipleNodePM.isNestedNode(cat)) {
                this.getObjsToLock().add(cat.getParentNode());
            } else {
                IProjectPO proj = GeneralStorage.getInstance().getProject();
                INodePO parent = this.m_category.getParentNode();
                if (parent == ISpecObjContPO.TCB_ROOT_NODE) {
                    this.getObjsToLock().add(proj.getSpecObjCont());
                } else if (parent == IExecObjContPO.TSB_ROOT_NODE) {
                    this.getObjsToLock().add(proj.getExecObjCont());
                }
            }
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            ICategoryPO cat = (ICategoryPO)sess.find(this.m_category.getClass(), (Object)this.m_category.getId());
            INodePO par = this.m_category.getParentNode();
            if (MultipleNodePM.isNestedNode(this.m_category)) {
                par = (INodePO)sess.find(par.getClass(), (Object)par.getId());
                par.removeNode(cat);
            } else {
                IProjectPO proj = GeneralStorage.getInstance().getProject();
                if (par == ISpecObjContPO.TCB_ROOT_NODE) {
                    ISpecObjContPO cont = proj.getSpecObjCont();
                    cont = (ISpecObjContPO)sess.find(cont.getClass(), (Object)cont.getId());
                    cont.removeSpecObject(cat);
                } else if (par == IExecObjContPO.TSB_ROOT_NODE) {
                    IExecObjContPO cont = proj.getExecObjCont();
                    cont = (IExecObjContPO)sess.find(cont.getClass(), (Object)cont.getId());
                    cont.removeExecObject(cat);
                }
            }
            sess.remove((Object)cat);
            return null;
        }
    }

    public static class DeleteEvHandle
    extends AbstractCmdHandle {
        private IEventExecTestCasePO m_eventTestCase;

        public DeleteEvHandle(IEventExecTestCasePO tc) {
            this.m_eventTestCase = tc;
            this.getObjsToLock().add(tc);
            this.getObjsToLock().add(tc.getParentNode());
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            ISpecTestCasePO specTc = (ISpecTestCasePO)this.m_eventTestCase.getParentNode();
            specTc = (ISpecTestCasePO)sess.find(specTc.getClass(), (Object)specTc.getId());
            IEventExecTestCasePO evTC = (IEventExecTestCasePO)sess.find(this.m_eventTestCase.getClass(), (Object)this.m_eventTestCase.getId());
            specTc.removeNode(evTC);
            sess.remove((Object)evTC);
            return null;
        }
    }

    public static class DeleteExecHandle
    extends AbstractCmdHandle {
        private IExecPersistable m_execNode;

        public DeleteExecHandle(IExecPersistable exec) {
            this.m_execNode = exec;
            this.getObjsToLock().add(exec);
            if (MultipleNodePM.isNestedNode(exec)) {
                this.getObjsToLock().add(exec.getParentNode());
            } else {
                IProjectPO proj = GeneralStorage.getInstance().getProject();
                this.getObjsToLock().add(proj.getExecObjCont());
            }
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            IExecPersistable tc = (IExecPersistable)sess.find(this.m_execNode.getClass(), (Object)this.m_execNode.getId());
            if (MultipleNodePM.isNestedNode(this.m_execNode)) {
                INodePO par = this.m_execNode.getParentNode();
                par = (INodePO)sess.find(par.getClass(), (Object)par.getId());
                par.removeNode(tc);
            } else {
                IExecObjContPO cont = GeneralStorage.getInstance().getProject().getExecObjCont();
                cont = (IExecObjContPO)sess.find(cont.getClass(), (Object)cont.getId());
                cont.removeExecObject(tc);
            }
            sess.remove((Object)tc);
            return null;
        }
    }

    public static class DeleteExecTCHandle
    extends AbstractCmdHandle {
        private IExecTestCasePO m_execNode;

        public DeleteExecTCHandle(IExecTestCasePO exec) {
            this.m_execNode = exec;
            this.getObjsToLock().add(exec);
            if (MultipleNodePM.isNestedNode(exec)) {
                this.getObjsToLock().add(exec.getParentNode());
            } else {
                IProjectPO proj = GeneralStorage.getInstance().getProject();
                this.getObjsToLock().add(proj.getExecObjCont());
            }
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            IExecTestCasePO exec;
            if (MultipleNodePM.isNestedNode(this.m_execNode)) {
                this.m_execNode.getParentNode().removeNode(this.m_execNode);
            }
            if ((exec = (IExecTestCasePO)sess.find(this.m_execNode.getClass(), (Object)this.m_execNode.getId())) != null) {
                sess.remove((Object)exec);
            }
            return null;
        }
    }

    public static class DeleteTCHandle
    extends AbstractCmdHandle {
        private ISpecTestCasePO m_testCase;
        private ParamNameBPDecorator m_dec;

        public DeleteTCHandle(ISpecTestCasePO tc, ParamNameBPDecorator mapper) {
            this.m_testCase = tc;
            this.m_dec = mapper;
            this.getObjsToLock().add(tc);
            if (MultipleNodePM.isNestedNode(tc)) {
                this.getObjsToLock().add(tc.getParentNode());
            } else {
                IProjectPO proj = GeneralStorage.getInstance().getProject();
                this.getObjsToLock().add(proj.getSpecObjCont());
            }
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            ISpecTestCasePO tc = (ISpecTestCasePO)sess.find(this.m_testCase.getClass(), (Object)this.m_testCase.getId());
            if (MultipleNodePM.isNestedNode(this.m_testCase)) {
                INodePO par = this.m_testCase.getParentNode();
                par = (INodePO)sess.find(par.getClass(), (Object)par.getId());
                par.removeNode(tc);
            } else {
                ISpecObjContPO cont = GeneralStorage.getInstance().getProject().getSpecObjCont();
                cont = (ISpecObjContPO)sess.find(cont.getClass(), (Object)cont.getId());
                cont.removeSpecObject(tc);
            }
            this.registerParamNamesForDeletion(tc);
            sess.remove((Object)tc);
            return null;
        }

        private void registerParamNamesForDeletion(ISpecTestCasePO specTcPO) {
            for (IParamDescriptionPO desc : specTcPO.getParameterList()) {
                this.getDec().registerParamDescriptions((ITcParamDescriptionPO)desc);
                this.getDec().removeParamNamePO(desc.getUniqueId());
            }
        }

        public ParamNameBPDecorator getDec() {
            return this.m_dec;
        }
    }

    public static class MoveNodeHandle
    extends AbstractCmdHandle {
        private INodePO m_node;
        private IPersistentObject m_oldParent;
        private IPersistentObject m_newParent;

        public MoveNodeHandle(INodePO node, IPersistentObject oldParent, IPersistentObject newParent) {
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            this.m_oldParent = oldParent;
            if (oldParent == IExecObjContPO.TSB_ROOT_NODE) {
                this.m_oldParent = proj.getExecObjCont();
            } else if (oldParent == ISpecObjContPO.TCB_ROOT_NODE) {
                this.m_oldParent = proj.getSpecObjCont();
            }
            this.m_newParent = newParent;
            if (this.m_newParent == IExecObjContPO.TSB_ROOT_NODE) {
                this.m_newParent = proj.getExecObjCont();
            } else if (this.m_newParent == ISpecObjContPO.TCB_ROOT_NODE) {
                this.m_newParent = proj.getSpecObjCont();
            }
            this.m_node = node;
            this.getObjsToLock().add(this.m_node);
            this.getObjsToLock().add(this.m_oldParent);
            this.getObjsToLock().add(this.m_newParent);
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
            IPersistentObject oldParent = this.m_oldParent;
            IPersistentObject newParent = this.m_newParent;
            INodePO node = this.m_node;
            if (masterSession != sess) {
                masterSession.detach((Object)node);
                oldParent = (IPersistentObject)sess.find(oldParent.getClass(), (Object)oldParent.getId());
                newParent = (IPersistentObject)sess.find(newParent.getClass(), (Object)newParent.getId());
                node = (INodePO)sess.find(node.getClass(), (Object)node.getId());
            }
            if (node instanceof ISpecTestCasePO && !oldParent.getParentProjectId().equals(newParent.getParentProjectId())) {
                Iterator<INodePO> iter = node.getAllNodeIter();
                while (iter.hasNext()) {
                    INodePO child = iter.next();
                    if (!(child instanceof IExecTestCasePO)) continue;
                    IExecTestCasePO execTC = (IExecTestCasePO)child;
                    execTC.setReferencedDataCube(null);
                }
                ((ISpecTestCasePO)node).setReferencedDataCube(null);
            }
            if (oldParent instanceof ISpecObjContPO) {
                ((ISpecObjContPO)oldParent).removeSpecObject((ISpecPersistable)node);
            } else if (oldParent instanceof IExecObjContPO) {
                ((IExecObjContPO)oldParent).removeExecObject((IExecPersistable)node);
            } else {
                ((INodePO)oldParent).removeNode(node);
            }
            if (newParent instanceof ISpecObjContPO) {
                ((ISpecObjContPO)newParent).addSpecObject((ISpecPersistable)node);
            } else if (newParent instanceof IExecObjContPO) {
                ((IExecObjContPO)newParent).addExecObject((IExecPersistable)node);
            } else {
                ((INodePO)newParent).addNode(node);
            }
            return null;
        }
    }

    public static final class TransferCompNameHandle
    extends AbstractCmdHandle {
        private Map<IComponentNamePO, Set<INodePO>> m_firstCompNameToUsers = new HashMap<IComponentNamePO, Set<INodePO>>();
        private Map<IComponentNamePO, Set<INodePO>> m_secondCompNameToUsers;
        private Long m_currentProjectId = null;
        private IProjectPO m_newParentProj = null;

        public TransferCompNameHandle(CompNameUsageMap usageMap, Long currentProjectId, IProjectPO newParentProj) {
            HashSet<INodePO> users;
            for (IComponentNamePO compName : usageMap.getFirstCompNames()) {
                users = new HashSet<INodePO>();
                users.addAll(usageMap.getFirstNameUsers(compName));
                this.m_firstCompNameToUsers.put(compName, users);
            }
            this.m_secondCompNameToUsers = new HashMap<IComponentNamePO, Set<INodePO>>();
            for (IComponentNamePO compName : usageMap.getSecondCompNames()) {
                users = new HashSet();
                users.addAll(usageMap.getSecondNameUsers(compName));
                this.m_secondCompNameToUsers.put(compName, users);
            }
            this.m_currentProjectId = currentProjectId;
            this.m_newParentProj = newParentProj;
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            ProjectCompNameCache extProjectCompCache = new ProjectCompNameCache(this.m_newParentProj);
            try {
                HashMap<String, IComponentNamePO> createdComponentNames = new HashMap<String, IComponentNamePO>();
                createdComponentNames.putAll(this.handleFirstNames(sess, extProjectCompCache));
                createdComponentNames.putAll(this.handleSecondNames(sess, extProjectCompCache));
                for (String guid : createdComponentNames.keySet()) {
                    this.handleMapping(sess, extProjectCompCache, guid, (IComponentNamePO)createdComponentNames.get(guid));
                }
                CompNamePM.flushCompNames(sess, this.m_newParentProj.getId(), extProjectCompCache);
            }
            catch (PMException e) {
                return new MessageInfo(e.getErrorId(), null);
            }
            catch (ComponentNameExistsException e) {
                return new MessageInfo(e.getErrorId(), e.getErrorMessageParams());
            }
            return null;
        }

        private void handleMapping(EntityManager sess, IWritableComponentNameCache extProjectCompCache, String originalGuid, IComponentNamePO compName) throws PMException {
            IProjectPO currentProject = (IProjectPO)sess.find(NodeMaker.getProjectPOClass(), (Object)this.m_currentProjectId);
            for (IAUTMainPO aut : currentProject.getAutMainList()) {
                if (!LockManager.instance().lockPO(sess, aut, true)) continue;
                IObjectMappingAssoziationPO assoc = aut.getObjMap().getLogicalNameAssoc(originalGuid);
                extProjectCompCache.changeReuse(assoc, null, compName.getGuid());
            }
        }

        private Map<String, IComponentNamePO> handleSecondNames(EntityManager sess, IWritableComponentNameCache extProjectCompCache) {
            HashMap<String, IComponentNamePO> createdNames = new HashMap<String, IComponentNamePO>();
            Map<IComponentNamePO, Set<INodePO>> secondCompNameToUsers = this.loadInSession(sess, this.m_secondCompNameToUsers);
            for (IComponentNamePO compName : secondCompNameToUsers.keySet()) {
                IComponentNamePO existingExtCompName = this.getCompNamePOForName(compName.getName(), extProjectCompCache, this.m_newParentProj.getId());
                if (existingExtCompName != null && existingExtCompName.getParentProjectId().equals(this.m_newParentProj.getId())) {
                    this.updateSecondNameUsers(extProjectCompCache, secondCompNameToUsers, compName, existingExtCompName);
                    continue;
                }
                String compType = ComponentBuilder.getInstance().getCompSystem().getMostAbstractComponent().getType();
                IComponentNamePO newCompName = extProjectCompCache.createComponentNamePO(compName.getName(), compType, ComponentNamesBP.CompNameCreationContext.OVERRIDDEN_NAME);
                extProjectCompCache.addCompNamePO(newCompName);
                newCompName.setParentProjectId(this.m_newParentProj.getId());
                createdNames.put(compName.getGuid(), newCompName);
                this.updateSecondNameUsers(extProjectCompCache, secondCompNameToUsers, compName, newCompName);
            }
            return createdNames;
        }

        private void updateSecondNameUsers(IWritableComponentNameCache extProjectCompCache, Map<IComponentNamePO, Set<INodePO>> secondCompNameToUsers, IComponentNamePO compName, IComponentNamePO existingExtCompName) {
            for (INodePO node : secondCompNameToUsers.get(compName)) {
                if (node instanceof ICapPO) {
                    ICapPO capPo = (ICapPO)node;
                    extProjectCompCache.changeReuse(capPo, capPo.getComponentName(), existingExtCompName.getGuid());
                    continue;
                }
                if (!(node instanceof IExecTestCasePO)) continue;
                for (ICompNamesPairPO pair : ((IExecTestCasePO)node).getCompNamesPairs()) {
                    if (!pair.getSecondName().equals(compName.getGuid())) continue;
                    extProjectCompCache.changeReuse(pair, pair.getSecondName(), existingExtCompName.getGuid());
                }
            }
        }

        private Map<String, IComponentNamePO> handleFirstNames(EntityManager sess, IWritableComponentNameCache compCache) throws ComponentNameExistsException {
            HashMap<String, IComponentNamePO> createdComponentNames = new HashMap<String, IComponentNamePO>();
            Map<IComponentNamePO, Set<INodePO>> firstCompNameToUsers = this.loadInSession(sess, this.m_firstCompNameToUsers);
            for (IComponentNamePO compName : firstCompNameToUsers.keySet()) {
                if (!compName.getParentProjectId().equals(this.m_currentProjectId)) continue;
                IComponentNamePO existingExtCompName = this.getCompNamePOForName(compName.getName(), compCache, this.m_newParentProj.getId());
                if (existingExtCompName != null && existingExtCompName.getParentProjectId().equals(this.m_newParentProj.getId())) {
                    throw new ComponentNameExistsException("Cannot perform move operation.", MessageIDs.E_MOVE_TC_COMP_NAME_EXISTS, new String[]{existingExtCompName.getName()});
                }
                String compType = ComponentBuilder.getInstance().getCompSystem().getMostAbstractComponent().getType();
                IComponentNamePO newCompName = compCache.createComponentNamePO(compName.getName(), compType, ComponentNamesBP.CompNameCreationContext.STEP);
                compCache.addCompNamePO(newCompName);
                newCompName.setParentProjectId(this.m_newParentProj.getId());
                createdComponentNames.put(compName.getGuid(), newCompName);
                for (INodePO node : firstCompNameToUsers.get(compName)) {
                    if (!(node instanceof IExecTestCasePO)) continue;
                    for (ICompNamesPairPO pair : ((IExecTestCasePO)node).getCompNamesPairs()) {
                        if (!pair.getFirstName().equals(compName.getGuid())) continue;
                        pair.setFirstName(newCompName.getGuid());
                    }
                }
            }
            return createdComponentNames;
        }

        private Map<IComponentNamePO, Set<INodePO>> loadInSession(EntityManager sess, Map<IComponentNamePO, Set<INodePO>> toLoad) {
            HashMap<IComponentNamePO, Set<INodePO>> sessionMap = new HashMap<IComponentNamePO, Set<INodePO>>();
            for (IComponentNamePO compName : toLoad.keySet()) {
                HashSet<INodePO> userSet = new HashSet<INodePO>();
                for (INodePO node : toLoad.get(compName)) {
                    userSet.add((INodePO)sess.find(node.getClass(), (Object)node.getId()));
                }
                sessionMap.put((IComponentNamePO)sess.find(compName.getClass(), (Object)compName.getId()), userSet);
            }
            return sessionMap;
        }

        private IComponentNamePO getCompNamePOForName(String name, IComponentNameCache compNameCache, Long parentProjectId) {
            String guid = compNameCache.getGuidForName(name, parentProjectId);
            if (guid != null) {
                return compNameCache.getResCompNamePOByGuid(guid);
            }
            return null;
        }
    }

    public static class UpdateParamNamesHandle
    extends AbstractCmdHandle {
        private List<ISpecTestCasePO> m_specTestCases;
        private IProjectPO m_reusedProject;
        private List<IParamNamePO> m_paramNames = new ArrayList<IParamNamePO>();

        public UpdateParamNamesHandle(List<ISpecTestCasePO> specTCs, IProjectPO reusedProject) {
            this.m_specTestCases = specTCs;
            this.m_reusedProject = reusedProject;
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            for (ISpecTestCasePO specTC : this.m_specTestCases) {
                for (IParamDescriptionPO desc : specTC.getParameterList()) {
                    IParamNamePO paramNamePO = ParamNameBP.getInstance().getParamNamePO(desc.getUniqueId());
                    if (paramNamePO == null) continue;
                    paramNamePO.setParentProjectId(this.m_reusedProject.getId());
                    this.m_paramNames.add(paramNamePO);
                    sess.merge((Object)paramNamePO);
                    this.getObjsToLock().add(paramNamePO);
                }
            }
            return null;
        }

        List<IParamNamePO> getParamNames() {
            return this.m_paramNames;
        }
    }

    public static class UpdateTestCaseRefHandle
    extends AbstractCmdHandle {
        private IExecTestCasePO m_execTc;
        private ISpecTestCasePO m_specTc;

        public UpdateTestCaseRefHandle(IExecTestCasePO execTc, ISpecTestCasePO specTc) {
            this.m_execTc = execTc;
            this.m_specTc = specTc;
            this.getObjsToLock().add(this.m_execTc);
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            ISpecTestCasePO specTc = (ISpecTestCasePO)sess.find(this.m_specTc.getClass(), (Object)this.m_specTc.getId());
            IExecTestCasePO execTc = (IExecTestCasePO)sess.find(this.m_execTc.getClass(), (Object)this.m_execTc.getId());
            execTc.setSpecTestCase(specTc);
            return null;
        }
    }
}

