/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.internal.message.AUTServerStateMessage;
import org.eclipse.jubula.communication.internal.message.AUTStartMessage;
import org.eclipse.jubula.communication.internal.message.ChangeAUTModeMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.rc.common.AutServerLauncher;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.adaptable.IAdapterFactory;
import org.eclipse.jubula.rc.common.commands.AUTStartCommand;
import org.eclipse.jubula.rc.common.commands.ChangeAUTModeCommand;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.exception.ComponentNotFoundException;
import org.eclipse.jubula.rc.common.listener.AUTEventListener;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.rc.common.listener.IAutListenerAppender;
import org.eclipse.jubula.rc.common.registration.AgentRegisterAut;
import org.eclipse.jubula.rc.common.registration.IRegisterAut;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.ClassPathHacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AUTServer {
    private static Logger log = LoggerFactory.getLogger(AUTServer.class);
    private static AUTServer instance = null;
    private static String autServerName;
    private Communicator m_iteCommunicator;
    private Communicator m_autAgentCommunicator;
    private ICommunicationErrorListener m_communicationListener;
    private ICommunicationErrorListener m_serverCommunicationListener;
    private String m_autMainClassName;
    private Class<?> m_autMainClass;
    private Method m_autMainMethod;
    private Thread m_autThread;
    private String[] m_autArgs;
    private boolean m_isAgentObjectMapping = false;
    private int m_mode = 1;
    private boolean m_isAutRunning = false;
    private boolean m_isObservingDialogOpen = false;
    private long m_observTimestamp = 0L;
    private AUTEventListener m_mappingListener;
    private AUTEventListener m_recordListener;
    private AUTEventListener m_checkListener;
    private boolean m_isRcpAccessible;
    private boolean m_isAgentSet = false;
    private List<IAutListenerAppender> m_inspectorListenerAppenders = new ArrayList<IAutListenerAppender>();
    private String m_autAgentHost;
    private String m_autAgentPort;
    private String m_autID;
    private List<String> m_errors = new ArrayList<String>();
    private List<String> m_warnings = new ArrayList<String>();
    private ClassLoader m_externalLoader = null;
    private WeakReference<IComponent> m_errorComponent = null;

    protected AUTServer(AUTEventListener mappingListener, AUTEventListener recordListener, AUTEventListener checkListener) {
        this.m_communicationListener = new ClientCommunicationListener();
        this.m_serverCommunicationListener = new AgentCommunicationListener();
        this.m_mappingListener = mappingListener;
        this.m_recordListener = recordListener;
        this.m_checkListener = checkListener;
        this.initExternalLoader();
    }

    private void initExternalLoader() {
        try {
            File dir;
            File[] res;
            String start = AUTServer.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (System.getProperty("os.name").startsWith("Win")) {
                start = start.substring(1, start.length());
            }
            if ((res = (dir = new File(start = start.replaceFirst("plugins/[^/]*$", "externaljars"))).listFiles(new FilenameFilter(){

                public boolean accept(File directory, String name) {
                    return name.endsWith(".jar");
                }
            })) == null) {
                return;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            int i = 0;
            while (i < res.length) {
                try {
                    urls.add(res[i].toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
                ++i;
            }
            if (!urls.isEmpty()) {
                this.m_externalLoader = new URLClassLoader(urls.toArray(new URL[0]));
            }
        }
        catch (Exception exception) {}
    }

    protected void setArgs(String[] args) {
        this.m_autMainClassName = args[1];
        this.m_autAgentHost = args[4];
        this.m_autAgentPort = args[5];
        this.m_autID = args[6];
        int numberAutArgs = args.length - 8;
        this.m_autArgs = new String[numberAutArgs];
        int i = 0;
        while (i < numberAutArgs) {
            this.m_autArgs[i] = args[8 + i];
            ++i;
        }
        if (args.length == 8 && args[7].equals("true")) {
            this.m_isAgentSet = true;
        }
    }

    public String[] getAutArgs() {
        return this.m_autArgs;
    }

    public String getAutMainClassName() {
        return this.m_autMainClassName;
    }

    public Class<?> getAutMainClass() {
        return this.m_autMainClass;
    }

    public Method getAutMainMethod() {
        return this.m_autMainMethod;
    }

    public synchronized Communicator getCommunicator() {
        if (this.m_isAgentObjectMapping) {
            return this.m_autAgentCommunicator;
        }
        return this.m_iteCommunicator;
    }

    public synchronized Communicator getServerCommunicator() {
        return this.m_autAgentCommunicator;
    }

    protected AUTEventListener getMappingListener() {
        return this.m_mappingListener;
    }

    public static AUTServer getInstance() {
        if (instance == null) {
            try {
                instance = (AUTServer)Class.forName(autServerName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                log.error("creating an AUTServer sharedInstance for " + autServerName + "failed:" + cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                log.error("creating an AUTServer sharedInstance for " + autServerName + "failed:" + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                log.error("creating an AUTServer sharedInstance for " + autServerName + "failed:" + iae.getMessage());
            }
            AdapterFactoryRegistry.initRegistration();
        }
        return instance;
    }

    public static void main(String[] args) {
        AUTServer.validateAndLogMainArgsCount(args, 8);
        autServerName = args[3];
        AUTServer.getInstance().setArgs(args);
        AUTServer.getInstance().start(false);
    }

    protected static void validateAndLogMainArgsCount(String[] args, int noOfRequiredArgs) {
        if (args.length < noOfRequiredArgs) {
            log.error("wrong number of arguments: must be at least " + String.valueOf(noOfRequiredArgs) + ", but were " + Arrays.asList(args).toString());
            System.exit(2);
        }
        if (log.isDebugEnabled()) {
            StringBuffer logMessage = new StringBuffer("Arguments to AUTServer\n");
            int i = 0;
            while (i < args.length) {
                logMessage.append(String.valueOf(i));
                logMessage.append(String.valueOf(args[i]) + "\n");
                ++i;
            }
            log.debug(logMessage.toString());
        }
        if (log.isInfoEnabled()) {
            log.info(System.getProperty("java.version"));
            log.info("user.dir:" + System.getProperty("user.dir"));
        }
    }

    public void startAUT() {
        if (this.isRcpAccessible()) {
            return;
        }
        if (this.isAgentSet()) {
            this.startToolkitThread();
            this.addToolKitEventListenerToAUT();
            return;
        }
        this.setAutThread(new Thread(new Runnable(){

            public void run() {
                try {
                    AUTServer.this.startTasks();
                }
                catch (ExceptionInInitializerError e) {
                    log.error(String.valueOf(e), (Throwable)e);
                    System.exit(25);
                }
                catch (InvocationTargetException e) {
                    String exception = String.valueOf(e);
                    String targetException = String.valueOf(e.getTargetException());
                    String message = String.valueOf(exception) + " TargetException: " + targetException;
                    log.error(message, (Throwable)e);
                    System.exit(25);
                }
                catch (NoSuchMethodException e) {
                    log.error(String.valueOf(e), (Throwable)e);
                    System.exit(25);
                }
            }
        }, "Main (AUT)"));
        this.getAutThread().setDaemon(false);
        this.getAutThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        this.getAutThread().start();
    }

    public void start(boolean isRcpAccessible) {
        this.m_isRcpAccessible = isRcpAccessible;
        try {
            IRegisterAut autReg = this.parseAutReg();
            if (autReg == null) {
                String errorMessage = "Unable to initialize connection to AUT Agent: No connection information provided.";
                log.error(errorMessage);
                this.sendExitReason(errorMessage, 12);
            }
            if (!isRcpAccessible && !this.isAgentSet()) {
                this.loadAUT();
            }
            if (this.m_isAgentSet || isRcpAccessible) {
                this.setAutThread(Thread.currentThread());
            }
            if (this.m_iteCommunicator != null) {
                this.m_iteCommunicator.send((Message)new AUTServerStateMessage(0));
            } else {
                new Thread("Start AUT Server"){

                    public void run() {
                        AUTStartCommand startCommand = new AUTStartCommand();
                        startCommand.setMessage((Message)new AUTStartMessage());
                        startCommand.execute();
                    }
                }.start();
            }
            while (!(this.getAutThread() != null && this.getAutThread().isAlive() || this.isAutRunning())) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (autReg != null) {
                this.registerAutinAgent(autReg);
            }
        }
        catch (IllegalArgumentException iae) {
            log.error("Exception in start()", (Throwable)iae);
            System.exit(1);
        }
        catch (CommunicationException ce) {
            log.error("Exception in start()", (Throwable)ce);
            System.exit(11);
        }
        catch (SecurityException se) {
            log.error("Exception in start()", (Throwable)se);
            System.exit(23);
        }
        catch (ClassNotFoundException cnfe) {
            this.sendExitReason(cnfe, 1);
            System.exit(3);
        }
        catch (NoSuchMethodException nsme) {
            this.sendExitReason(nsme, 2);
            System.exit(3);
        }
        catch (UnsupportedClassVersionError ucve) {
            this.sendExitReason(ucve, 3);
            System.exit(4);
        }
        catch (JBVersionException ve) {
            this.sendExitReason(ve, 3);
            System.exit(10);
        }
    }

    protected void registerAutinAgent(IRegisterAut autReg) throws JBVersionException {
        try {
            autReg.register();
        }
        catch (IOException ioe) {
            log.error("Exception during AUT registration", (Throwable)ioe);
            System.exit(25);
        }
    }

    protected IRegisterAut parseAutReg() {
        if (this.m_autAgentHost != null && this.m_autAgentPort != null && this.m_autID != null) {
            try {
                int autAgentPort = Integer.parseInt(this.m_autAgentPort);
                InetSocketAddress agentAddr = new InetSocketAddress(this.m_autAgentHost, autAgentPort);
                AutIdentifier autIdentifier = new AutIdentifier(this.m_autID);
                return new AgentRegisterAut(agentAddr, autIdentifier);
            }
            catch (NumberFormatException nfe) {
                log.warn("Unable to parse port number for AUT-Agent. Continuing as if no Aut Agent information was provided.", (Throwable)nfe);
            }
        }
        return null;
    }

    public void initClientCommunication(String clientHostName, int clientPort, Map<String, String> fragments) throws UnknownHostException {
        if (!fragments.isEmpty()) {
            this.m_errors = this.loadExtensions(fragments);
        }
        if (log.isDebugEnabled()) {
            log.debug("initializing communication");
        }
        InetAddress clientAddress = InetAddress.getByName(clientHostName);
        this.createCommunicator(new InetSocketAddress(clientAddress, clientPort));
        this.connectToITE();
    }

    protected List<String> loadExtensions(Map<String, String> fragments) {
        Object path;
        HashMap<URL, String> jars = new HashMap<URL, String>();
        ArrayList<String> errors = new ArrayList<String>();
        for (String classpath : fragments.keySet()) {
            try {
                String[] stringArray = path = classpath.split(AutServerLauncher.PATH_SEPARATOR);
                int n = ((String[])path).length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    URL url = new File(p).toURI().toURL();
                    jars.put(url, fragments.get(classpath));
                    ++n2;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        URL[] urls = jars.keySet().toArray(new URL[jars.keySet().size()]);
        List<URL> notLoaded = this.addURLsToClassloader(urls);
        for (URL url : notLoaded) {
            errors.add((String)jars.get(url));
        }
        path = "org.eclipse.jubula.ext.rc.common.adapter".replace('.', '/');
        ArrayList<URL> extensionsFactories = null;
        try {
            extensionsFactories = Collections.list(this.getClass().getClassLoader().getResources((String)path));
            path = "org.eclipse.jubula.rc.common.adapter".replace('.', '/');
            extensionsFactories.addAll(Collections.list(this.getClass().getClassLoader().getResources((String)path)));
        }
        catch (IOException e) {
            log.error("Loading classloader resources failed: " + e);
        }
        for (URL url : extensionsFactories) {
            try {
                List classes = ClassPathHacker.findClassesInJar((URL)url, (String)"org.eclipse.jubula.ext.rc.common.adapter", (ClassLoader)this.getClass().getClassLoader());
                classes.addAll(ClassPathHacker.findClassesInJar((URL)url, (String)"org.eclipse.jubula.rc.common.adapter", (ClassLoader)this.getClass().getClassLoader()));
                for (Class c : classes) {
                    if (!IAdapterFactory.class.isAssignableFrom(c)) continue;
                    IAdapterFactory fac = (IAdapterFactory)c.newInstance();
                    if (AdapterFactoryRegistry.getInstance().isRegistered(fac)) continue;
                    AdapterFactoryRegistry.getInstance().registerFactory(fac);
                    this.m_warnings.add("Loaded \"" + (String)jars.get(new URL(url.getPath().split("!")[0])) + "\"");
                }
            }
            catch (IOException e) {
                this.handleException(jars, errors, url, e);
            }
            catch (ClassNotFoundException e) {
                this.handleException(jars, errors, url, e);
            }
            catch (IllegalAccessException e) {
                this.handleException(jars, errors, url, e);
            }
            catch (InstantiationException e) {
                this.handleException(jars, errors, url, e);
            }
            catch (NoClassDefFoundError e) {
                this.handleException(jars, errors, url, e);
            }
        }
        return errors;
    }

    private void handleException(Map<URL, String> jars, List<String> errors, URL url, Throwable t) {
        try {
            String error = "Could not load \"" + jars.remove(new URL(url.getPath().split("!")[0])) + "\"";
            errors.add(error);
            log.error(error);
        }
        catch (MalformedURLException e1) {
            log.error("Creating error message failed: " + e1);
        }
        log.error("Loading class failed: " + t);
    }

    private List<URL> addURLsToClassloader(URL[] urls) {
        ArrayList<URL> notLoaded = new ArrayList<URL>();
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL u = uRLArray[n2];
            try {
                ClassPathHacker.addURL((URL)u, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (IOException e) {
                log.error("Could not add url: " + e);
                notLoaded.add(u);
            }
            catch (SecurityException e) {
                log.error("Could not add url: " + e);
                notLoaded.add(u);
            }
            catch (IllegalArgumentException e) {
                log.error("Could not add url: " + e);
                notLoaded.add(u);
            }
            catch (NoSuchMethodException e) {
                log.error("Could not add url: " + e);
                notLoaded.add(u);
            }
            catch (IllegalAccessException e) {
                log.error("Could not add url: " + e);
                notLoaded.add(u);
            }
            catch (InvocationTargetException e) {
                log.error("Could not add url: " + e);
                notLoaded.add(u);
            }
            catch (NoClassDefFoundError e) {
                log.error("Could not add url: " + e);
                notLoaded.add(u);
            }
            ++n2;
        }
        return notLoaded;
    }

    protected void connectToITE() {
        try {
            this.m_iteCommunicator.run();
        }
        catch (SecurityException se) {
            log.error("Exception in start()", (Throwable)se);
            System.exit(20);
        }
        catch (JBVersionException e) {
            log.error(e.toString());
        }
    }

    protected void sendExitReason(Throwable e, int exitCode) {
        log.error("Exception in start()", e);
        this.sendExitReason(e.getMessage(), exitCode);
    }

    protected void sendExitReason(String errorMessage, int exitCode) {
        try {
            this.m_iteCommunicator.send((Message)new AUTServerStateMessage(exitCode, errorMessage));
        }
        catch (CommunicationException ce) {
            log.error("Exception in start()", (Throwable)ce);
        }
    }

    private void createCommunicator(InetSocketAddress clientAddress) {
        this.m_iteCommunicator = this.createComm(clientAddress);
        this.m_iteCommunicator.addCommunicationErrorListener(this.m_communicationListener);
    }

    protected Communicator createComm(InetSocketAddress clientAddress) {
        return new Communicator(clientAddress.getAddress(), clientAddress.getPort(), Thread.currentThread().getContextClassLoader());
    }

    public void initAutAgentCommunicator(InetAddress agentAddress, int agentPort) throws SecurityException, JBVersionException {
        this.m_autAgentCommunicator = new Communicator(agentAddress, agentPort, Thread.currentThread().getContextClassLoader());
        this.m_autAgentCommunicator.addCommunicationErrorListener(this.m_serverCommunicationListener);
        this.m_autAgentCommunicator.run();
    }

    protected void startToolkitThread() {
    }

    protected void addToolkitEventListeners() {
    }

    public void addToolKitEventListenerToAUT() {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.addToolkitEventListeners();
        Thread.currentThread().setContextClassLoader(oldCL);
    }

    private void loadAUT() throws SecurityException, ClassNotFoundException, NoSuchMethodException, UnsupportedClassVersionError {
        if (log.isInfoEnabled()) {
            log.info("loading the AUT");
        }
        this.m_autMainClass = ClassLoader.getSystemClassLoader().loadClass(this.m_autMainClassName);
        this.m_autMainMethod = this.m_autMainClass.getMethod("main", this.m_autArgs.getClass());
        this.m_autMainMethod.setAccessible(true);
        int mods = this.m_autMainMethod.getModifiers();
        if (this.m_autMainMethod.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            this.m_autMainMethod = null;
            throw new NoSuchMethodException("no public static main");
        }
    }

    public void invokeAUT() throws ExceptionInInitializerError, InvocationTargetException, NoSuchMethodException {
        if (this.m_autMainMethod == null) {
            log.error("the main method of the AUT could not be found!");
            throw new NoSuchMethodException("no public static main in AUT");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("invoking main method of the AUT");
            }
            this.m_isAutRunning = true;
            this.m_autMainMethod.invoke(null, new Object[]{this.m_autArgs});
        }
        catch (IllegalArgumentException iae) {
            this.m_isAutRunning = false;
            log.error(iae.getLocalizedMessage(), (Throwable)iae);
        }
        catch (IllegalAccessException iae) {
            this.m_isAutRunning = false;
            log.error(iae.getLocalizedMessage(), (Throwable)iae);
        }
        catch (NullPointerException npe) {
            this.m_isAutRunning = false;
            log.error(npe.getLocalizedMessage(), (Throwable)npe);
        }
        catch (RuntimeException re) {
            this.m_isAutRunning = false;
            log.error("unexpected exception thrown by AUT: ", (Throwable)re);
            throw re;
        }
    }

    public void setMode(int newMode) {
        int oldMode;
        if (log.isInfoEnabled()) {
            log.info("changing mode from " + String.valueOf(this.m_mode) + " to " + String.valueOf(newMode));
        }
        if ((oldMode = this.m_mode) != newMode) {
            this.m_mode = newMode;
            switch (newMode) {
                case 5: {
                    this.setMappingModeAgent(true);
                }
                case 2: {
                    if (newMode == 2) {
                        this.setMappingModeAgent(false);
                    }
                    this.removeToolkitEventListener(this.m_mappingListener);
                    this.removeToolkitEventListener(this.m_recordListener);
                    this.removeToolkitEventListener(this.m_checkListener);
                    this.refreshMode();
                    this.addToolkitEventListener(this.m_mappingListener);
                    break;
                }
                case 3: {
                    this.setMappingModeAgent(false);
                    this.removeToolkitEventListener(this.m_mappingListener);
                    this.removeToolkitEventListener(this.m_recordListener);
                    this.removeToolkitEventListener(this.m_checkListener);
                    this.m_mappingListener.cleanUp();
                    this.addToolkitEventListener(this.m_recordListener);
                    if (oldMode == 4) break;
                    this.setObservTimestamp(0L);
                    break;
                }
                case 4: {
                    this.setMappingModeAgent(false);
                    this.removeToolkitEventListener(this.m_mappingListener);
                    this.removeToolkitEventListener(this.m_recordListener);
                    this.removeToolkitEventListener(this.m_checkListener);
                    this.m_mappingListener.cleanUp();
                    this.addToolkitEventListener(this.m_checkListener);
                    break;
                }
                case 1: {
                    this.setMappingModeAgent(false);
                    this.removeToolkitEventListener(this.m_mappingListener);
                    this.removeToolkitEventListener(this.m_recordListener);
                    this.removeToolkitEventListener(this.m_checkListener);
                    this.m_recordListener.cleanUp();
                    this.m_checkListener.cleanUp();
                    break;
                }
                default: {
                    log.error("unkown mode: " + String.valueOf(newMode));
                    this.m_mode = oldMode;
                }
            }
        }
    }

    private void setMappingModeAgent(boolean agentMapping) {
        this.m_isAgentObjectMapping = agentMapping;
    }

    public void refreshMode() {
        this.m_mappingListener.cleanUp();
        this.m_recordListener.cleanUp();
        this.m_checkListener.cleanUp();
    }

    protected abstract void addToolkitEventListener(BaseAUTListener var1);

    protected abstract void removeToolkitEventListener(BaseAUTListener var1);

    public int getMode() {
        return this.m_mode;
    }

    public boolean highlightComponent(IComponentIdentifier comp) {
        return this.m_mappingListener.highlightComponent(comp);
    }

    public void updateHighLighter() {
        this.m_mappingListener.update();
    }

    protected abstract void startTasks() throws ExceptionInInitializerError, InvocationTargetException, NoSuchMethodException;

    protected Thread getAutThread() {
        return this.m_autThread;
    }

    public boolean isAutRunning() {
        return this.m_isAutRunning;
    }

    public abstract IRobot getRobot();

    public abstract Object findComponent(IComponentIdentifier var1, int var2) throws ComponentNotFoundException, IllegalArgumentException;

    public abstract boolean isComponentDisappeared(IComponentIdentifier var1, int var2) throws ComponentNotFoundException, IllegalArgumentException;

    public final void startInspector() {
        IAutListenerAppender[] inspectorAppenders = this.m_inspectorListenerAppenders.toArray(new IAutListenerAppender[this.m_inspectorListenerAppenders.size()]);
        int i = 0;
        while (i < inspectorAppenders.length) {
            inspectorAppenders[i].addAutListener();
            ++i;
        }
    }

    public final void addInspectorListenerAppender(IAutListenerAppender appender) {
        this.m_inspectorListenerAppenders.add(appender);
    }

    public static AUTServer getInstance(String swtAutServerName) {
        autServerName = swtAutServerName;
        return AUTServer.getInstance();
    }

    public boolean isRcpAccessible() {
        return this.m_isRcpAccessible;
    }

    public boolean isAgentSet() {
        return this.m_isAgentSet;
    }

    public boolean isObservingDialogOpen() {
        return this.m_isObservingDialogOpen;
    }

    public void setObservingDialogOpen(boolean isObservingDialogOpen) {
        this.m_isObservingDialogOpen = isObservingDialogOpen;
    }

    public long getObservTimestamp() {
        return this.m_observTimestamp;
    }

    public List<String> getErrors() {
        return this.m_errors;
    }

    public List<String> getWarnings() {
        return this.m_warnings;
    }

    public void setObservTimestamp(long timestamp) {
        this.m_observTimestamp = timestamp;
    }

    private void setAutThread(Thread autThread) {
        this.m_autThread = autThread;
    }

    protected static void setInstance(AUTServer singletonInstance) {
        instance = singletonInstance;
    }

    public void shutdown() {
    }

    public void setAutAgentHost(String autAgentHost) {
        this.m_autAgentHost = autAgentHost;
    }

    public void setAutAgentPort(String autAgentPort) {
        this.m_autAgentPort = autAgentPort;
    }

    public void setAutID(String autID) {
        this.m_autID = autID;
    }

    public ClassLoader getExternalLoader() {
        return this.m_externalLoader;
    }

    public WeakReference<IComponent> getErrorComponent() {
        return this.m_errorComponent;
    }

    public void setErrorComponent(WeakReference<IComponent> errorComponent) {
        this.m_errorComponent = errorComponent;
    }

    private abstract class AbstractCommunicationListener
    implements ICommunicationErrorListener {
        private AbstractCommunicationListener() {
        }

        public void acceptingFailed(int port) {
            log.debug("acceptingFailed() called although this is a client");
            this.terminate();
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
            String message = "";
            try {
                try {
                    message = "connecting to " + inetAddress.getHostName() + ":" + String.valueOf(port) + " failed()";
                    log.error(message);
                }
                catch (SecurityException securityException) {
                    log.error("security violation during getting the  host name from ip address in connectingFailed()");
                    this.terminate();
                }
            }
            finally {
                this.terminate();
            }
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            if (log.isInfoEnabled()) {
                String message;
                try {
                    message = "connected to " + inetAddress.getHostName() + ":" + String.valueOf(port);
                }
                catch (SecurityException securityException) {
                    log.debug("security violation during getting the host name from ip address in connectingGained()");
                    message = " connected";
                }
                log.info(message);
            }
        }

        public void sendFailed(Message message) {
            log.error("sending message " + message.toString() + "failed");
            this.terminate();
        }

        public void shutDown() {
            if (log.isInfoEnabled()) {
                log.info("connection closed");
                log.info("exiting with " + String.valueOf(11));
            }
            this.terminate();
        }

        protected abstract void terminate();
    }

    private class AgentCommunicationListener
    extends AbstractCommunicationListener {
        private AgentCommunicationListener() {
        }

        protected void terminate() {
            try {
                AUTServer.this.shutdown();
            }
            finally {
                System.exit(11);
            }
        }
    }

    private class ClientCommunicationListener
    extends AbstractCommunicationListener {
        private ClientCommunicationListener() {
        }

        protected void terminate() {
            ChangeAUTModeMessage message = new ChangeAUTModeMessage();
            message.setMode(1);
            ChangeAUTModeCommand changeModeCmd = new ChangeAUTModeCommand();
            changeModeCmd.setMessage((Message)message);
            changeModeCmd.execute();
            if (AUTServer.this.m_iteCommunicator != null) {
                AUTServer.this.m_iteCommunicator.close();
            }
        }
    }
}

