/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.symbols.LSPSymbolInWorkspaceDialog;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class LSPSymbolInWorkspaceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IResource resource = null;
        if (part != null && part.getEditorInput() != null) {
            resource = (IResource)part.getEditorInput().getAdapter(IResource.class);
        } else {
            IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
            if (selection.isEmpty() || !(selection.getFirstElement() instanceof IAdaptable)) {
                return null;
            }
            IAdaptable adaptable = (IAdaptable)selection.getFirstElement();
            resource = (IResource)adaptable.getAdapter(IResource.class);
        }
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        List<LanguageServiceAccessor.LSPServerInfo> infos = LanguageServiceAccessor.getLSPServerInfos(project, capabilities -> Boolean.TRUE.equals(capabilities.getWorkspaceSymbolProvider()));
        if (infos.isEmpty()) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        LSPSymbolInWorkspaceDialog dialog = new LSPSymbolInWorkspaceDialog(shell, infos);
        if (dialog.open() != 0) {
            return null;
        }
        SymbolInformation symbolInformation = (SymbolInformation)dialog.getFirstResult();
        Location location = symbolInformation.getLocation();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        LSPEclipseUtils.openInEditor(location, page);
        return null;
    }
}

