/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jruby.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.jruby.resolver.Messages;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IRequestDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Subjects(value={"java.lang.Thread", "org.jruby.Main"})
public class RubyStacktraceDumper
implements IRequestDetailsResolver {
    public static final String RUBY_RUNNABLE_CLASS = "org.jruby.internal.runtime.RubyRunnable";
    public static final String THREAD_CONTEXT_CLASS = "org.jruby.runtime.ThreadContext";

    public void complement(ISnapshot snapshot, IThreadInfo thread, int[] javaLocals, int thisJavaLocal, IProgressListener listener) throws SnapshotException {
        Collection threadContextClasses = snapshot.getClassesByName(THREAD_CONTEXT_CLASS, false);
        if (threadContextClasses == null || threadContextClasses.isEmpty()) {
            return;
        }
        Map<String, FrameModel[]> allStackTraces = this.getAllStackTraces(snapshot);
        for (Map.Entry<String, FrameModel[]> entry : allStackTraces.entrySet()) {
            String javaThreadName = entry.getKey();
            FrameModel[] backtraceFrames = entry.getValue();
            CompositeResult result = new CompositeResult(new IResult[0]);
            if (!thread.getThreadObject().getClassSpecificName().equals(javaThreadName)) continue;
            PrintableStackFrame[] stackTraceFrames = RubyStacktraceDumper.buildPrintableStack(backtraceFrames);
            StringBuilder stackTrace = new StringBuilder();
            PrintableStackFrame[] printableStackFrameArray = stackTraceFrames;
            int n = stackTraceFrames.length;
            int n2 = 0;
            while (n2 < n) {
                PrintableStackFrame element = printableStackFrameArray[n2];
                stackTrace.append(NLS.bind((String)Messages.RubyStacktraceDumper_StackTraceLine, (Object)element));
                ++n2;
            }
            String summary = NLS.bind((String)Messages.RubyStacktraceDumper_Summary, (Object)javaThreadName);
            if (javaThreadName == null) {
                javaThreadName = Messages.RubyStacktraceDumper_UnknownThread;
            }
            result.addResult(NLS.bind((String)Messages.RubyStacktraceDumper_ResultHeader, (Object)javaThreadName), (IResult)new TextResult(stackTrace.toString(), true));
            thread.addRequest(summary, (IResult)result);
            thread.addKeyword("thread_details");
        }
    }

    private IObject findIncomingThreadRef(ISnapshot model, IObject threadContext) throws SnapshotException {
        Collection classesByName = model.getClassesByName("java.lang.Thread", false);
        if (classesByName != null) {
            for (IClass javaThreads : classesByName) {
                int[] objectIds;
                int[] nArray = objectIds = javaThreads.getObjectIds();
                int n = objectIds.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    IObject jThread = model.getObject(id);
                    List outboundReferences = jThread.getOutboundReferences();
                    for (NamedReference namedReference : outboundReferences) {
                        IObject object = model.getObject(namedReference.getObjectId());
                        if (!object.getTechnicalName().startsWith(THREAD_CONTEXT_CLASS) || object.getObjectId() != threadContext.getObjectId()) continue;
                        return jThread;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public Map<String, FrameModel[]> getAllStackTraces(ISnapshot model) throws SnapshotException {
        HashMap<IObject, String> javaThreadNameForRubyThread = new HashMap<IObject, String>();
        this.gatherThreadMap(model, javaThreadNameForRubyThread);
        HashMap<String, FrameModel[]> stackTraces = new HashMap<String, FrameModel[]>();
        Collection classesByName2 = model.getClassesByName(THREAD_CONTEXT_CLASS, false);
        int tempIndex = 0;
        if (classesByName2 != null) {
            for (IClass threadContextClass : classesByName2) {
                int[] objectIds;
                int[] nArray = objectIds = threadContextClass.getObjectIds();
                int n = objectIds.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    IObject threadContext = model.getObject(id);
                    IObject rubyThread = (IObject)threadContext.resolveValue("thread");
                    String javaThreadName = (String)javaThreadNameForRubyThread.get(rubyThread);
                    String currentFile = ((IObject)threadContext.resolveValue("file")).getClassSpecificName();
                    int currentLine = (Integer)threadContext.resolveValue("line");
                    IObjectArray frames = (IObjectArray)threadContext.resolveValue("frameStack");
                    int frameIndex = (Integer)threadContext.resolveValue("frameIndex");
                    int traceSize = frameIndex + 2;
                    FrameModel[] backtraceFrames = new FrameModel[traceSize];
                    backtraceFrames[0] = new FrameModel(Messages.RubyStacktraceDumper_Unknown, Messages.RubyStacktraceDumper_Unknown, currentFile, currentLine + 1, false);
                    long[] addresses = frames.getReferenceArray();
                    int i = 0;
                    while (i <= frameIndex) {
                        FrameModel frame;
                        IObject frameObject = model.getObject(model.mapAddressToId(addresses[i]));
                        backtraceFrames[traceSize - 1 - i] = frame = new FrameModel(frameObject);
                        ++i;
                    }
                    if (javaThreadName == null) {
                        javaThreadName = "Unknown Thread" + tempIndex++;
                    }
                    stackTraces.put(javaThreadName, backtraceFrames);
                    ++n2;
                }
            }
        }
        return stackTraces;
    }

    protected void gatherThreadMap(ISnapshot model, Map<IObject, String> javaThreadNameForRubyThread) throws SnapshotException {
        Collection threadClasses;
        Collection threadContextClasses;
        String threadName;
        IObject thread;
        Object runnable;
        int n;
        Collection rubyRunnableClasses = model.getClassesByName(RUBY_RUNNABLE_CLASS, false);
        if (rubyRunnableClasses != null) {
            for (IClass rubyRunnableClass : rubyRunnableClasses) {
                Object objectIds;
                Object object = objectIds = (Object)rubyRunnableClass.getObjectIds();
                n = ((Object)object).length;
                int n2 = 0;
                while (n2 < n) {
                    Object id = object[n2];
                    runnable = model.getObject((int)id);
                    IObject rubyThread = (IObject)runnable.resolveValue("rubyThread");
                    thread = (IObject)runnable.resolveValue("javaThread");
                    if (thread != null) {
                        threadName = new String(thread.getClassSpecificName());
                        javaThreadNameForRubyThread.put(rubyThread, threadName);
                    }
                    ++n2;
                }
            }
        }
        if ((threadContextClasses = model.getClassesByName(THREAD_CONTEXT_CLASS, false)) != null) {
            for (IClass threadContextClass : threadContextClasses) {
                int[] objectIds;
                runnable = objectIds = threadContextClass.getObjectIds();
                int n3 = objectIds.length;
                n = 0;
                while (n < n3) {
                    int id = runnable[n];
                    IObject tctxt = model.getObject(id);
                    thread = this.findIncomingThreadRef(model, tctxt);
                    if (thread != null) {
                        threadName = new String(thread.getClassSpecificName());
                        javaThreadNameForRubyThread.put(tctxt, threadName);
                    }
                    ++n;
                }
            }
        }
        if ((threadClasses = model.getClassesByName("java.lang.Thread", false)) != null) {
            for (IClass javaThreads : threadClasses) {
                int[] objectIds = javaThreads.getObjectIds();
                IObject rubyThread = null;
                IObject thread2 = null;
                int[] nArray = objectIds;
                int n4 = objectIds.length;
                int n5 = 0;
                while (n5 < n4) {
                    int id = nArray[n5];
                    IObject jThread = model.getObject(id);
                    List outboundReferences = jThread.getOutboundReferences();
                    rubyThread = null;
                    for (NamedReference namedReference : outboundReferences) {
                        IObject object = model.getObject(namedReference.getObjectId());
                        if (!object.getTechnicalName().startsWith(THREAD_CONTEXT_CLASS)) continue;
                        rubyThread = (IObject)object.resolveValue("thread");
                        thread2 = jThread;
                        break;
                    }
                    if (thread2 != null && rubyThread != null) {
                        String threadName2 = new String(thread2.getClassSpecificName() != null ? thread2.getClassSpecificName() : thread2.getTechnicalName());
                        javaThreadNameForRubyThread.put(rubyThread, threadName2);
                    }
                    ++n5;
                }
            }
        }
    }

    private static String getMethodNameFromFrame(FrameModel current) {
        String methodName = current.name();
        if (current.name() == null) {
            methodName = Messages.RubyStacktraceDumper_Unknown;
        }
        return methodName;
    }

    private static PrintableStackFrame[] buildPrintableStack(FrameModel[] frames) {
        PrintableStackFrame[] result = new PrintableStackFrame[frames.length - 1];
        int i = 0;
        while (i < result.length) {
            int line = frames[i].line;
            if (i > 0) {
                ++line;
            }
            String methodName = RubyStacktraceDumper.getMethodNameFromFrame(frames[i + 1]);
            result[i] = new PrintableStackFrame(frames[i].fileName, line, methodName);
            ++i;
        }
        return result;
    }

    public static class FrameModel {
        String fileName;
        int line;
        String name;
        String moduleName;
        boolean isBindingFrame;

        public FrameModel(IObject object) throws SnapshotException {
            this.fileName = ((IObject)object.resolveValue("fileName")).getClassSpecificName();
            this.line = (Integer)object.resolveValue("line");
            IObject nameObject = (IObject)object.resolveValue("name");
            if (nameObject != null) {
                this.name = nameObject.getClassSpecificName();
            }
            IObject klazz = (IObject)object.resolveValue("klazz");
            this.moduleName = this.getClassNameFromFrame(klazz);
            this.isBindingFrame = (Boolean)object.resolveValue("isBindingFrame");
        }

        public FrameModel(String moduleName, String methodName, String frameFileName, int frameLine, boolean isBindingFrame) throws SnapshotException {
            this.fileName = frameFileName;
            this.line = frameLine;
            this.name = methodName;
            this.moduleName = moduleName;
            this.isBindingFrame = isBindingFrame;
        }

        private String getClassNameFromFrame(IObject klazz) throws SnapshotException {
            String klazzName = Messages.RubyStacktraceDumper_Unknown;
            String fullName = null;
            if (klazz != null) {
                IObject fullNameObject = (IObject)klazz.resolveValue("fullName");
                if (fullNameObject != null) {
                    fullName = fullNameObject.getClassSpecificName();
                }
                if (fullName != null && !"".equals(fullName.trim())) {
                    klazzName = fullName;
                }
            }
            return klazzName;
        }

        String fileName() {
            return this.fileName;
        }

        int line() {
            return this.line;
        }

        String name() {
            return this.name;
        }

        String moduleName() {
            return this.moduleName;
        }

        boolean isBindingFrame() {
            return this.isBindingFrame;
        }

        public String toString() {
            return String.valueOf(this.fileName) + ":" + this.line + " in " + RubyStacktraceDumper.getMethodNameFromFrame(this);
        }
    }

    private static class PrintableStackFrame {
        String fileName;
        int line;
        String methodName;

        public PrintableStackFrame(String fileName, int line, String methodName) {
            this.fileName = fileName;
            this.line = line;
            this.methodName = methodName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLine() {
            return this.line;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String toString() {
            return this.fileName + ':' + this.line + " in '" + this.methodName + '\'';
        }
    }
}

