/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.token;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocContentState;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.LanguageSupport;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class InlineImageReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "image::?(.*?)\\[(.*?)\\]";
    }

    protected int getPatternGroupCount() {
        return 2;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new InlineImageReplacementTokenProcessor();
    }

    public static class InlineImageReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private static final String LINK = "link";
        private static final String CAPTION = "caption";
        private static final String IMAGE = "image";
        private static final String TITLE = "title";
        private static final String HEIGHT = "height";
        private static final String WIDTH = "width";
        private static final String ALT = "alt";

        public void emit() {
            String imagesDir;
            String src = this.group(1);
            String formatting = this.group(2);
            ArrayList<String> positional = new ArrayList<String>();
            positional.add(ALT);
            positional.add(WIDTH);
            positional.add(HEIGHT);
            Map<String, String> properties = LanguageSupport.parseFormattingProperties(formatting, positional);
            if (!properties.containsKey(ALT) || properties.get(ALT).isEmpty()) {
                int end = src.lastIndexOf(".");
                if (end != -1) {
                    String firstSrc = src.substring(0, end);
                    int start = Math.max(firstSrc.lastIndexOf("/") + 1, 0);
                    properties.put(ALT, firstSrc.substring(start));
                } else {
                    properties.put(ALT, src);
                }
            }
            if ((imagesDir = this.getAsciiDocState().getAttribute("imagesdir")) != null && !imagesDir.isEmpty()) {
                src = imagesDir.endsWith("/") ? imagesDir + src : imagesDir + "/" + src;
            }
            if (this.group(0).startsWith("image::")) {
                Attributes imageSpanAttributes = new Attributes();
                imageSpanAttributes.setCssClass("imageblock");
                this.builder.beginBlock(DocumentBuilder.BlockType.DIV, imageSpanAttributes);
                Attributes contentAttr = new Attributes();
                contentAttr.setCssClass("content");
                this.builder.beginBlock(DocumentBuilder.BlockType.DIV, contentAttr);
                InlineImageReplacementTokenProcessor.emitImage(this.builder, src, properties);
                this.builder.endBlock();
                if (properties.containsKey(TITLE)) {
                    Attributes attr = new Attributes();
                    attr.setCssClass(TITLE);
                    this.builder.beginBlock(DocumentBuilder.BlockType.DIV, attr);
                    if (properties.containsKey(CAPTION)) {
                        this.builder.characters(properties.get(CAPTION));
                    }
                    this.builder.characters(properties.get(TITLE));
                    this.builder.endBlock();
                }
                this.builder.endBlock();
            } else {
                Attributes imageBlockAttr = new Attributes();
                imageBlockAttr.setCssClass(IMAGE);
                this.builder.beginSpan(DocumentBuilder.SpanType.SPAN, imageBlockAttr);
                InlineImageReplacementTokenProcessor.emitImage(this.builder, src, properties);
                this.builder.endSpan();
            }
        }

        private static void emitImage(DocumentBuilder builder, String src, Map<String, String> properties) {
            ImageAttributes attributes = new ImageAttributes();
            attributes.setAlt(properties.get(ALT));
            if (properties.containsKey(HEIGHT)) {
                try {
                    int height = Integer.parseInt(properties.get(HEIGHT));
                    attributes.setHeight(height);
                }
                catch (NumberFormatException height) {
                    // empty catch block
                }
            }
            if (properties.containsKey(WIDTH)) {
                try {
                    int width = Integer.parseInt(properties.get(WIDTH));
                    attributes.setWidth(width);
                }
                catch (NumberFormatException width) {
                    // empty catch block
                }
            }
            if (properties.containsKey(LINK)) {
                Attributes linkAttributes = new Attributes();
                linkAttributes.setCssClass(IMAGE);
                builder.imageLink(linkAttributes, (Attributes)attributes, properties.get(LINK), src);
            } else {
                builder.image((Attributes)attributes, src);
            }
        }

        protected AsciiDocContentState getAsciiDocState() {
            return (AsciiDocContentState)this.state;
        }
    }
}

