/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.dnd.policy;

import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.dnd.Activator;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DropStrategy;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropStrategyManager {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.dnd.dropStrategy";
    public static final String PRIORITY_KEY = "priority";
    public static final String IS_ACTIVE_KEY = "isActive";
    public static final String DEFAULT_STRATEGY_KEY = "defaultStrategy";
    private final SortedMap<Integer, List<DropStrategy>> allAvailableStrategies = new TreeMap<Integer, List<DropStrategy>>();
    private final Map<DropStrategy, Boolean> activeStrategies = new HashMap<DropStrategy, Boolean>();
    private final Map<Set<DropStrategy>, DropStrategy> defaultStrategies = new HashMap<Set<DropStrategy>, DropStrategy>();
    private final IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
    private boolean enabled = true;
    public static final DropStrategyManager instance = new DropStrategyManager();

    private DropStrategyManager() {
        this.init();
    }

    private void init() {
        this.initStrategies();
        this.initActiveStrategies();
        this.initDefaultPreferences();
        this.initDefaultDropStrategies();
    }

    private void initStrategies() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                if ("strategy".equals(e.getName())) {
                    DropStrategy strategy = (DropStrategy)e.createExecutableExtension("strategy");
                    int priority = this.findPriority(strategy);
                    this.getStrategies(priority).add(strategy);
                }
            }
            catch (Exception ex) {
                Activator.log.error("The plugin " + e.getContributor() + " contributed an invalid extension for " + EXTENSION_ID, (Throwable)ex);
            }
            ++n2;
        }
    }

    private void initActiveStrategies() {
        for (List<DropStrategy> strategies : this.allAvailableStrategies.values()) {
            for (DropStrategy strategy : strategies) {
                this.activeStrategies.put(strategy, this.isActive(strategy));
            }
        }
    }

    private void initDefaultPreferences() {
        for (Collection collection : this.allAvailableStrategies.values()) {
            for (DropStrategy strategy : collection) {
                this.preferences.setDefault(DropStrategyManager.getPriorityKey(strategy), strategy.getPriority());
                this.preferences.setDefault(DropStrategyManager.getIsActiveKey(strategy), true);
            }
        }
    }

    private void initDefaultDropStrategies() {
        try {
            String[] stringArray = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.gmfdiag.dnd").keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.endsWith(DEFAULT_STRATEGY_KEY)) {
                    this.parseDefaultDropStrategy(key);
                }
                ++n2;
            }
        }
        catch (BackingStoreException ex) {
            Activator.log.error("Could not initialize the default Drag & Drop strategy choices", (Throwable)ex);
        }
    }

    public DropStrategy findStrategy(String id) {
        for (DropStrategy strategy : this.getAllStrategies()) {
            if (!strategy.getID().equals(id)) continue;
            return strategy;
        }
        return null;
    }

    private void parseDefaultDropStrategy(String key) {
        String[] strategyIds = key.substring(0, key.lastIndexOf(":")).split(":");
        HashSet<DropStrategy> strategies = new HashSet<DropStrategy>();
        String[] stringArray = strategyIds;
        int n = strategyIds.length;
        int n2 = 0;
        while (n2 < n) {
            String strategyId = stringArray[n2];
            DropStrategy strategy = this.findStrategy(strategyId);
            if (strategy == null) {
                return;
            }
            strategies.add(strategy);
            ++n2;
        }
        if (strategies.size() > 1) {
            this.defaultStrategies.put(strategies, this.findStrategy(this.preferences.getString(key)));
        }
    }

    private List<DropStrategy> getStrategies(int priority) {
        if (!this.allAvailableStrategies.containsKey(priority)) {
            this.allAvailableStrategies.put(priority, new LinkedList());
        }
        return (List)this.allAvailableStrategies.get(priority);
    }

    public List<DropStrategy> getActiveStrategies() {
        LinkedList<DropStrategy> orderedActiveStrategies = new LinkedList<DropStrategy>();
        if (this.isEnabled()) {
            for (List<DropStrategy> strategies : this.allAvailableStrategies.values()) {
                for (DropStrategy strategy : strategies) {
                    if (!this.isActive(strategy)) continue;
                    orderedActiveStrategies.add(strategy);
                }
            }
        }
        return orderedActiveStrategies;
    }

    public Map<Integer, List<DropStrategy>> getAllAvailableStrategies() {
        return this.allAvailableStrategies;
    }

    public static String getPriorityKey(DropStrategy strategy) {
        return String.valueOf(strategy.getID()) + "." + PRIORITY_KEY;
    }

    public static String getIsActiveKey(DropStrategy strategy) {
        return String.valueOf(strategy.getID()) + "." + IS_ACTIVE_KEY;
    }

    public static String getDefaultStrategyKey(Collection<DropStrategy> conflict) {
        LinkedList<DropStrategy> orderedStrategies = new LinkedList<DropStrategy>(conflict);
        Collections.sort(orderedStrategies, new Comparator<DropStrategy>(){

            @Override
            public int compare(DropStrategy strategy1, DropStrategy strategy2) {
                return Collator.getInstance().compare(strategy1.getID(), strategy2.getID());
            }
        });
        String key = "";
        for (DropStrategy strategy : conflict) {
            key = String.valueOf(key) + strategy.getID() + ":";
        }
        key = String.valueOf(key) + DEFAULT_STRATEGY_KEY;
        return key;
    }

    public int findPriority(DropStrategy strategy) {
        String preferenceKey = DropStrategyManager.getPriorityKey(strategy);
        if (this.preferences.contains(preferenceKey)) {
            return this.preferences.getInt(preferenceKey);
        }
        return strategy.getPriority();
    }

    public boolean isActive(DropStrategy strategy) {
        String preferenceKey;
        boolean result = true;
        if (this.isEnabled() && this.preferences.contains(preferenceKey = DropStrategyManager.getIsActiveKey(strategy))) {
            return this.preferences.getBoolean(preferenceKey);
        }
        return result;
    }

    public void setActive(DropStrategy strategy, boolean active) {
        this.preferences.setValue(DropStrategyManager.getIsActiveKey(strategy), active);
        this.activeStrategies.put(strategy, active);
    }

    public void setPriority(DropStrategy strategy, int priority) {
        this.getStrategies(this.findPriority(strategy)).remove(strategy);
        this.preferences.setValue(DropStrategyManager.getPriorityKey(strategy), priority);
        this.getStrategies(priority).add(strategy);
    }

    public List<DropStrategy> getAllStrategies() {
        LinkedList<DropStrategy> result = new LinkedList<DropStrategy>();
        for (List<DropStrategy> strategies : this.allAvailableStrategies.values()) {
            result.addAll(strategies);
        }
        return result;
    }

    public void restoreDefaults() {
        try {
            IEclipsePreferences preferenceStore = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.gmfdiag.dnd");
            preferenceStore.clear();
            preferenceStore.flush();
        }
        catch (BackingStoreException ex) {
            Activator.log.error((Throwable)ex);
        }
        this.activeStrategies.clear();
        this.allAvailableStrategies.clear();
        this.defaultStrategies.clear();
        this.initStrategies();
        this.initActiveStrategies();
        this.initDefaultDropStrategies();
    }

    public DropStrategy getDefaultDropStrategy(Collection<DropStrategy> strategies) {
        DropStrategy defaultStrategy;
        if (strategies.isEmpty()) {
            return null;
        }
        if (strategies.size() == 1) {
            defaultStrategy = strategies.iterator().next();
        } else {
            HashSet<DropStrategy> conflictingStrategies = new HashSet<DropStrategy>(strategies);
            defaultStrategy = this.defaultStrategies.get(conflictingStrategies);
        }
        if (defaultStrategy == null) {
            return null;
        }
        return this.isActive(defaultStrategy) ? defaultStrategy : null;
    }

    public void setDefaultDropStrategy(Collection<DropStrategy> conflictingStrategies, DropStrategy defaultStrategy) {
        if (conflictingStrategies.size() < 2) {
            return;
        }
        HashSet<DropStrategy> conflict = new HashSet<DropStrategy>(conflictingStrategies);
        this.defaultStrategies.put(conflict, defaultStrategy);
        this.preferences.putValue(DropStrategyManager.getDefaultStrategyKey(conflict), defaultStrategy.getID());
        IEclipsePreferences preferenceStore = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.gmfdiag.dnd");
        try {
            preferenceStore.flush();
        }
        catch (BackingStoreException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

