/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class MessageHelperAdvice
extends AbstractEditHelperAdvice {
    protected Element getSource(ConfigureRequest req) {
        Element result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof Element) {
            result = (Element)paramObject;
        }
        return result;
    }

    protected Element getTarget(ConfigureRequest req) {
        Element result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof Element) {
            result = (Element)paramObject;
        }
        return result;
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        Message message = (Message)request.getElementToConfigure();
        Element source = this.getSource(request);
        Element target = this.getTarget(request);
        IElementType elementType = request.getTypeToConfigure();
        if (source == null || target == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!(source instanceof Lifeline || source instanceof Interaction || source instanceof Gate || source instanceof ExecutionSpecification)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!(target instanceof Lifeline || target instanceof Interaction || target instanceof Gate || target instanceof ExecutionSpecification)) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Message message = (Message)request.getElementToConfigure();
                Element source = MessageHelperAdvice.this.getSource(request);
                Element target = MessageHelperAdvice.this.getTarget(request);
                MessageEnd previousSentEvent = (MessageEnd)request.getParameters().get("previous event");
                MessageEnd previousReceiveEvent = (MessageEnd)request.getParameters().get("second previous event");
                ExecutionOccurrenceSpecification toReplacebyMessageSent = (ExecutionOccurrenceSpecification)request.getParameters().get("MESSAGE_SENTEVENT_REPLACE_EXECUTIONEVENT");
                ExecutionOccurrenceSpecification toReplacebyMessageReceive = (ExecutionOccurrenceSpecification)request.getParameters().get("MESSAGE_RECEIVEEVENT_REPLACE_EXECUTIONEVENT");
                IElementType elementType = request.getTypeToConfigure();
                if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_ASYNCH_CALL)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    this.createReceiveEvent(message, target, previousReceiveEvent);
                    message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_ASYNCH_SIGNAL)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    this.createReceiveEvent(message, target, previousReceiveEvent);
                    message.setMessageSort(MessageSort.ASYNCH_SIGNAL_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_CREATE_MESSAGE)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    this.createReceiveEvent(message, target, previousReceiveEvent);
                    message.setMessageSort(MessageSort.CREATE_MESSAGE_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_DELETE_MESSAGE)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    this.createDestroyReceiveEvent(message, target);
                    message.setMessageSort(MessageSort.DELETE_MESSAGE_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_REPLY)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    this.createReceiveEvent(message, target, previousReceiveEvent);
                    message.setMessageSort(MessageSort.REPLY_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_SYNCH_CALL)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    this.createReceiveEvent(message, target, previousReceiveEvent);
                    message.setMessageSort(MessageSort.SYNCH_CALL_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_ASYNCH_CALL)) {
                    this.createReceiveEvent(message, target, previousReceiveEvent);
                    message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_ASYNCH_SIGNAL)) {
                    this.createReceiveEvent(message, target, previousReceiveEvent);
                    message.setMessageSort(MessageSort.ASYNCH_SIGNAL_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_CREATE_MESSAGE)) {
                    this.createReceiveEvent(message, target, previousReceiveEvent);
                    message.setMessageSort(MessageSort.CREATE_MESSAGE_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_DELETE_MESSAGE)) {
                    this.createDestroyReceiveEvent(message, target);
                    message.setMessageSort(MessageSort.DELETE_MESSAGE_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_REPLY)) {
                    this.createReceiveEvent(message, target, previousReceiveEvent);
                    message.setMessageSort(MessageSort.REPLY_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_ASYNCH_CALL)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_ASYNCH_SIGNAL)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    message.setMessageSort(MessageSort.ASYNCH_SIGNAL_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_CREATE_MESSAGE)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    message.setMessageSort(MessageSort.CREATE_MESSAGE_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_DELETE_MESSAGE)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    message.setMessageSort(MessageSort.DELETE_MESSAGE_LITERAL);
                } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_REPLY)) {
                    this.createSenEvent(message, source, previousSentEvent);
                    message.setMessageSort(MessageSort.REPLY_LITERAL);
                }
                if (toReplacebyMessageSent != null) {
                    if (toReplacebyMessageSent.getExecution() != null) {
                        if (toReplacebyMessageSent.getExecution().getStart().equals(toReplacebyMessageSent)) {
                            toReplacebyMessageSent.getExecution().setStart((OccurrenceSpecification)message.getSendEvent());
                        } else {
                            toReplacebyMessageSent.getExecution().setFinish((OccurrenceSpecification)message.getSendEvent());
                        }
                    }
                    if (toReplacebyMessageReceive != null) {
                        ICommand destroyCommand;
                        DestroyElementRequest destroyRequest;
                        IElementEditService provider;
                        if (toReplacebyMessageReceive.getOwner() != null && (provider = ElementEditServiceUtils.getCommandProvider((EObject)toReplacebyMessageSent)) != null) {
                            destroyRequest = new DestroyElementRequest((EObject)toReplacebyMessageSent, false);
                            destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
                            destroyCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                        }
                        if (toReplacebyMessageReceive.getExecution() != null) {
                            if (toReplacebyMessageReceive.getExecution().getStart().equals(toReplacebyMessageReceive)) {
                                toReplacebyMessageReceive.getExecution().setStart((OccurrenceSpecification)message.getReceiveEvent());
                            } else {
                                toReplacebyMessageReceive.getExecution().setFinish((OccurrenceSpecification)message.getReceiveEvent());
                            }
                        }
                        if (toReplacebyMessageReceive.getOwner() != null && (provider = ElementEditServiceUtils.getCommandProvider((EObject)toReplacebyMessageReceive)) != null) {
                            destroyRequest = new DestroyElementRequest((EObject)toReplacebyMessageReceive, false);
                            destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
                            destroyCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                        }
                    }
                }
                return CommandResult.newOKCommandResult((Object)message);
            }

            private void createDestroyReceiveEvent(Message message, Element source) {
                MessageEnd sendEvent = MessageHelperAdvice.createDestroyMessageEnd(message, (Lifeline)source);
                sendEvent.setName(String.valueOf(message.getName()) + "ReceiveDestroyEvent");
                message.setReceiveEvent(sendEvent);
            }

            private void createSenEvent(Message message, Element source, MessageEnd previous) {
                if (source instanceof Gate) {
                    message.setSendEvent((MessageEnd)((Gate)source));
                } else if (source instanceof ExecutionSpecification) {
                    if (((ExecutionSpecification)source).getCovereds().size() > 0) {
                        Lifeline lifeline = (Lifeline)((ExecutionSpecification)source).getCovereds().get(0);
                        MessageEnd sendEvent = MessageHelperAdvice.createMessageEnd(message, lifeline, previous);
                        sendEvent.setName(String.valueOf(message.getName()) + "SendEvent");
                        message.setSendEvent(sendEvent);
                    }
                } else if (source instanceof Lifeline) {
                    MessageEnd sendEvent = MessageHelperAdvice.createMessageEnd(message, (Lifeline)source, previous);
                    sendEvent.setName(String.valueOf(message.getName()) + "SendEvent");
                    message.setSendEvent(sendEvent);
                }
            }

            private void createReceiveEvent(Message message, Element target, MessageEnd previous) {
                if (target instanceof Gate) {
                    message.setReceiveEvent((MessageEnd)((Gate)target));
                } else if (target instanceof ExecutionSpecification) {
                    if (((ExecutionSpecification)target).getCovereds().size() > 0) {
                        Lifeline lifeline = (Lifeline)((ExecutionSpecification)target).getCovereds().get(0);
                        MessageEnd receiveEvent = MessageHelperAdvice.createMessageEnd(message, lifeline, previous);
                        receiveEvent.setName(String.valueOf(message.getName()) + "ReceiveEvent");
                        message.setReceiveEvent(receiveEvent);
                    }
                } else if (target instanceof Lifeline) {
                    MessageEnd receiveEvent = MessageHelperAdvice.createMessageEnd(message, (Lifeline)target, previous);
                    receiveEvent.setName(String.valueOf(message.getName()) + "ReceiveEvent");
                    message.setReceiveEvent(receiveEvent);
                }
            }
        };
    }

    public static MessageEnd createMessageEnd(Message message, Lifeline lifeline, MessageEnd previous) {
        MessageOccurrenceSpecification messageOccurrenceSpecification = UMLFactory.eINSTANCE.createMessageOccurrenceSpecification();
        if (previous == null) {
            messageOccurrenceSpecification.setCovered(lifeline);
        } else {
            lifeline.getCoveredBys().add(lifeline.getCoveredBys().indexOf((Object)previous) + 1, (Object)messageOccurrenceSpecification);
        }
        messageOccurrenceSpecification.setMessage(message);
        messageOccurrenceSpecification.setMessage(message);
        ((Interaction)message.getOwner()).getFragments().add((Object)messageOccurrenceSpecification);
        return messageOccurrenceSpecification;
    }

    public static MessageEnd createDestroyMessageEnd(Message message, Lifeline lifeline) {
        DestructionOccurrenceSpecification messageOccurrenceSpecification = UMLFactory.eINSTANCE.createDestructionOccurrenceSpecification();
        messageOccurrenceSpecification.setCovered(lifeline);
        messageOccurrenceSpecification.setMessage(message);
        ((Interaction)message.getOwner()).getFragments().add((Object)messageOccurrenceSpecification);
        return messageOccurrenceSpecification;
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        MessageEnd recvEvent;
        ArrayList<MessageEnd> dependentsToDestroy = new ArrayList<MessageEnd>();
        Message message = (Message)request.getElementToDestroy();
        MessageEnd sendEvent = message.getSendEvent();
        if (sendEvent != null && !MessageHelperAdvice.isSharedEvent(sendEvent, (EObject)message)) {
            dependentsToDestroy.add(sendEvent);
        }
        if ((recvEvent = message.getReceiveEvent()) != null && !MessageHelperAdvice.isSharedEvent(recvEvent, (EObject)message)) {
            dependentsToDestroy.add(recvEvent);
        }
        if (!dependentsToDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return null;
    }

    public static boolean isSharedEvent(MessageEnd usedObject, EObject knownReferencer) {
        EPackage mmPackage = usedObject.eClass().getEPackage();
        HashSet<EObject> crossReferences = new HashSet<EObject>();
        for (EStructuralFeature.Setting setting : EMFHelper.getUsages((EObject)usedObject)) {
            EObject eObj = setting.getEObject();
            if (setting.getEStructuralFeature().equals(UMLPackage.eINSTANCE.getLifeline_CoveredBy()) || !eObj.eClass().getEPackage().equals(mmPackage)) continue;
            crossReferences.add(eObj);
        }
        crossReferences.remove(usedObject.eContainer());
        crossReferences.remove(knownReferencer);
        return !crossReferences.isEmpty();
    }
}

