/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.validation.internal.providers;

import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.views.validation.internal.providers.ProblemLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class SeverityLabelProvider
extends ProblemLabelProvider {
    private ISharedImages images = PlatformUI.getWorkbench().getSharedImages();

    public String getText(Object element) {
        return null;
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof IPapyrusMarker) {
            IPapyrusMarker marker = (IPapyrusMarker)element;
            switch (marker.getAttribute("severity", 2)) {
                case 0: {
                    result = this.images.getImage("IMG_OBJS_INFO_TSK");
                    break;
                }
                case 1: {
                    result = this.images.getImage("IMG_OBJS_WARN_TSK");
                    break;
                }
                default: {
                    result = this.images.getImage("IMG_OBJS_ERROR_TSK");
                }
            }
        }
        return result;
    }

    public ViewerComparator createSorter() {
        return new ViewerComparator(){

            public int category(Object element) {
                int result = -1;
                if (element instanceof IPapyrusMarker) {
                    IPapyrusMarker marker = (IPapyrusMarker)element;
                    result = 2 - marker.getAttribute("severity", -1);
                }
                return result;
            }
        };
    }
}

