/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.project;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.internal.core.preferences.CorePreferencesSupport;

public class ProjectOptions {
    private ProjectOptions() {
    }

    @Nullable
    private static IProject getProject(@NonNull IModelElement modelElement) {
        IScriptProject scriptProject = modelElement.getScriptProject();
        if (scriptProject != null) {
            return scriptProject.getProject();
        }
        return null;
    }

    public static PHPVersion getPHPVersion(@NonNull IModelElement modelElement) {
        return ProjectOptions.getPHPVersion(ProjectOptions.getProject(modelElement));
    }

    public static PHPVersion getPHPVersion(IProject project) {
        if (project != null) {
            return PHPVersion.byAlias(CorePreferencesSupport.getInstance().getPreferencesValue("phpVersion", null, project));
        }
        return ProjectOptions.getDefaultPHPVersion();
    }

    public static PHPVersion getPHPVersion(@NonNull IFile file) {
        PHPVersion phpVersion = ProjectOptions.getDefaultPHPVersion();
        IProject project = file.getProject();
        if (project != null && project.isAccessible()) {
            phpVersion = ProjectOptions.getPHPVersion(project);
        }
        return phpVersion;
    }

    public static PHPVersion getPHPVersion(@NonNull String fileName) {
        IProject project;
        PHPVersion phpVersion = ProjectOptions.getDefaultPHPVersion();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fileName);
        if (resource != null && (project = resource.getProject()).isAccessible()) {
            phpVersion = ProjectOptions.getPHPVersion(project);
        }
        return phpVersion;
    }

    public static PHPVersion getDefaultPHPVersion() {
        return PHPVersion.byAlias(CorePreferencesSupport.getInstance().getWorkspacePreferencesValue("phpVersion"));
    }

    public static boolean setPHPVersion(@NonNull PHPVersion version, @NonNull IProject project) {
        return CorePreferencesSupport.getInstance().setProjectSpecificPreferencesValue("phpVersion", version.getAlias(), project);
    }

    public static final boolean isSupportingASPTags(@Nullable IProject project) {
        return project == null ? false : Boolean.valueOf(CorePreferencesSupport.getInstance().getPreferencesValue("use_asp_tags_as_php", null, project));
    }

    public static boolean useShortTags(@Nullable IProject project) {
        String useShortTags = CorePreferencesSupport.getInstance().getPreferencesValue("useShortTags", null, project);
        return "true".equals(useShortTags);
    }

    public static boolean useShortTags(@NonNull IModelElement modelElement) {
        return ProjectOptions.useShortTags(ProjectOptions.getProject(modelElement));
    }

    public static final boolean isSupportingASPTags(@NonNull IFile file) {
        return ProjectOptions.isSupportingASPTags(file.getProject());
    }

    public static final boolean setSupportingASPTags(boolean value, @NonNull IProject project) {
        return CorePreferencesSupport.getInstance().setProjectSpecificPreferencesValue("use_asp_tags_as_php", Boolean.toString(value), project);
    }
}

