/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.util.ArrayList;

public class BlockingQueue {
    static Object emptyObject = new Object();
    private ArrayList content;
    private boolean releaseFlag = false;

    public BlockingQueue() {
        this(100);
    }

    public BlockingQueue(int size) {
        this.content = new ArrayList(size);
    }

    public synchronized void queueIn(Object obj) {
        this.content.add(obj);
        this.notify();
    }

    public synchronized Object queueOut() throws InterruptedException {
        return this.queueOut(0L);
    }

    public synchronized Object queueOut(long timeout) throws InterruptedException {
        this.releaseFlag = false;
        Object rv = emptyObject;
        do {
            if (this.content.isEmpty()) {
                this.wait(timeout);
                if (this.releaseFlag) {
                    throw new InterruptedException();
                }
            }
            if (this.content.isEmpty()) continue;
            rv = this.content.remove(0);
        } while (rv == emptyObject);
        return rv;
    }

    public synchronized boolean isEmpty() {
        return this.content.isEmpty();
    }

    public synchronized void releaseReaders() {
        this.releaseFlag = true;
        this.notifyAll();
    }

    public synchronized void clear() {
        this.content.clear();
    }

    public synchronized boolean remove(Object obj) {
        int index = this.content.indexOf(obj);
        if (index > -1) {
            this.content.set(index, emptyObject);
            return true;
        }
        return false;
    }

    public synchronized boolean moveToFront(Object obj) {
        boolean rv = this.content.remove(obj);
        if (rv) {
            this.content.add(0, obj);
        }
        return rv;
    }

    public synchronized boolean contains(Object obj) {
        return this.content.contains(obj);
    }

    public synchronized Object top() {
        Object rv = this.content.isEmpty() ? null : this.content.get(0);
        return rv;
    }

    public synchronized Object tail() {
        int size = this.content.size();
        Object rv = size == 0 ? null : this.content.get(size - 1);
        return rv;
    }
}

