/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.view;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPElementImageDescriptor;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitTest;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestEvent;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestException;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestGroup;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestWarning;
import org.eclipse.php.phpunit.model.elements.PHPUnitTraceFrame;
import org.eclipse.php.phpunit.ui.view.PHPUnitView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.internal.Util;

public class TestLabelProvider
extends LabelProvider {
    private final Image fExceptionIcon = Util.getImage((int)2);
    private final Image fFunctionIcon = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_MISC_PUBLIC);
    private final Image fStaticFunctionIcon = PHPUiPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new PHPElementImageDescriptor(PHPPluginImages.DESC_MISC_PUBLIC, 1, PHPElementImageDescriptor.SMALL_SIZE));
    private final Image fSuiteErrorIcon = PHPUnitPlugin.createImage("obj16/tsuiteerror.png");
    private final Image fSuiteFailIcon = PHPUnitPlugin.createImage("obj16/tsuitefail.png");
    private final Image fSuiteOkIcon = PHPUnitPlugin.createImage("obj16/tsuiteok.png");
    private final Image fSuiteRunningIcon = PHPUnitPlugin.createImage("obj16/tsuiterun.png");
    private final Image fSuiteWarningIcon;
    private final Image fOkIcon;
    private final Image fErrorIcon;
    private final Image fWarningIcon;
    private final Image fFailureIcon;
    private final Image fTestRunningIcon;
    private PHPUnitView view;

    public TestLabelProvider(PHPUnitView view) {
        this.view = view;
        Image image = PHPUnitPlugin.createImage("obj16/test.png");
        Image testSuiteImage = PHPUnitPlugin.createImage("obj16/tsuite.png");
        this.fOkIcon = PHPUnitPlugin.createImage("obj16/testok.png");
        this.fErrorIcon = PHPUnitPlugin.createImage("obj16/testerr.png");
        this.fFailureIcon = PHPUnitPlugin.createImage("obj16/testfail.png");
        this.fWarningIcon = this.createOverlay(image, "IMG_DEC_FIELD_WARNING");
        this.fTestRunningIcon = PHPUnitPlugin.createImage("obj16/tcaserun.png");
        this.fSuiteWarningIcon = this.createOverlay(testSuiteImage, "IMG_DEC_FIELD_WARNING");
        image.dispose();
        testSuiteImage.dispose();
    }

    private Image createOverlay(Image image, String symbolicName) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        return new DecorationOverlayIcon(image, sharedImages.getImageDescriptor(symbolicName), 2).createImage();
    }

    public Image getImage(Object element) {
        if (element instanceof PHPUnitTestCase) {
            PHPUnitTestCase test = (PHPUnitTestCase)element;
            switch (test.getStatus()) {
                case 1: {
                    return this.fOkIcon;
                }
                case 2: 
                case 3: {
                    return this.fWarningIcon;
                }
                case 0: {
                    return this.fTestRunningIcon;
                }
                case 4: {
                    return this.fFailureIcon;
                }
                case 5: {
                    return this.fErrorIcon;
                }
            }
        } else if (element instanceof PHPUnitTestGroup) {
            PHPUnitTestGroup test = (PHPUnitTestGroup)element;
            if (test.getTotalCount() > test.getRunCount()) {
                return this.fSuiteRunningIcon;
            }
            switch (test.getStatus()) {
                case 1: {
                    return this.fSuiteOkIcon;
                }
                case 2: 
                case 3: {
                    return this.fSuiteWarningIcon;
                }
                case 4: {
                    return this.fSuiteFailIcon;
                }
                case 5: {
                    return this.fSuiteErrorIcon;
                }
            }
        } else {
            if (element instanceof PHPUnitTraceFrame) {
                if ("::".equals(((PHPUnitTraceFrame)element).getTraceType())) {
                    return this.fStaticFunctionIcon;
                }
                return this.fFunctionIcon;
            }
            if (element instanceof PHPUnitTestException) {
                return this.fExceptionIcon;
            }
            if (element instanceof PHPUnitTestWarning) {
                return Util.getImage((int)1);
            }
        }
        return null;
    }

    public String getText(Object element) {
        PHPUnitElement test = (PHPUnitElement)element;
        String fileName = test.getLocalFile();
        if (StringUtils.isNotEmpty((CharSequence)fileName)) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
            if (file == null) {
                file = this.view.getProject().getFile(fileName);
            }
            if (file != null) {
                fileName = file.getProjectRelativePath().toString();
            }
        }
        int line = test.getLine();
        if (test instanceof PHPUnitTest) {
            PHPUnitTestException exception;
            String name = ((PHPUnitTest)test).getName();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = String.valueOf(fileName) + ":" + line;
            }
            if (test instanceof PHPUnitTestCase && (exception = ((PHPUnitTestCase)test).getException()) != null && StringUtils.isNotEmpty((CharSequence)exception.getMessage())) {
                name = String.valueOf(name) + ": " + exception.getMessage();
                if (StringUtils.isNotEmpty((CharSequence)exception.getDiff())) {
                    name = String.valueOf(name) + " (see Object Diff tab ->)";
                }
            }
            return name;
        }
        if (test instanceof PHPUnitTestEvent) {
            String message = ((PHPUnitTestEvent)test).getMessage();
            String prefix = "";
            if (test instanceof PHPUnitTestException) {
                prefix = ((PHPUnitTestException)test).getExceptionClass();
            } else if (test instanceof PHPUnitTestWarning) {
                prefix = ((PHPUnitTestWarning)test).getCode();
            }
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                return String.valueOf(prefix) + ": " + message;
            }
            return prefix;
        }
        if (test instanceof PHPUnitTraceFrame) {
            return String.valueOf(test.toString()) + "()";
        }
        return test.toString();
    }

    public void dispose() {
        this.fOkIcon.dispose();
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
        this.fSuiteOkIcon.dispose();
        this.fSuiteErrorIcon.dispose();
        this.fSuiteFailIcon.dispose();
        this.fSuiteRunningIcon.dispose();
        this.fWarningIcon.dispose();
        this.fSuiteWarningIcon.dispose();
    }
}

