/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.php.debug.ui.DebugServerConnectionTestRegistry;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.debug.ui.launching.AbstractPHPLaunchConfigurationDebuggerTab;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.ServerEditWizardRunner;
import org.eclipse.php.internal.server.ui.launching.Messages;

public class PHPWebPageLaunchConfigurationDebuggerTab
extends AbstractPHPLaunchConfigurationDebuggerTab {
    protected void handleConfigureDebugger() {
        Server server = this.getServer();
        if (server == null || ServersManager.isNoneServer((Server)server)) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (ServerEditWizardRunner.runWizard(server, "org.eclipse.php.debug.ui.fragments.debuggerCompositeFragment") == 1) {
            monitor.setCanceled(true);
            return;
        }
        ServersManager.save();
    }

    protected String getCurrentDebuggerId() {
        Server server = this.getServer();
        if (server == null) {
            return "org.eclipse.php.debug.core.noneDebugger";
        }
        return server.getDebuggerId();
    }

    protected String getNoDebuggerMessage() {
        return MessageFormat.format(Messages.PHPWebPageLaunchConfigurationDebuggerTab_No_debugger_is_attached_to_server_configuration, this.getServer().getName());
    }

    protected void updateDebugTest() {
        this.debugTesters = DebugServerConnectionTestRegistry.getTests((String)this.getCurrentDebuggerId());
        if (this.debugTesters.length == 0) {
            this.validateDebuggerBtn.setEnabled(false);
        } else {
            this.validateDebuggerBtn.setEnabled(true);
        }
    }

    protected void performDebugTest() {
        IDebugServerConnectionTest[] iDebugServerConnectionTestArray = this.debugTesters;
        int n = this.debugTesters.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugServerConnectionTest debugServerTester = iDebugServerConnectionTestArray[n2];
            debugServerTester.testConnection(this.getServer(), this.getShell());
            ++n2;
        }
    }

    private Server getServer() {
        try {
            String serverName = this.getConfiguration().getAttribute("name", "");
            Server server = ServersManager.getServer((String)serverName);
            return server;
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

