/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractForestBuilder;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitioningVisitor;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MicroMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;

abstract class AbstractPartition {
    protected final @NonNull Partitioner partitioner;
    protected final @NonNull Iterable<@NonNull Edge> alreadyRealizedEdges;
    private final @NonNull Map<@NonNull Node, @NonNull Role> node2nodeRole = new HashMap<Node, Role>();
    private final @NonNull Map<@NonNull Edge, @NonNull Role> edge2edgeRole = new HashMap<Edge, Role>();
    private PartitionForest forest = null;

    protected AbstractPartition(@NonNull Partitioner partitioner) {
        this.partitioner = partitioner;
        this.alreadyRealizedEdges = partitioner.getAlreadyRealizedEdges();
    }

    private void addEdge(@NonNull Edge edge, @NonNull Role newEdgeRole) {
        switch (RegionUtil.getEdgeRole((Edge)edge)) {
            case CONSTANT: {
                assert (newEdgeRole == Role.CONSTANT);
                break;
            }
            case LOADED: {
                assert (newEdgeRole == Role.LOADED);
                break;
            }
            case PREDICATED: {
                assert (newEdgeRole == Role.PREDICATED);
                break;
            }
            case REALIZED: {
                if (!this.partitioner.hasRealizedEdge(edge) ? !$assertionsDisabled && newEdgeRole != Role.REALIZED : !$assertionsDisabled && newEdgeRole != Role.PREDICATED) {
                    throw new AssertionError();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ".addEdge " + edge);
            }
        }
        this.partitioner.addEdge(edge, newEdgeRole, this);
        this.edge2edgeRole.put(edge, newEdgeRole);
    }

    protected void addNode(@NonNull Node node, @NonNull Role newNodeRole) {
        switch (RegionUtil.getNodeRole((Node)node)) {
            case CONSTANT: {
                assert (newNodeRole == Role.CONSTANT);
                if (!node.isTrue()) break;
                this.partitioner.addTrueNode(node);
                break;
            }
            case LOADED: {
                assert (newNodeRole == Role.LOADED);
                break;
            }
            case PREDICATED: {
                assert (newNodeRole == Role.PREDICATED || newNodeRole == Role.SPECULATED);
                this.partitioner.addPredicatedNode(node);
                break;
            }
            case REALIZED: {
                if (!this.partitioner.hasRealizedNode(node)) {
                    assert (newNodeRole == Role.REALIZED || newNodeRole == Role.SPECULATION);
                    this.partitioner.addRealizedNode(node);
                    break;
                }
                assert (newNodeRole == Role.PREDICATED || newNodeRole == Role.SPECULATED);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ".addNode " + node);
            }
        }
        Role oldNodeRole = this.node2nodeRole.put(node, newNodeRole);
        assert (oldNodeRole == null || oldNodeRole == newNodeRole);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull PartitionForest createForest() {
        @NonNull ArrayList navigableEdges = Lists.newArrayList(this.partitioner.getNavigableEdges());
        for (Edge edge : this.alreadyRealizedEdges) {
            if (!(edge instanceof NavigableEdge)) continue;
            navigableEdges.add((NavigableEdge)edge);
        }
        return new PartitionForest(this.partitioner.getRealizedMiddleNodes(), navigableEdges);
    }

    public @NonNull MicroMappingRegion createMicroMappingRegion(@NonNull String namePrefix, @NonNull String symbolSuffix) {
        PartitioningVisitor partitioningVisitor = PartitioningVisitor.createPartialRegion(this.partitioner.getRegion(), namePrefix, symbolSuffix, this);
        MicroMappingRegion microMappingRegion = partitioningVisitor.getRegion();
        RegionHelper.initHeadNodes((MappingRegion)microMappingRegion);
        this.check(microMappingRegion);
        return microMappingRegion;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void check(@NonNull MicroMappingRegion region) {
        HashSet<@NonNull Node> reachableNodes = new HashSet<Node>();
        for (Node node : RegionUtil.getHeadNodes((Region)region)) {
            this.gatherReachables(reachableNodes, node);
        }
        @NonNull HashSet allNodes = Sets.newHashSet((Iterable)RegionUtil.getOwnedNodes((Region)region));
        if (!reachableNodes.equals(allNodes)) {
            @NonNull HashSet extraNodesSet = Sets.newHashSet(reachableNodes);
            CompilerUtil.removeAll(extraNodesSet, allNodes);
            for (Node node : extraNodesSet) {
                this.partitioner.addProblem(RegionUtil.createRegionWarning((Region)region, "unexpected " + node, new Object[0]));
            }
            @NonNull HashSet missingNodesSet = Sets.newHashSet((Iterable)allNodes);
            missingNodesSet.removeAll(reachableNodes);
            for (Node node : missingNodesSet) {
                this.partitioner.addProblem(RegionUtil.createRegionWarning((Region)region, "unreachable " + node, new Object[0]));
            }
        }
    }

    private void gatherReachables(@NonNull Set<@NonNull Node> reachableNodes, @NonNull Node node) {
        if (reachableNodes.add(node)) {
            for (Edge edge : RegionUtil.getIncomingEdges((Node)node)) {
                if (!edge.isComputation() && !edge.isNavigation()) continue;
                this.gatherReachables(reachableNodes, edge.getEdgeSource());
            }
            for (Edge edge : RegionUtil.getOutgoingEdges((Node)node)) {
                if (!edge.isNavigation()) continue;
                this.gatherReachables(reachableNodes, edge.getEdgeTarget());
            }
        }
    }

    public @Nullable Role getEdgeRole(@NonNull Edge edge) {
        return this.edge2edgeRole.get(edge);
    }

    public @Nullable Role getNodeRole(@NonNull Node node) {
        return this.node2nodeRole.get(node);
    }

    protected @Nullable NavigableEdge getParentEdge(@NonNull Node targetNode) {
        PartitionForest forest2 = this.forest;
        if (forest2 == null) {
            this.forest = forest2 = this.createForest();
        }
        return forest2.getParentEdge(targetNode);
    }

    protected @NonNull Iterable<@NonNull Node> getPredecessors(@NonNull Node targetNode) {
        PartitionForest forest2 = this.forest;
        if (forest2 == null) {
            this.forest = forest2 = this.createForest();
        }
        return forest2.getPredecessors(targetNode);
    }

    private boolean hasEdge(@NonNull Edge edge) {
        return this.edge2edgeRole.containsKey(edge);
    }

    protected boolean hasNode(@NonNull Node node) {
        return this.node2nodeRole.containsKey(node);
    }

    protected boolean isComputable(@NonNull Set<@NonNull Node> sourceNodes, @NonNull Edge edge) {
        block7: {
            Node node;
            block6: {
                node = edge.getEdgeSource();
                if (!sourceNodes.add(node)) {
                    return true;
                }
                if (this.hasNode(node)) {
                    return true;
                }
                if (node.isTrue()) {
                    return true;
                }
                if (node.isPattern() && node.isMatched() && node.isClass()) {
                    return false;
                }
                if (!node.isOperation()) break block6;
                for (Edge incomingEdge : RegionUtil.getIncomingEdges((Node)node)) {
                    if (!incomingEdge.isComputation() || this.isComputable(sourceNodes, incomingEdge)) continue;
                    return false;
                }
                break block7;
            }
            if (!node.isPattern()) break block7;
            for (Edge incomingEdge : RegionUtil.getIncomingEdges((Node)node)) {
                if (!incomingEdge.isComputation() || this.isComputable(sourceNodes, incomingEdge)) continue;
                return false;
            }
        }
        return true;
    }

    protected void resolveComputations() {
        for (Node node : new ArrayList<Node>(this.node2nodeRole.keySet())) {
            this.resolveComputations(node);
            this.resolveNavigations(node);
        }
    }

    protected boolean resolveComputations(@NonNull Node targetNode) {
        boolean gotIt = false;
        for (Edge incomingEdge : RegionUtil.getIncomingEdges((Node)targetNode)) {
            HashSet<Node> sourceNodes;
            if (!incomingEdge.isComputation() && (!incomingEdge.isNavigation() || !incomingEdge.isOld()) || !this.isComputable(sourceNodes = new HashSet<Node>(), incomingEdge)) continue;
            gotIt = true;
            for (Node sourceNode : sourceNodes) {
                if (this.hasNode(sourceNode)) continue;
                this.addNode(sourceNode, RegionUtil.getNodeRole((Node)sourceNode));
            }
        }
        return gotIt;
    }

    protected abstract @Nullable Role resolveEdgeRole(@NonNull Role var1, @NonNull Edge var2, @NonNull Role var3);

    protected void resolveEdgeRoles() {
        for (Edge edge : RegionUtil.getOwnedEdges((Region)this.partitioner.getRegion())) {
            Role edgeRole;
            Role targetNodeRole;
            Role sourceNodeRole;
            if (edge.isSecondary() || this.hasEdge(edge) || (sourceNodeRole = this.node2nodeRole.get(edge.getEdgeSource())) == null || (targetNodeRole = this.node2nodeRole.get(edge.getEdgeTarget())) == null || (edgeRole = this.resolveEdgeRole(sourceNodeRole, edge, targetNodeRole)) == null) continue;
            if (edgeRole == Role.REALIZED && this.partitioner.hasRealizedEdge(edge)) {
                edgeRole = null;
            }
            if (edgeRole == null) continue;
            this.addEdge(edge, edgeRole);
        }
    }

    protected void resolveNavigations(@NonNull Node node) {
        for (NavigableEdge edge : node.getNavigationEdges()) {
            Node targetNode;
            if (this.partitioner.hasRealizedEdge((Edge)edge) || !(targetNode = edge.getEdgeTarget()).isDataType() && !targetNode.isOperation() || !this.resolveComputations(targetNode) || this.hasNode(targetNode)) continue;
            this.addNode(targetNode, RegionUtil.getNodeRole((Node)targetNode));
        }
    }

    protected void resolvePredicates() {
        for (Node targetNode : this.partitioner.getTrueNodes()) {
            if (this.partitioner.hasTrueNode(targetNode)) continue;
            for (Edge incomingEdge : RegionUtil.getIncomingEdges((Node)targetNode)) {
                HashSet sourceNodes;
                if (!incomingEdge.isComputation() || !this.isComputable(sourceNodes = Sets.newHashSet((Object[])new Node[]{targetNode}), incomingEdge)) continue;
                for (Node sourceNode : sourceNodes) {
                    if (this.hasNode(sourceNode)) continue;
                    this.addNode(sourceNode, RegionUtil.getNodeRole((Node)sourceNode));
                }
            }
        }
    }

    public String toString() {
        return this.partitioner.toString();
    }

    protected static class PartitionForest
    extends AbstractForestBuilder {
        protected PartitionForest(@NonNull Iterable<@NonNull Node> rootNodes, @NonNull Iterable<@NonNull NavigableEdge> edges) {
            super(rootNodes, edges);
        }

        protected @NonNull Iterable<@NonNull Node> getPredecessors(@NonNull Node targetNode) {
            HashSet<@NonNull Node> sourceNodes = new HashSet<Node>();
            NavigableEdge parentEdge = this.getParentEdge(targetNode);
            if (parentEdge != null) {
                Node sourceNode = parentEdge.getEdgeSource();
                if (sourceNode == targetNode) {
                    sourceNode = parentEdge.getEdgeTarget();
                }
                sourceNodes.add(sourceNode);
            }
            for (Edge edge : targetNode.getComputationEdges()) {
                sourceNodes.add(edge.getEdgeSource());
            }
            return sourceNodes;
        }
    }
}

