/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.base.Optional;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.coordinates.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.DependencyType;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.advisors.PathUtils;
import org.eclipse.recommenders.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedManualMappingsAdvisor
extends AbstractProjectCoordinateAdvisor {
    private static final Logger LOG = LoggerFactory.getLogger(SharedManualMappingsAdvisor.class);
    public static final ModelCoordinate MAPPINGS = new ModelCoordinate("org.eclipse.recommenders", "mappings", null, "properties", "1.0.0");
    private final IModelRepository repository;
    private List<Pair<String, ProjectCoordinate>> mappings;

    public SharedManualMappingsAdvisor(IModelRepository repository) {
        this.repository = repository;
    }

    protected boolean isApplicable(DependencyType any) {
        return true;
    }

    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        this.initializeMappings();
        String path = dependencyInfo.getFile().getAbsolutePath().replace(File.separatorChar, '/');
        for (Pair<String, ProjectCoordinate> mapping : this.mappings) {
            String suffixPattern = (String)mapping.getFirst();
            if (!PathUtils.matchesSuffixPattern(path, suffixPattern)) continue;
            return Optional.of((Object)((ProjectCoordinate)mapping.getSecond()));
        }
        return Optional.absent();
    }

    private synchronized void initializeMappings() {
        if (this.mappings == null) {
            Optional<File> mappingFile = this.repository.resolve(MAPPINGS, true);
            this.mappings = mappingFile.isPresent() ? this.readMappingFile((File)mappingFile.get()) : Collections.emptyList();
        }
    }

    private List<Pair<String, ProjectCoordinate>> readMappingFile(File mappingFile) {
        try {
            LinkedList<Pair<String, ProjectCoordinate>> result = new LinkedList<Pair<String, ProjectCoordinate>>();
            List lines = Files.readLines((File)mappingFile, (Charset)StandardCharsets.UTF_8);
            for (String line : lines) {
                ProjectCoordinate pc;
                if (StringUtils.isWhitespace((CharSequence)line) || this.isComment(line)) continue;
                String[] split = StringUtils.split((String)line, (String)"=");
                if (split.length != 2) {
                    LOG.error("Cannot parse line: {}", (Object)line);
                    throw new IllegalArgumentException();
                }
                String key = split[0];
                String value = split[1];
                try {
                    pc = ProjectCoordinate.valueOf((String)value);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Cannot parse project coordinate: {}", (Object)value);
                    throw e;
                }
                result.add((Pair<String, ProjectCoordinate>)Pair.newPair((Object)key, (Object)pc));
            }
            return result;
        }
        catch (Exception e) {
            LOG.error("Shared mappings are unavailable", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean isComment(String line) {
        return line.startsWith("#");
    }
}

