/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.notifications;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.mylyn.commons.notifications.core.AbstractNotification;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.recommenders.internal.news.rcp.CommonImages;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.recommenders.news.api.NewsItem;
import org.eclipse.swt.graphics.Image;

public class NewNewsItemsNotification
extends AbstractUiNotification {
    private static final String EVENT_ID = "org.eclipse.recommenders.news.rcp.event.newNewsItems";
    private final NewsItem newsItem;
    private final FeedDescriptor feed;
    private final Object token;
    private final ECommandService commandService;
    private final EHandlerService handlerService;

    public NewNewsItemsNotification(NewsItem newsItem, FeedDescriptor feed, Object token, ECommandService commandService, EHandlerService handlerService) {
        super(EVENT_ID);
        this.newsItem = newsItem;
        this.feed = feed;
        this.token = token;
        this.commandService = commandService;
        this.handlerService = handlerService;
    }

    public int compareTo(AbstractNotification other) {
        if (((Object)((Object)this)).getClass().equals(other.getClass())) {
            if (this.getDate().before(other.getDate())) {
                return 1;
            }
            if (this.getDate().after(other.getDate())) {
                return -1;
            }
            return 0;
        }
        return super.compareTo(other);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Image getNotificationImage() {
        return null;
    }

    public Image getNotificationKindImage() {
        return CommonImages.RSS_ACTIVE.createImage();
    }

    public void open() {
        ParameterizedCommand command = this.commandService.createCommand("org.eclipse.recommenders.news.rcp.command.readNewsItems", (Map)ImmutableMap.of((Object)"org.eclipse.recommenders.news.rcp.commandParameter.newsItems", Collections.singleton(this.newsItem), (Object)"org.eclipse.recommenders.news.rcp.commandParameter.openBrowser", (Object)true));
        this.handlerService.executeHandler(command);
    }

    public Date getDate() {
        return this.newsItem.getDate();
    }

    public String getDescription() {
        return MessageFormat.format(Messages.NOTIFICATION_DESCRIPTION, this.feed.getName());
    }

    public String getLabel() {
        return this.newsItem.getTitle();
    }

    public Object getToken() {
        return this.token;
    }
}

