/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessControlService;
import org.eclipse.remote.core.IRemoteProcessSignalService;
import org.eclipse.remote.core.IRemoteProcessTerminalService;
import org.eclipse.remote.internal.core.RemoteProcess;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;

public class ProxyProcess
extends RemoteProcess
implements IRemoteProcessControlService,
IRemoteProcessTerminalService {
    private IRemoteProcess remoteProcess;
    private final StreamChannel stdIOChan;
    private final StreamChannel stdErrChan;
    private final StreamChannel controlChan;
    private final DataOutputStream cmdStream;
    private final DataInputStream resultStream;
    private final Thread cmdThread;
    private volatile int exitValue;
    private volatile boolean isCompleted;

    public ProxyProcess(IRemoteConnection connection, IRemoteProcessBuilder builder, StreamChannel stdIO, StreamChannel stdErr, StreamChannel control) {
        super(connection, builder);
        this.stdIOChan = stdIO;
        this.stdErrChan = stdErr;
        this.controlChan = control;
        this.cmdStream = new DataOutputStream(control.getOutputStream());
        this.resultStream = new DataInputStream(control.getInputStream());
        this.isCompleted = false;
        this.exitValue = 0;
        this.cmdThread = new Thread("process " + (String)builder.command().get(0) + " result reader"){

            @Override
            public void run() {
                try {
                    ProxyProcess.this.exitValue = ProxyProcess.this.resultStream.readInt();
                }
                catch (IOException iOException) {}
                ProxyProcess.this.isCompleted = true;
                try {
                    ProxyProcess.this.stdIOChan.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    ProxyProcess.this.stdErrChan.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    ProxyProcess.this.controlChan.close();
                }
                catch (IOException iOException) {}
            }
        };
        this.cmdThread.start();
    }

    public void destroy() {
        try {
            this.cmdStream.writeByte(0);
            this.cmdStream.flush();
        }
        catch (IOException iOException) {
            this.isCompleted = true;
        }
    }

    public int exitValue() {
        if (!this.isCompleted) {
            throw new IllegalThreadStateException();
        }
        return this.exitValue;
    }

    public InputStream getErrorStream() {
        return this.stdErrChan.getInputStream();
    }

    public InputStream getInputStream() {
        return this.stdIOChan.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.stdIOChan.getOutputStream();
    }

    public int waitFor() throws InterruptedException {
        this.cmdThread.join();
        return this.exitValue;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public IRemoteProcess getRemoteProcess() {
        return this.remoteProcess;
    }

    public void setTerminalSize(int cols, int rows, int pwidth, int pheight) {
    }

    public static class Factory
    implements IRemoteProcess.Service.Factory {
        public <T extends IRemoteProcess.Service> T getService(IRemoteProcess remoteProcess, Class<T> service) {
            if (ProxyProcess.class.equals(service) && remoteProcess instanceof ProxyProcess) {
                return (T)((IRemoteProcess.Service)remoteProcess);
            }
            if (IRemoteProcessControlService.class.equals(service) || IRemoteProcessSignalService.class.equals(service) || IRemoteProcessTerminalService.class.equals(service)) {
                return (T)remoteProcess.getService(ProxyProcess.class);
            }
            return null;
        }
    }
}

