/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import java.util.Collection;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;

public class ValidatorPathName
extends ValidatorUniqueString {
    protected boolean fUnique;
    protected SystemMessage msg_Invalid;
    protected StringBuffer specialChars;
    private int nbrSpecialChars;

    public ValidatorPathName(Collection existingNameList) {
        super(existingNameList, false);
        this.init();
    }

    public ValidatorPathName(String[] existingNameList) {
        super(existingNameList, false);
        this.init();
    }

    public ValidatorPathName() {
        super(new String[0], false);
        this.init();
        this.fUnique = false;
    }

    protected void init() {
        super.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1032"), RSEUIPlugin.getPluginMessage("RSEG1033"));
        this.fUnique = true;
        this.msg_Invalid = RSEUIPlugin.getPluginMessage("RSEG1034");
        this.specialChars = new StringBuffer("*?;'<>|");
        this.nbrSpecialChars = this.specialChars.length();
    }

    public void setErrorMessages(SystemMessage msg_Empty, SystemMessage msg_NonUnique, SystemMessage msg_Invalid) {
        super.setErrorMessages(msg_Empty, msg_NonUnique);
        this.msg_Invalid = msg_Invalid;
    }

    public SystemMessage isSyntaxOk(String newText) {
        boolean ok;
        boolean bl = ok = !this.containsSpecialCharacters(newText);
        if (!ok) {
            return this.msg_Invalid;
        }
        return null;
    }

    protected boolean containsSpecialCharacters(String newText) {
        boolean contains = false;
        int newLen = newText.length();
        int idx = 0;
        while (!contains && idx < newLen) {
            int jdx = 0;
            while (!contains && jdx < this.nbrSpecialChars) {
                if (newText.charAt(idx) == this.specialChars.charAt(jdx)) {
                    contains = true;
                }
                ++jdx;
            }
            ++idx;
        }
        return contains;
    }

    public String toString() {
        return "PathValidator class";
    }
}

