/******************************************************************************
 * Copyright (c) 2016 Oracle
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Shenxue Zhou - initial implementation and ongoing maintenance
 ******************************************************************************/

package org.eclipse.sapphire.ui.swt.gef;

import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/**
 * @author <a href="mailto:shenxue.zhou@oracle.com">Shenxue Zhou</a>
 */

class SapphireDiagramOutline extends Page implements IContentOutlinePage
{
	/** the control of the outline */
	private Canvas overview;
	/** the root edit part */
	private ScalableFreeformRootEditPart rootEditPart;
	
	/** the thumbnail */
	private Thumbnail thumbnail;
	
	/**
	 * Creates a new OverviewOutlinePage instance.
	 * @param rootEditPart the root edit part to show the overview from
	 */
	public SapphireDiagramOutline(ScalableFreeformRootEditPart rootEditPart ) 
	{
	    super();
	    this.rootEditPart = rootEditPart;
	}
	
	/**
	 * 
	 */
	public void addSelectionChangedListener(ISelectionChangedListener listener)
	{}
	
	@Override
	public void createControl(Composite parent)
	{
	    // create canvas and lws
	    overview = new Canvas(parent, SWT.NONE);
	    LightweightSystem lws = new LightweightSystem(overview);
	
	    // create thumbnail
	    thumbnail =
	        new ScrollableThumbnail((Viewport) rootEditPart.getFigure());
	    thumbnail.setBorder(new MarginBorder(3));
	    thumbnail.setSource(
	        rootEditPart.getLayer(LayerConstants.PRINTABLE_LAYERS));
	    lws.setContents(thumbnail);
	}
	
	@Override
	public void dispose()
	{
	    if (null != thumbnail)
	        thumbnail.deactivate();
	
	    super.dispose();
	}
	
	/**
	 * 
	 */
	public Control getControl()
	{
	    return overview;
	}
	
	/**
	 * 
	 */
	public ISelection getSelection()
	{
	    return StructuredSelection.EMPTY;
	}
	
	/**
	 * 
	 */
	public void removeSelectionChangedListener(ISelectionChangedListener listener)
	{}
	
	/**
	 * 
	 */
	public void setFocus()
	{
	    if (getControl() != null)
	        getControl().setFocus();
	}
	
	/**
	 * 
	 */
	public void setSelection(ISelection selection)
	{}

}
