/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.contextbuttons;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButton;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.IContextButtonPadDeclaration;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.PositionedContextButton;
import org.eclipse.sapphire.ui.swt.gef.figures.FigureUtil;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;

public class ContextButtonPad
extends Shape {
    private static final int DEFAULT_ANIMATION_DURATION = 200;
    private static final double ANIMATION_START_TRANSPARENCY = 0.0;
    private static final double ANIMATION_END_TRANSPARENCY = 1.0;
    private IContextButtonPadDeclaration declaration;
    private double zoomLevel;
    private SapphireDiagramEditor editor;
    private List<GraphicalEditPart> editParts;
    private Path pathOuterLine;
    private Path pathMiddleLine;
    private Path pathInnerLine;
    private Path pathFill;
    private List<org.eclipse.draw2d.geometry.Rectangle> containmentRectangles;
    private List<org.eclipse.draw2d.geometry.Rectangle> overlappingContainmentRectangles;
    private double currentTransparency = 1.0;
    private long animationDuration = 200L;

    public ContextButtonPad(IContextButtonPadDeclaration declaration, double zoomLevel, SapphireDiagramEditor editor, List<GraphicalEditPart> editParts) {
        this.declaration = declaration;
        this.zoomLevel = zoomLevel;
        this.editor = editor;
        this.editParts = new ArrayList<GraphicalEditPart>();
        this.editParts.addAll(editParts);
        this.initialize();
    }

    public final IContextButtonPadDeclaration getDeclaration() {
        return this.declaration;
    }

    public final double getZoomLevel() {
        return this.zoomLevel;
    }

    public final SapphireDiagramEditor getEditor() {
        return this.editor;
    }

    private void initialize() {
        this.initializeContainments();
        this.createContextButtons();
    }

    private void initializeContainments() {
        org.eclipse.draw2d.geometry.Rectangle transformedRectangle;
        this.containmentRectangles = new ArrayList<org.eclipse.draw2d.geometry.Rectangle>();
        this.overlappingContainmentRectangles = new ArrayList<org.eclipse.draw2d.geometry.Rectangle>();
        for (Rectangle rectangle : this.getDeclaration().getContainmentRectangles()) {
            transformedRectangle = this.transformGenericRectangle(rectangle, 0);
            this.containmentRectangles.add(transformedRectangle);
        }
        for (Rectangle rectangle : this.getDeclaration().getOverlappingContainmentRectangles()) {
            transformedRectangle = this.transformGenericRectangle(rectangle, 0);
            this.overlappingContainmentRectangles.add(transformedRectangle);
        }
        if (this.overlappingContainmentRectangles.size() > 0) {
            org.eclipse.draw2d.geometry.Rectangle unionRectangle = this.overlappingContainmentRectangles.get(0).getCopy();
            for (org.eclipse.draw2d.geometry.Rectangle containmentRectangle : this.overlappingContainmentRectangles) {
                unionRectangle.union(containmentRectangle);
            }
            unionRectangle.expand(2, 2);
            this.setBounds(unionRectangle);
        }
    }

    private void createContextButtons() {
        List<PositionedContextButton> positionedButtons = this.getDeclaration().getPositionedContextButtons();
        this.setLayoutManager((LayoutManager)new XYLayout());
        for (PositionedContextButton positionedButton : positionedButtons) {
            org.eclipse.draw2d.geometry.Rectangle position = this.transformGenericRectangle(positionedButton.getPosition(), 0);
            position.translate(-this.getBounds().getTopLeft().x, -this.getBounds().getTopLeft().y);
            ContextButton cb = new ContextButton(positionedButton, this);
            this.add((IFigure)cb, position);
        }
    }

    private void createPathes() {
        this.pathOuterLine = this.createPath(0);
        this.pathMiddleLine = this.createPath(1);
        this.pathInnerLine = this.createPath(2);
        this.pathFill = this.createPath(3);
    }

    private void disposePathes() {
        this.pathOuterLine.dispose();
        this.pathMiddleLine.dispose();
        this.pathInnerLine.dispose();
        this.pathFill.dispose();
        this.pathOuterLine = null;
        this.pathMiddleLine = null;
        this.pathInnerLine = null;
        this.pathFill = null;
    }

    private Path createPath(int shrinkLines) {
        double zoom = this.getZoomLevel();
        int lw = shrinkLines * (int)((double)this.getDeclaration().getPadLineWidth() * zoom);
        double corner = (double)this.getDeclaration().getPadCornerRadius() * zoom;
        corner = Math.max(1.0, corner - ((double)lw + corner / 64.0));
        org.eclipse.draw2d.geometry.Rectangle topAdjusted = this.transformGenericRectangle(this.getDeclaration().getTopPad(), shrinkLines);
        org.eclipse.draw2d.geometry.Rectangle rightAdjusted = this.transformGenericRectangle(this.getDeclaration().getRightPad(), shrinkLines);
        org.eclipse.draw2d.geometry.Rectangle bottomAdjusted = this.transformGenericRectangle(this.getDeclaration().getBottomPad(), shrinkLines);
        Path path = this.createPath(topAdjusted, rightAdjusted, bottomAdjusted, (int)corner);
        return path;
    }

    private Path createPath(org.eclipse.draw2d.geometry.Rectangle topOutside, org.eclipse.draw2d.geometry.Rectangle rightOutside, org.eclipse.draw2d.geometry.Rectangle bottomOutside, int corner) {
        int appendageCorner;
        boolean hasAppendageRight;
        Path path = new Path(null);
        int innerCorner = corner / 2;
        org.eclipse.draw2d.geometry.Rectangle top = FigureUtil.getAdjustedRectangle(topOutside, 1.0, (int)((double)this.getDeclaration().getPadLineWidth() * this.getZoomLevel()));
        org.eclipse.draw2d.geometry.Rectangle right = FigureUtil.getAdjustedRectangle(rightOutside, 1.0, (int)((double)this.getDeclaration().getPadLineWidth() * this.getZoomLevel()));
        org.eclipse.draw2d.geometry.Rectangle bottom = FigureUtil.getAdjustedRectangle(bottomOutside, 1.0, (int)((double)this.getDeclaration().getPadLineWidth() * this.getZoomLevel()));
        boolean hasTop = top != null;
        boolean hasRight = right != null;
        boolean hasStandardTop = hasTop && this.getDeclaration().getTopPadStyle().equals((Object)IContextButtonPadDeclaration.PadStyle.STANDARD);
        boolean hasStandardRight = hasRight && this.getDeclaration().getRightPadStyle().equals((Object)IContextButtonPadDeclaration.PadStyle.STANDARD);
        boolean hasAppendageTop = hasTop && this.getDeclaration().getTopPadStyle().equals((Object)IContextButtonPadDeclaration.PadStyle.APPENDAGE);
        boolean bl = hasAppendageRight = hasRight && this.getDeclaration().getRightPadStyle().equals((Object)IContextButtonPadDeclaration.PadStyle.APPENDAGE);
        if (hasStandardTop) {
            path.addArc((float)(top.getTopRight().x - corner), (float)top.getTopRight().y, (float)corner, (float)corner, 0.0f, 90.0f);
            path.addArc((float)top.getTopLeft().x, (float)top.getTopLeft().y, (float)corner, (float)corner, 90.0f, 90.0f);
            path.addArc((float)top.getBottomLeft().x, (float)(top.getBottomLeft().y - corner), (float)corner, (float)corner, 180.0f, 90.0f);
        } else if (hasAppendageTop) {
            appendageCorner = Math.min(corner, top.height * 2);
            path.addArc((float)top.getTopLeft().x, (float)top.getTopLeft().y, (float)appendageCorner, (float)appendageCorner, 90.0f, 90.0f);
            path.lineTo((float)top.getBottomLeft().x, (float)top.getBottomLeft().y);
        } else {
            path.addArc((float)right.getTopLeft().x, (float)right.getTopLeft().y, (float)corner, (float)corner, 90.0f, 90.0f);
        }
        if (hasTop && hasRight) {
            path.addArc((float)(right.getLeft().x - innerCorner), (float)top.getBottom().y, (float)innerCorner, (float)innerCorner, 90.0f, -90.0f);
        }
        if (hasStandardRight) {
            if (bottom == null) {
                path.addArc((float)right.getBottomLeft().x, (float)(right.getBottomLeft().y - corner), (float)corner, (float)corner, 180.0f, 90.0f);
            } else {
                path.addArc((float)(right.getLeft().x - innerCorner), (float)(bottom.getTop().y - innerCorner), (float)innerCorner, (float)innerCorner, 0.0f, -90.0f);
                path.addArc((float)bottom.getTopLeft().x, (float)bottom.getTopLeft().y, (float)corner, (float)corner, 90.0f, 90.0f);
                path.addArc((float)bottom.getBottomLeft().x, (float)(bottom.getBottomLeft().y - corner), (float)corner, (float)corner, 180.0f, 90.0f);
                path.addArc((float)(bottom.getBottomRight().x - corner), (float)(bottom.getBottomRight().y - corner), (float)corner, (float)corner, 270.0f, 90.0f);
                path.addArc((float)bottom.getRight().x, (float)right.getBottom().y, (float)corner, (float)corner, 180.0f, -90.0f);
            }
            path.addArc((float)(right.getBottomRight().x - corner), (float)(right.getBottomRight().y - corner), (float)corner, (float)corner, 270.0f, 90.0f);
            path.addArc((float)(right.getTopRight().x - corner), (float)right.getTopRight().y, (float)corner, (float)corner, 0.0f, 90.0f);
        } else if (hasAppendageRight) {
            appendageCorner = Math.min(corner, right.width * 2);
            path.lineTo((float)right.getBottomLeft().x, (float)right.getBottomLeft().y);
            path.addArc((float)(right.getBottomRight().x - appendageCorner), (float)(right.getBottomRight().y - appendageCorner), (float)appendageCorner, (float)appendageCorner, 270.0f, 90.0f);
        } else {
            path.addArc((float)(top.getBottomRight().x - corner), (float)(top.getBottomRight().y - corner), (float)corner, (float)corner, 270.0f, 90.0f);
        }
        if (hasStandardTop && hasStandardRight) {
            path.addArc((float)top.getRight().x, (float)(right.getTop().y - corner), (float)corner, (float)corner, 270.0f, -90.0f);
        }
        path.close();
        return path;
    }

    private org.eclipse.draw2d.geometry.Rectangle transformGenericRectangle(Rectangle source, int shrinkLines) {
        if (source == null) {
            return null;
        }
        double zoom = this.getZoomLevel();
        int lw = shrinkLines * (int)((double)this.getDeclaration().getPadLineWidth() * zoom);
        org.eclipse.draw2d.geometry.Rectangle target = new org.eclipse.draw2d.geometry.Rectangle(source.x, source.y, source.width, source.height);
        target.scale(zoom);
        int widthShrink = Math.min(target.width / 2, lw);
        int heightShrink = Math.min(target.height / 2, lw);
        target.shrink(widthShrink, heightShrink);
        return target;
    }

    protected void outlineShape(Graphics graphics) {
        int lw = (int)(this.getZoomLevel() * (double)this.getDeclaration().getPadLineWidth());
        graphics.setLineWidth(lw);
        graphics.setForegroundColor(this.getEditor().getResourceCache().getColor(this.getDeclaration().getPadInnerLineColor()));
        graphics.drawPath(this.pathInnerLine);
        graphics.setForegroundColor(this.getEditor().getResourceCache().getColor(this.getDeclaration().getPadMiddleLineColor()));
        graphics.drawPath(this.pathMiddleLine);
        graphics.setForegroundColor(this.getEditor().getResourceCache().getColor(this.getDeclaration().getPadOuterLineColor()));
        graphics.drawPath(this.pathOuterLine);
    }

    public void paintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        graphics.setAlpha((int)(this.currentTransparency * this.getDeclaration().getPadDefaultOpacity() * 255.0));
        this.createPathes();
        super.paintFigure(graphics);
        this.disposePathes();
    }

    protected void fillShape(Graphics graphics) {
        int lw = (int)(this.getZoomLevel() * (double)this.getDeclaration().getPadLineWidth());
        graphics.setLineWidth(lw);
        graphics.setForegroundColor(this.getEditor().getResourceCache().getColor(this.getDeclaration().getPadFillColor()));
        graphics.setBackgroundColor(this.getEditor().getResourceCache().getColor(this.getDeclaration().getPadFillColor()));
        graphics.drawPath(this.pathFill);
        graphics.fillPath(this.pathFill);
    }

    private void doAnimation() {
        long startTime = System.currentTimeMillis();
        long stepsDone = 0L;
        this.currentTransparency = 0.0;
        while (this.isPadShowing() && this.currentTransparency < 1.0) {
            this.forceRepaint();
            long elapsedTime = Math.max(1L, System.currentTimeMillis() - startTime);
            long restTime = Math.max(1L, this.animationDuration - elapsedTime);
            double restSteps = (double)(++stepsDone * restTime) / (double)elapsedTime;
            double deltaTransparency = (1.0 - this.currentTransparency) / restSteps;
            this.currentTransparency += deltaTransparency;
            if (elapsedTime <= this.animationDuration) continue;
            this.currentTransparency = 1.0;
        }
        this.currentTransparency = 1.0;
        this.forceRepaint();
    }

    private void forceRepaint() {
        if (this.isPadShowing()) {
            this.repaint();
            while (Display.getCurrent().readAndDispatch()) {
            }
        }
    }

    public boolean containsPoint(int x, int y) {
        boolean ret = false;
        for (org.eclipse.draw2d.geometry.Rectangle rectangle : this.containmentRectangles) {
            if (!rectangle.contains(x, y)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public final List<GraphicalEditPart> getEditParts() {
        return this.editParts;
    }

    public boolean containsPointOverlapping(int x, int y) {
        boolean ret = false;
        for (org.eclipse.draw2d.geometry.Rectangle rectangle : this.overlappingContainmentRectangles) {
            if (!rectangle.contains(x, y)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public double getCurrentTransparency() {
        return this.currentTransparency;
    }

    private boolean isPadShowing() {
        boolean hasParent = this.getParent() != null;
        return hasParent;
    }
}

