/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.editor;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ui.tools.internal.actions.session.OpenRepresentationAction;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationNavigationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.provider.Messages;

public final class MenuHelper {
    public static final String OPEN_REPRESENTATION_GROUP_SEPARATOR = "openRepresentationGroup";

    private MenuHelper() {
    }

    public static boolean buildOpenRepresentationActions(IMenuManager openMenu, IInterpreter interpreter, RepresentationNavigationDescription navDesc, DRepresentationElement element, Session session, AdapterFactory adapterFactory) {
        boolean atLeastOneRepresentationActionsWasCreated = false;
        Collection<EObject> candidates = MenuHelper.findCandidates(element, navDesc, interpreter);
        for (EObject candidate : candidates) {
            Collection representations = DialectManager.INSTANCE.getRepresentations(candidate, session);
            for (DRepresentation representation : representations) {
                if (navDesc.getRepresentationDescription() == null || !navDesc.getRepresentationDescription().equals(DialectManager.INSTANCE.getDescription(representation))) continue;
                interpreter.setVariable(navDesc.getRepresentationNameVariable().getName(), (Object)representation.getName());
                String label = new StringBuffer().append(new IdentifiedElementQuery((IdentifiedElement)navDesc).getLabel()).append(representation.getName()).toString();
                if (!StringUtil.isEmpty((String)navDesc.getNavigationNameExpression())) {
                    try {
                        label = interpreter.evaluateString(element.getTarget(), navDesc.getNavigationNameExpression());
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getRepresentationNavigationDescription_NavigationNameExpression(), (Throwable)e);
                    }
                }
                openMenu.appendToGroup(OPEN_REPRESENTATION_GROUP_SEPARATOR, MenuHelper.buildOpenRepresentationAction(session, representation, label, adapterFactory));
                atLeastOneRepresentationActionsWasCreated = true;
            }
        }
        return atLeastOneRepresentationActionsWasCreated;
    }

    private static Collection<EObject> findCandidates(DRepresentationElement element, RepresentationNavigationDescription navDesc, IInterpreter interpreter) {
        Collection candidates;
        if (!StringUtil.isEmpty((String)navDesc.getBrowseExpression())) {
            RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
            EAttribute browseExpressionFeature = ToolPackage.eINSTANCE.getRepresentationNavigationDescription_BrowseExpression();
            candidates = safeInterpreter.evaluateCollection(element.getTarget(), (EObject)navDesc, (EStructuralFeature)browseExpressionFeature);
        } else {
            ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(element.getTarget());
            candidates = Lists.newArrayList((Iterator)modelAccessor.eAllContents(element.getTarget()));
        }
        return candidates;
    }

    public static IAction buildOpenRepresentationAction(Session session, DRepresentation representation, AdapterFactory adapterFactory) {
        String representationName = representation.getName();
        if (StringUtil.isEmpty((String)representationName)) {
            representationName = Messages.MenuHelper_anonymousRepresentation;
            RepresentationDescription representationDescription = DialectManager.INSTANCE.getDescription(representation);
            if (representationDescription != null) {
                representationName = String.valueOf(representationName) + " " + new IdentifiedElementQuery((IdentifiedElement)representationDescription).getLabel();
            }
        }
        return MenuHelper.buildOpenRepresentationAction(session, representation, representationName, adapterFactory);
    }

    private static IAction buildOpenRepresentationAction(Session session, DRepresentation representation, String label, AdapterFactory adapterFactory) {
        ImageDescriptor imageDescriptor = null;
        IItemLabelProvider labelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)representation, IItemLabelProvider.class);
        if (labelProvider != null) {
            imageDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)representation));
        }
        if (imageDescriptor == null) {
            imageDescriptor = SiriusTransPlugin.getBundledImageDescriptor((String)"/icons/LinkToSirius.gif");
        }
        return new OpenRepresentationAction(label, imageDescriptor, representation, session);
    }
}

