/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.viewpoint;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class ViewpointsSelectionGraphicalHandler {
    private GridLayout rootGridLayout;
    private Browser browser;
    private Composite rootComposite;
    private GridData browserGridData;
    private CheckboxTableViewer viewer;
    private GridData rootLayoutData;
    private GridData viewerGridData;
    private GridData browserErrorMessageLayoutData;
    private Text browserErrorMessageText;
    private Composite browserErrorMessageComposite;
    private Composite browserRootComposite;

    public Composite getRootComposite() {
        return this.rootComposite;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Composite getBrowserRootComposite() {
        return this.browserRootComposite;
    }

    public Collection<String> computeSemanticFileExtensions(Session theSession) {
        HashSet<String> extensions = new HashSet<String>();
        for (Resource resource : theSession.getSemanticResources()) {
            String currentFileExtension;
            if (resource == null || resource.getURI() == null || (currentFileExtension = resource.getURI().fileExtension()) == null) continue;
            extensions.add(currentFileExtension);
        }
        return extensions;
    }

    public void createControl(Composite parent, boolean makeColumnsEqual) {
        this.rootComposite = new Composite(parent, 0);
        this.rootGridLayout = GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(makeColumnsEqual).create();
        this.rootComposite.setLayout((Layout)this.rootGridLayout);
        this.rootLayoutData = new GridData(4, 4, true, true);
        this.rootComposite.setLayoutData((Object)this.rootLayoutData);
        this.createTableViewer(this.rootComposite);
        this.createBrowser(this.rootComposite);
        this.setBrowserInput(null);
    }

    public Browser createBrowser(Composite parent) {
        this.browserRootComposite = new Composite(parent, 2048);
        this.browserRootComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.browserRootComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browserErrorMessageComposite = new Composite(this.browserRootComposite, 0);
        this.browserErrorMessageComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.browserErrorMessageLayoutData = new GridData(4, 4, true, false);
        this.browserErrorMessageComposite.setLayoutData((Object)this.browserErrorMessageLayoutData);
        this.browserErrorMessageLayoutData.exclude = true;
        Composite browserComposite = new Composite(this.browserRootComposite, 0);
        browserComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        browserComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browserErrorMessageText = new Text(this.browserErrorMessageComposite, 66);
        this.browserErrorMessageText.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.browserErrorMessageText.setText("");
        this.browserErrorMessageText.setForeground(this.browserRootComposite.getDisplay().getSystemColor(3));
        try {
            Browser aBrowser = new Browser(browserComposite, 4);
            this.browserGridData = new GridData(4, 4, true, true);
            this.browserGridData.widthHint = 0;
            this.browserGridData.heightHint = 0;
            aBrowser.setLayoutData((Object)this.browserGridData);
            this.browser = aBrowser;
            return aBrowser;
        }
        catch (SWTError sWTError) {
            return null;
        }
    }

    public void setBrowserErrorMessageText(String errorMessage) {
        this.browserErrorMessageLayoutData.exclude = false;
        this.browserErrorMessageText.setText(errorMessage);
        this.browserErrorMessageComposite.setVisible(true);
        this.browserRootComposite.layout(true, true);
    }

    public void clearBrowserErrorMessageText() {
        this.browserErrorMessageLayoutData.exclude = true;
        this.browserErrorMessageText.setText("");
        this.browserErrorMessageComposite.setVisible(false);
        this.browserRootComposite.getParent().layout(true, true);
    }

    public void setBrowserMinWidth(int minwidth) {
        if (this.browserGridData != null) {
            this.browserGridData.minimumWidth = minwidth;
        }
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    private TableViewer createTableViewer(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2820);
        Table table = this.viewer.getTable();
        this.viewerGridData = new GridData(4, 4, false, false);
        this.viewer.getControl().setLayoutData((Object)this.viewerGridData);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewpointsTableLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Viewpoint) {
                    ViewpointsSelectionGraphicalHandler.this.setBrowserInput((Viewpoint)firstElement);
                }
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer theViewer, Object e1, Object e2) {
                String e1label = new IdentifiedElementQuery((IdentifiedElement)((Viewpoint)e1)).getLabel();
                String e2label = new IdentifiedElementQuery((IdentifiedElement)((Viewpoint)e2)).getLabel();
                return e1label.compareTo(e2label);
            }
        });
        return this.viewer;
    }

    public void setBrowserInput(Viewpoint viewpoint) {
        if (this.browser != null) {
            String content = null;
            content = this.containsHTMLDocumentation(viewpoint) ? this.getContentWhenHtml(viewpoint) : this.getContentWhenNoHtml(viewpoint);
            this.browser.setText(content);
        }
    }

    private boolean containsHTMLDocumentation(Viewpoint viewpoint) {
        String doc;
        if (viewpoint != null && !StringUtil.isEmpty((String)(doc = viewpoint.getEndUserDocumentation()))) {
            return doc.startsWith("<html>");
        }
        return false;
    }

    private String getContentWhenHtml(Viewpoint viewpoint) {
        String document = viewpoint.getEndUserDocumentation();
        LinkedHashSet urlToRewrite = Sets.newLinkedHashSet();
        this.extractUrlToRewrite(document, urlToRewrite);
        return this.rewriteURLs(viewpoint, document, urlToRewrite);
    }

    private void extractUrlToRewrite(String document, Set<String> urlToRewrite) {
        int imgSrcStartIndex;
        int imgSrcStopIndex;
        String imgSrcPattern = "img src=\"";
        int patternStartIndex = document.indexOf(imgSrcPattern);
        if (patternStartIndex != -1 && (imgSrcStopIndex = document.indexOf("\"", imgSrcStartIndex = patternStartIndex + imgSrcPattern.length())) != -1) {
            String newToRewrite = document.substring(imgSrcStartIndex, imgSrcStopIndex);
            urlToRewrite.add(newToRewrite);
            this.extractUrlToRewrite(document.substring(imgSrcStopIndex), urlToRewrite);
        }
    }

    private String rewriteURLs(Viewpoint viewpoint, String document, Set<String> urls) {
        String newDocument = document;
        for (String url : urls) {
            newDocument = newDocument.replace(url, this.rewriteURL(viewpoint, url));
        }
        StringBuilder css = new StringBuilder();
        this.appendCss(css);
        String headClose = "</head>";
        newDocument = newDocument.replace(headClose, css.append(headClose));
        return newDocument;
    }

    private String rewriteURL(Viewpoint viewpoint, String url) {
        URI uri = viewpoint.eResource().getURI();
        String pluginId = uri.segment(1);
        String rewrittenURL = "";
        if (uri.isPlatformPlugin()) {
            Bundle bundle = Platform.getBundle((String)pluginId);
            URL imageURL = bundle.getEntry(url);
            String string = rewrittenURL = imageURL != null ? imageURL.toString() : rewrittenURL;
            if (imageURL != null) {
                try {
                    URL fileURL = FileLocator.toFileURL((URL)imageURL);
                    rewrittenURL = fileURL.toString();
                }
                catch (IOException iOException) {}
            }
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path("/" + pluginId + url);
            if (workspace.getRoot().exists((IPath)path)) {
                IResource resource = workspace.getRoot().findMember((IPath)path);
                rewrittenURL = resource.getLocation().toFile().toURI().toString();
            }
        }
        return rewrittenURL;
    }

    private String getContentWhenNoHtml(Viewpoint viewpoint) {
        StringBuilder content = new StringBuilder();
        return this.begin(content).head(content).body(content, viewpoint).end(content);
    }

    private ViewpointsSelectionGraphicalHandler begin(StringBuilder content) {
        content.append("<html>");
        return this;
    }

    private ViewpointsSelectionGraphicalHandler head(StringBuilder content) {
        content.append("<head>");
        this.appendCss(content);
        content.append("</head>");
        return this;
    }

    private ViewpointsSelectionGraphicalHandler body(StringBuilder content, Viewpoint viewpoint) {
        content.append("<body>");
        if (viewpoint == null) {
            content.append("<br><br><center><b>").append(Messages.ViewpointsSelectionWizardPage_documentation_title).append("</b></center>");
        } else {
            String endUserDocumentation = viewpoint.getEndUserDocumentation();
            if (!StringUtil.isEmpty((String)endUserDocumentation)) {
                content.append(viewpoint.getEndUserDocumentation());
            } else {
                content.append(Messages.ViewpointsSelectionWizardPage_documentation_none);
            }
        }
        content.append("</body>");
        return this;
    }

    private StringBuilder appendCss(StringBuilder content) {
        Font currentFont = JFaceResources.getDialogFont();
        FontData data = currentFont.getFontData()[0];
        String fontName = data.getName();
        int fontHeight = data.getHeight() + 3;
        content.append("<style type=\"text/css\">");
        content.append("body{font-family:" + fontName + ",Arial, sans-serif;}");
        content.append("body{font-size:" + fontHeight + "px;}");
        content.append("</style>");
        return content;
    }

    private String end(StringBuilder content) {
        content.append("</html>");
        return content.toString();
    }

    public void setHeight(int height) {
        this.viewerGridData.grabExcessVerticalSpace = false;
        this.viewerGridData.heightHint = height;
    }

    private class ViewpointsTableLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider {
        ViewpointsTableLabelProvider() {
            super(ViewHelper.INSTANCE.createAdapterFactory());
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            if (columnIndex == 0) {
                if (element instanceof Viewpoint) {
                    Viewpoint vp = (Viewpoint)element;
                    image = ViewpointHelper.getImage(vp);
                } else {
                    image = super.getImage(element);
                }
            }
            return image;
        }
    }
}

