/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFileModificationValidator;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;

public class MoveDeleteHook
implements IMoveDeleteHook {
    public boolean deleteFile(final IResourceTree tree, final IFile file, final int updateFlags, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, 100);
            if (file.isTeamPrivateMember()) {
                return false;
            }
            ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor(file);
            if (cvsFile.isIgnored()) {
                return false;
            }
            if (!this.checkOutFiles(tree, new IFile[]{file}, Policy.subMonitorFor(monitor, 30))) {
                return true;
            }
            try {
                EclipseSynchronizer.getInstance().performMoveDelete(new ICVSRunnable(){

                    @Override
                    public void run(IProgressMonitor monitor) throws CVSException {
                        try {
                            monitor.beginTask(null, 100);
                            EclipseSynchronizer.getInstance().prepareForDeletion((IResource)file, Policy.subMonitorFor(monitor, 40));
                            tree.standardDeleteFile(file, updateFlags, Policy.subMonitorFor(monitor, 60));
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }, Policy.subMonitorFor(monitor, 70));
            }
            catch (CVSException e) {
                tree.failed(e.getStatus());
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public boolean deleteFolder(final IResourceTree tree, final IFolder folder, final int updateFlags, IProgressMonitor monitor) {
        if (folder.isTeamPrivateMember()) {
            return false;
        }
        monitor.beginTask(null, 100);
        try {
            ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)folder);
            if (cvsFolder.isCVSFolder() && this.ensureCheckedOut(new IFolder[]{folder}, tree, Policy.subMonitorFor(monitor, 30))) {
                EclipseSynchronizer.getInstance().performMoveDelete(new ICVSRunnable(){

                    @Override
                    public void run(IProgressMonitor monitor) throws CVSException {
                        try {
                            monitor.beginTask(null, 100);
                            EclipseSynchronizer.getInstance().prepareForDeletion((IResource)folder, Policy.subMonitorFor(monitor, 20));
                            tree.standardDeleteFolder(folder, updateFlags, Policy.subMonitorFor(monitor, 50));
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }, Policy.subMonitorFor(monitor, 70));
                return true;
            }
            try {
                if (!cvsFolder.isIgnored()) {
                    EclipseSynchronizer.getInstance().prepareForDeletion(cvsFolder.getIResource(), Policy.subMonitorFor(monitor, 70));
                }
            }
            catch (CVSException e) {
                tree.failed(e.getStatus());
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        try {
            EclipseSynchronizer.getInstance().prepareForDeletion((IResource)project, monitor);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return false;
    }

    public boolean moveFile(final IResourceTree tree, final IFile source, final IFile destination, final int updateFlags, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, 100);
            IFile[] filesToCheckOut = destination.exists() ? new IFile[]{source, destination} : new IFile[]{source};
            if (!this.checkOutFiles(tree, filesToCheckOut, Policy.subMonitorFor(monitor, 30))) {
                return true;
            }
            try {
                EclipseSynchronizer.getInstance().performMoveDelete(new ICVSRunnable(){

                    @Override
                    public void run(IProgressMonitor monitor) throws CVSException {
                        try {
                            monitor.beginTask(null, 100);
                            EclipseSynchronizer.getInstance().prepareForDeletion((IResource)source, Policy.subMonitorFor(monitor, 40));
                            if (destination.exists()) {
                                EclipseSynchronizer.getInstance().prepareForDeletion((IResource)destination, Policy.subMonitorFor(monitor, 20));
                            }
                            tree.standardMoveFile(source, destination, updateFlags, Policy.subMonitorFor(monitor, 40));
                            EclipseSynchronizer.getInstance().postMove((IResource)destination);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }, Policy.subMonitorFor(monitor, 70));
            }
            catch (CVSException e) {
                tree.failed(e.getStatus());
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public boolean moveFolder(final IResourceTree tree, final IFolder source, final IFolder destination, final int updateFlags, IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        try {
            ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)source);
            if (cvsFolder.isManaged()) {
                if (!this.ensureCheckedOut(new IFolder[]{source, destination}, tree, Policy.subMonitorFor(monitor, 20))) {
                    return true;
                }
                EclipseSynchronizer.getInstance().performMoveDelete(new ICVSRunnable(){

                    @Override
                    public void run(IProgressMonitor monitor) throws CVSException {
                        EclipseSynchronizer.getInstance().prepareForDeletion((IResource)source, Policy.subMonitorFor(monitor, 20));
                        if (destination.exists()) {
                            EclipseSynchronizer.getInstance().prepareForDeletion((IResource)destination, Policy.subMonitorFor(monitor, 20));
                        }
                        tree.standardMoveFolder(source, destination, updateFlags, Policy.subMonitorFor(monitor, 30));
                        this.purgeCVSFolders(destination, Policy.subMonitorFor(monitor, 20));
                        EclipseSynchronizer.getInstance().postMove((IResource)destination);
                    }

                    private void purgeCVSFolders(IFolder destination2, final IProgressMonitor monitor) throws CVSException {
                        try {
                            destination2.accept(new IResourceVisitor(){

                                public boolean visit(IResource resource) throws CoreException {
                                    if (resource.getType() == 2 && resource.getName().equals("CVS")) {
                                        tree.standardDeleteFolder((IFolder)resource, updateFlags, monitor);
                                        return false;
                                    }
                                    return true;
                                }
                            }, 2, 2);
                        }
                        catch (CoreException e) {
                            throw CVSException.wrapException(e);
                        }
                    }
                }, Policy.subMonitorFor(monitor, 60));
                return true;
            }
            try {
                if (!cvsFolder.isIgnored()) {
                    EclipseSynchronizer.getInstance().prepareForDeletion(cvsFolder.getIResource(), Policy.subMonitorFor(monitor, 60));
                }
            }
            catch (CVSException e) {
                tree.failed(e.getStatus());
                return true;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        try {
            EclipseSynchronizer.getInstance().prepareForDeletion((IResource)source, monitor);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return false;
    }

    boolean checkOutFiles(IResourceTree tree, IFile[] files, IProgressMonitor monitor) {
        FileModificationValidator validator = this.getFileModificationValidator(files);
        if (validator instanceof ICVSFileModificationValidator) {
            IStatus status = ((ICVSFileModificationValidator)validator).validateMoveDelete(files, monitor);
            if (status.isOK()) {
                return true;
            }
            tree.failed(status);
            return false;
        }
        return true;
    }

    private boolean ensureCheckedOut(IFolder[] folders, IResourceTree tree, IProgressMonitor monitor) {
        ArrayList readOnlyFiles;
        block5: {
            readOnlyFiles = new ArrayList();
            try {
                int i = 0;
                while (i < folders.length) {
                    IFolder folder = folders[i];
                    if (folder.exists()) {
                        folder.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                IFile file;
                                if (resource.getType() == 1 && (file = (IFile)resource).isReadOnly()) {
                                    readOnlyFiles.add(file);
                                }
                                return true;
                            }
                        });
                    }
                    ++i;
                }
                if (!readOnlyFiles.isEmpty()) break block5;
                return true;
            }
            catch (CoreException e) {
                tree.failed(e.getStatus());
                return false;
            }
        }
        return this.checkOutFiles(tree, readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]), monitor);
    }

    private FileModificationValidator getFileModificationValidator(IFile[] files) {
        return this.getProvider(files).getFileModificationValidator2();
    }

    private CVSTeamProvider getProvider(IFile[] files) {
        CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)files[0].getProject(), (String)CVSProviderPlugin.getTypeId());
        return provider;
    }
}

