/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelParticipantAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.ide.IDE;

public abstract class CVSModelProviderAction
extends ResourceModelParticipantAction {
    public CVSModelProviderAction(ISynchronizePageConfiguration configuration) {
        super(null, configuration);
        Utils.initAction((IAction)this, (String)this.getBundleKeyPrefix(), (ResourceBundle)Policy.getActionBundle());
    }

    protected String getBundleKeyPrefix() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + ".";
    }

    protected ResourceMapping[] getResourceMappings(IStructuredSelection selection) {
        ArrayList<ResourceMapping> mappings = new ArrayList<ResourceMapping>();
        for (Object element : selection) {
            ResourceMapping mapping = Utils.getResourceMapping(element);
            if (mapping == null) continue;
            mappings.add(mapping);
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    public final boolean saveDirtyEditors() {
        return !this.needsToSaveDirtyEditors() || this.saveAllEditors(this.getTargetResources(), this.confirmSaveOfDirtyEditor());
    }

    protected IResource[] getTargetResources() {
        IStructuredSelection selection = this.getStructuredSelection();
        Object[] objects = selection.toArray();
        HashSet<IResource> roots = new HashSet<IResource>();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            ResourceMapping mapping = Utils.getResourceMapping((Object)object);
            if (mapping != null) {
                try {
                    ResourceTraversal[] traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
                    int j = 0;
                    while (j < traversals.length) {
                        ResourceTraversal traversal = traversals[j];
                        IResource[] resources = traversal.getResources();
                        int k = 0;
                        while (k < resources.length) {
                            IResource resource = resources[k];
                            roots.add(resource);
                            ++k;
                        }
                        ++j;
                    }
                }
                catch (CoreException e) {
                    TeamUIPlugin.log((CoreException)e);
                }
            }
            ++i;
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    public final boolean saveAllEditors(IResource[] resources, boolean confirm) {
        return IDE.saveAllEditors((IResource[])resources, (boolean)confirm);
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }

    protected boolean confirmSaveOfDirtyEditor() {
        return true;
    }

    public void run() {
        if (this.saveDirtyEditors()) {
            this.execute();
        }
    }

    protected abstract void execute();
}

