/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;

public class TreatAsEditsOperation
extends AbstractWorkingCopyOperation {
    public TreatAsEditsOperation(IResource[] resources) {
        super("Operation_TreatAsEdits", SVNUIMessages.class, resources);
    }

    public TreatAsEditsOperation(IResourceProvider provider) {
        super("Operation_TreatAsEdits", SVNUIMessages.class, provider);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            if (resources[i].getType() == 1) {
                IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resources[i]);
                final File originalFile = new File(FileUtility.getWorkingCopyPath((IResource)resources[i]));
                File tmpFile = new File(String.valueOf(originalFile.getAbsolutePath()) + ".svntmp");
                originalFile.renameTo(tmpFile);
                final ISVNConnector proxy = location.acquireSVNProxy();
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        proxy.revert(new String[]{originalFile.getAbsolutePath()}, SVNDepth.EMPTY, null, 0L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)TreatAsEditsOperation.this, monitor, null));
                    }
                }, monitor, resources.length);
                location.releaseSVNProxy(proxy);
                originalFile.delete();
                tmpFile.renameTo(originalFile);
            }
            ++i;
        }
    }
}

