/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository.browser;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.AbstractSVNView;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.action.AbstractSVNTeamAction;
import org.eclipse.team.svn.ui.action.remote.DeleteAction;
import org.eclipse.team.svn.ui.action.remote.OpenFileAction;
import org.eclipse.team.svn.ui.action.remote.management.DiscardRepositoryLocationAction;
import org.eclipse.team.svn.ui.action.remote.management.DiscardRevisionLinksAction;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.repository.RepositoriesView;
import org.eclipse.team.svn.ui.repository.RepositoryTreeViewer;
import org.eclipse.team.svn.ui.repository.browser.RepositoryBrowserContentProvider;
import org.eclipse.team.svn.ui.repository.browser.RepositoryBrowserLabelProvider;
import org.eclipse.team.svn.ui.repository.browser.RepositoryBrowserTableViewer;
import org.eclipse.team.svn.ui.repository.model.IParentTreeNode;
import org.eclipse.team.svn.ui.repository.model.IResourceTreeNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryError;
import org.eclipse.team.svn.ui.repository.model.RepositoryFictiveNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryFictiveWorkingDirectory;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.repository.model.RepositoryLocation;
import org.eclipse.team.svn.ui.repository.model.RepositoryPending;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;

public class RepositoryBrowser
extends AbstractSVNView
implements ISelectionChangedListener,
RepositoryTreeViewer.IRefreshListener {
    public static final String VIEW_ID = RepositoryBrowser.class.getName();
    protected static RepositoryBrowser instance = null;
    protected IPartListener2 partListener;
    protected RepositoryResource inputElement;
    protected Object rawInputElement;
    protected RepositoryFile selectedFile;
    protected IRepositoryLocation location;
    protected RepositoryBrowserTableViewer tableViewer;
    protected RepositoryBrowserContentProvider contentProvider;

    public RepositoryBrowser() {
        super(SVNUIMessages.RepositoriesView_Browser_Description);
        instance = this;
    }

    public IRepositoryResource getResource() {
        return this.repositoryResource;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object firstElement = this.getSelectedElement(event.getSelection());
        if (firstElement != null) {
            boolean selectedFileChanged = false;
            if (firstElement instanceof RepositoryFile) {
                RepositoryTreeViewer repositoryTree;
                TreeItem[] items;
                RepositoriesView instance;
                if (!((RepositoryFile)firstElement).equals(this.selectedFile)) {
                    selectedFileChanged = true;
                    this.selectedFile = (RepositoryFile)firstElement;
                }
                if ((instance = RepositoriesView.instance()) != null && (items = (repositoryTree = instance.getRepositoryTree()).getIdenticalNodes(firstElement, true)) != null && items.length != 0 && items[0] != null) {
                    TreeItem item = items[0].getParentItem();
                    firstElement = item != null ? item.getData() : repositoryTree.getInput();
                }
            } else if (this.selectedFile != null) {
                this.selectedFile = null;
                selectedFileChanged = true;
            }
            if (firstElement instanceof RepositoryLocation) {
                this.rawInputElement = firstElement;
                firstElement = ((RepositoryLocation)firstElement).getResourceWrapper();
            } else {
                this.rawInputElement = null;
            }
            if (firstElement instanceof RepositoryResource) {
                if (this.getResource() == null || !this.getResource().equals(((RepositoryResource)firstElement).getRepositoryResource()) || selectedFileChanged) {
                    this.connectTo((RepositoryResource)firstElement);
                    this.refreshTableView();
                }
                return;
            }
        }
        this.disconnect();
    }

    public void refreshed(Object data) {
        this.refreshTableView();
    }

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.tableViewer = new RepositoryBrowserTableViewer(parent, 66306);
        this.tableViewer.initialize();
        this.contentProvider = new RepositoryBrowserContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new RepositoryBrowserLabelProvider(this.tableViewer));
        MenuManager menuMgr = RepositoriesView.newMenuInstance((ISelectionProvider)this.tableViewer);
        this.tableViewer.getTable().setMenu(menuMgr.createContextMenu((Control)this.tableViewer.getTable()));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        Action refreshAction = new Action(SVNUIMessages.SVNView_Refresh_Label){

            public void run() {
                RepositoryBrowser.this.handleRefresh();
            }
        };
        refreshAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif"));
        refreshAction.setToolTipText(SVNUIMessages.SVNView_Refresh_ToolTip);
        tbm.add((IAction)refreshAction);
        this.tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    RepositoryBrowser.this.handleRefresh();
                }
                if (RepositoryBrowser.this.tableViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoryBrowser.this.tableViewer.getSelection();
                    if (event.keyCode == 127) {
                        RepositoryBrowser.this.handleDeleteKey(selection);
                        RepositoriesView.refresh(RepositoryBrowser.this.repositoryResource);
                    }
                }
                if (event.keyCode == 8) {
                    RepositoryBrowser.this.handleBackspaceKey();
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection structured;
                ISelection selection = e.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                    RepositoryBrowser.this.handleDoubleClick(structured);
                }
            }
        });
        this.tableViewer.refresh();
        this.showResourceLabel();
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
                this.setViewState(partRef, true);
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                this.setViewState(partRef, false);
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(VIEW_ID)) {
                    RepositoryBrowser.this.getViewSite().getPage().removePartListener((IPartListener2)this);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            protected void setViewState(IWorkbenchPartReference partRef, boolean visible) {
                if (partRef.getId().equals(VIEW_ID) || partRef.getId().equals(RepositoriesView.VIEW_ID)) {
                    if (partRef.getId().equals(VIEW_ID)) {
                        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
                        SVNTeamPreferences.setRepositoryBoolean(store, "repositoryBrowser", visible);
                    }
                    RepositoryBrowser.this.setViewState(visible);
                }
            }
        };
        this.getViewSite().getPage().addPartListener(this.partListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.repositoryBrowserViewContext");
    }

    protected void connectTo(RepositoryResource inputElement) {
        this.inputElement = inputElement;
        this.repositoryResource = inputElement.getRepositoryResource();
        this.showResourceLabel();
    }

    protected void refreshTableView() {
        if (!this.tableViewer.getTable().isDisposed()) {
            boolean hideGrid = false;
            if (this.inputElement instanceof RepositoryFolder) {
                Object[] children = ((RepositoryFolder)this.inputElement).peekChildren(null);
                hideGrid = children != null && children.length > 0 && children[0] instanceof RepositoryFictiveNode;
            }
            this.tableViewer.getTable().setLinesVisible(!hideGrid);
            this.tableViewer.setInput(this.inputElement);
            if (this.selectedFile != null) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedFile), true);
            } else {
                this.tableViewer.getTable().setSelection(0);
            }
        }
    }

    protected void setViewState(boolean visible) {
        RepositoriesView instance = RepositoriesView.instance();
        if (instance != null) {
            instance.refreshButtonsState();
            RepositoryTreeViewer viewer = instance.getRepositoryTree();
            if (visible) {
                this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)viewer, viewer.getSelection()));
                viewer.addSelectionChangedListener(this);
                viewer.addRefreshListener(this);
            } else {
                viewer.removeSelectionChangedListener(this);
                viewer.removeRefreshListener(this);
            }
        }
        if (!visible) {
            this.disconnect();
        }
    }

    protected void handleRefresh() {
        if (this.repositoryResource != null) {
            UIMonitorUtility.doTaskBusyDefault((IActionOperation)new RefreshRemoteResourcesOperation(new IRepositoryResource[]{this.repositoryResource}));
        }
    }

    protected void handleDeleteKey(IStructuredSelection selection) {
        Action tmp = new Action(){};
        AbstractRepositoryTeamAction action = new DeleteAction();
        action.selectionChanged((IAction)tmp, (ISelection)selection);
        action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
        if (tmp.isEnabled()) {
            action.run((IAction)tmp);
        } else {
            action = new DiscardRevisionLinksAction();
            action.selectionChanged((IAction)tmp, (ISelection)selection);
            action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
            if (tmp.isEnabled()) {
                action.run((IAction)tmp);
            } else {
                action = new DiscardRepositoryLocationAction();
                action.selectionChanged((IAction)tmp, (ISelection)selection);
                action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
                if (tmp.isEnabled()) {
                    action.run((IAction)tmp);
                }
            }
        }
    }

    protected void handleBackspaceKey() {
        Object data;
        Table table = this.tableViewer.getTable();
        TableItem[] items = table.getItems();
        if (items != null && items.length != 0 && items[0] != null && !((data = items[0].getData()) instanceof RepositoryError) && !(data instanceof RepositoryPending)) {
            this.goUp();
        }
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        Action tmp = new Action(){};
        OpenFileAction action = new OpenFileAction();
        ((AbstractSVNTeamAction)action).selectionChanged((IAction)tmp, (ISelection)selection);
        action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
        if (tmp.isEnabled()) {
            action.run((IAction)tmp);
        } else {
            Object node = selection.getFirstElement();
            if (node instanceof RepositoryFictiveWorkingDirectory) {
                this.goUp();
            } else if (node instanceof IParentTreeNode) {
                this.goDown(node);
            }
        }
    }

    protected void goUp() {
        RepositoriesView view = RepositoriesView.instance();
        RepositoryResource node = this.inputElement;
        if (view == null || node == null) {
            return;
        }
        Object parent = node.getParent();
        if (parent != null) {
            Table table;
            TreeItem[] items;
            RepositoryResource oldInput = node;
            if (this.isTopLevelNode(view.getRepositoryTree(), node)) {
                this.goBack(view, node);
            } else {
                RepositoryTreeViewer treeViewer = view.getRepositoryTree();
                items = treeViewer.getIdenticalNodes(node, false);
                if (items != null && items.length != 0 && items[0] != null && items != parent) {
                    parent = items[0].getParentItem().getData();
                }
                treeViewer.setExpandedState(parent, true);
                treeViewer.setSelection((ISelection)new StructuredSelection(parent));
            }
            if (this.inputElement != null && (items = (table = this.tableViewer.getTable()).getItems()) != null && items.length != 0) {
                int i = 0;
                while (i < items.length) {
                    Object data = items[i].getData();
                    if (((Object)oldInput).equals(data)) {
                        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)oldInput), true);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    protected void goBack(RepositoriesView view, Object node) {
        if (!view.canGoBack()) {
            return;
        }
        view.goBack();
        if (this.inputElement != null) {
            RepositoryTreeViewer treeViewer;
            TreeItem[] items;
            view.getRepositoryTree().setExpandedState(this.inputElement, true);
            if (node.equals(this.inputElement) && (items = (treeViewer = view.getRepositoryTree()).getIdenticalNodes(this.inputElement, false)) != null && items.length != 0 && items[0] != null) {
                if (items[0].getParentItem() != null) {
                    Object newSelectedElement = items[0].getParentItem().getData();
                    if (newSelectedElement != null) {
                        treeViewer.setSelection((ISelection)new StructuredSelection(newSelectedElement));
                    }
                } else {
                    this.goBack(view, node);
                }
            }
        }
    }

    protected void goDown(Object node) {
        RepositoriesView view = RepositoriesView.instance();
        if (view == null || !(node instanceof IResourceTreeNode)) {
            return;
        }
        RepositoryTreeViewer treeViewer = view.getRepositoryTree();
        treeViewer.setExpandedState(this.rawInputElement == null ? this.inputElement : this.rawInputElement, true);
        treeViewer.setExpandedState(node, true);
        treeViewer.setSelection((ISelection)new StructuredSelection(node));
    }

    protected boolean isTopLevelNode(RepositoryTreeViewer tree, Object node) {
        TreeItem[] items = tree.getIdenticalNodes(node, false);
        if (items != null && items.length != 0 && items[0] != null) {
            return items[0].getParentItem() == null;
        }
        return true;
    }

    protected void disconnect() {
        this.repositoryResource = null;
        this.inputElement = null;
        this.showResourceLabel();
        this.tableViewer.setInput(null);
        this.tableViewer.getTable().setLinesVisible(false);
    }

    protected void disconnectView() {
    }

    public void refresh() {
    }

    protected boolean needsLinkWithEditorAndSelection() {
        return false;
    }

    protected Object getSelectedElement(ISelection selection) {
        IStructuredSelection structured;
        Object selectedElement = null;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
            selectedElement = structured.getFirstElement();
        }
        return selectedElement;
    }
}

