/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageComposite;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageXYViewer;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;

public class CpuUsageView
extends TmfChartView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.views.cpuusage";
    public static final @NonNull String CPU_USAGE_SELECTED_THREAD = "org.eclipse.tracecompass.analysis.os.linux.views.cpuusage.CPU_USAGE_SELECTED_TRHEAD";
    public static final @NonNull String CPU_USAGE_FOLLOW_CPU = "org.eclipse.tracecompass.analysis.os.linux.views.cpuusage.FOLLOW_CPU";
    private @Nullable CpuUsageComposite fTreeViewer = null;
    private @Nullable CpuUsageXYViewer fXYViewer = null;

    public CpuUsageView() {
        super(Messages.CpuUsageView_Title);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            if (this.fTreeViewer != null) {
                this.fTreeViewer.traceSelected(signal);
            }
            if (this.fXYViewer != null) {
                this.fXYViewer.traceSelected(signal);
            }
        }
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        CpuUsageXYViewer viewer = new CpuUsageXYViewer(parent);
        viewer.setSendTimeAlignSignals(true);
        this.fXYViewer = viewer;
        return viewer;
    }

    public TmfViewer createLeftChildViewer(Composite parent) {
        CpuUsageComposite viewer = new CpuUsageComposite(parent);
        viewer.addSelectionChangeListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object structSelection;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (structSelection = ((IStructuredSelection)selection).getFirstElement()) instanceof CpuUsageEntry) {
                    CpuUsageEntry entry = (CpuUsageEntry)((Object)structSelection);
                    if (CpuUsageView.this.fTreeViewer != null) {
                        CpuUsageView.this.fTreeViewer.setSelectedThread(entry.getTid());
                    }
                    if (CpuUsageView.this.fXYViewer != null) {
                        CpuUsageView.this.fXYViewer.setSelectedThread(Long.valueOf(entry.getTid()));
                    }
                    CpuUsageView.this.saveData(CpuUsageView.CPU_USAGE_SELECTED_THREAD, entry.getTid());
                }
            }
        });
        viewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                super.controlResized(e);
            }
        });
        this.fTreeViewer = viewer;
        return this.fTreeViewer;
    }

    private void saveData(@NonNull String key, @NonNull Object data) {
        ITmfTrace trace = this.getViewerTrace();
        if (trace == null) {
            return;
        }
        TmfTraceManager.getInstance().updateTraceContext(trace, builder -> builder.setData(key, data));
    }

    private Object getData(@NonNull String key) {
        ITmfTrace trace = this.getViewerTrace();
        if (trace == null) {
            return null;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext(trace);
        return ctx.getData(key);
    }

    private ITmfTrace getViewerTrace() {
        CpuUsageComposite treeViewer = this.fTreeViewer;
        return treeViewer != null ? treeViewer.getTrace() : null;
    }

    public void setFocus() {
        if (this.fXYViewer != null) {
            this.fXYViewer.getControl().setFocus();
        }
    }

    @TmfSignalHandler
    public void cpuSelect(TmfCpuSelectedSignal signal) {
        @Nullable CpuUsageXYViewer xyViewer = this.fXYViewer;
        @Nullable CpuUsageComposite treeViewer = this.fTreeViewer;
        if (xyViewer != null && treeViewer != null) {
            TreeSet data = this.getData(CPU_USAGE_FOLLOW_CPU);
            if (data == null) {
                data = new TreeSet();
            }
            if (data instanceof Set) {
                Set set = data;
                int core = signal.getCore();
                if (core >= 0) {
                    xyViewer.addCpu(core);
                    treeViewer.addCpu(core);
                    if (Iterables.all((Iterable)set, (Predicate)Predicates.instanceOf(Integer.class))) {
                        Set intSet = set;
                        intSet.add(core);
                    }
                } else {
                    xyViewer.clearCpu();
                    treeViewer.clearCpu();
                    ((Set)data).clear();
                }
                this.saveData(CPU_USAGE_FOLLOW_CPU, data);
            } else {
                Activator.getDefault().logError("The followed cores should have been store in a Set");
            }
        }
    }
}

