/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readonly.TmfXmlReadOnlyModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.w3c.dom.Element;

public class XmlEntry
extends TimeGraphEntry
implements IXmlStateSystemContainer,
Comparable<XmlEntry> {
    private static final String EMPTY_STRING = "";
    private final @NonNull ITmfTrace fTrace;
    private final EntryDisplayType fType;
    private final int fBaseQuark;
    private final int fDisplayQuark;
    private final String fParentId;
    private final String fId;
    private final @NonNull ITmfStateSystem fSs;
    private final @Nullable Element fElement;

    public XmlEntry(int baseQuark, int displayQuark, @NonNull ITmfTrace trace, String name, long startTime, long endTime, EntryDisplayType type, @NonNull ITmfStateSystem ss, Element entryElement) {
        super(name, startTime, endTime);
        String nameFromSs;
        this.fTrace = trace;
        this.fType = type;
        this.fBaseQuark = baseQuark;
        this.fDisplayQuark = displayQuark;
        this.fSs = ss;
        this.fElement = entryElement;
        List elements = TmfXmlUtils.getChildElements((Element)this.fElement, (String)"parent");
        this.fParentId = elements.size() > 0 ? this.getFirstValue((Element)elements.get(0)) : EMPTY_STRING;
        elements = TmfXmlUtils.getChildElements((Element)this.fElement, (String)"name");
        if (elements.size() > 0 && !(nameFromSs = this.getFirstValue((Element)elements.get(0))).isEmpty()) {
            this.setName(nameFromSs);
        }
        this.fId = (elements = TmfXmlUtils.getChildElements((Element)this.fElement, (String)"id")).size() > 0 ? this.getFirstValue((Element)elements.get(0)) : name;
    }

    public XmlEntry(int baseQuark, @NonNull ITmfTrace trace, String name, @NonNull ITmfStateSystem ss) {
        super(name, ss.getStartTime(), ss.getCurrentEndTime());
        this.fTrace = trace;
        this.fType = EntryDisplayType.NULL;
        this.fBaseQuark = baseQuark;
        this.fDisplayQuark = baseQuark;
        this.fSs = ss;
        this.fElement = null;
        this.fParentId = EMPTY_STRING;
        this.fId = name;
    }

    private String getFirstValue(Element stateAttribute) {
        ITmfStateInterval firstInterval;
        if (stateAttribute == null) {
            throw new IllegalArgumentException();
        }
        ITmfXmlModelFactory factory = TmfXmlReadOnlyModelFactory.getInstance();
        ITmfXmlStateAttribute display = factory.createStateAttribute(stateAttribute, (IXmlStateSystemContainer)this);
        int quark = display.getAttributeQuark(this.fBaseQuark, null);
        if (quark != -1 && (firstInterval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)this.fSs, (int)quark, (long)this.getStartTime(), (long)this.getEndTime())) != null) {
            return firstInterval.getStateValue().toString();
        }
        return EMPTY_STRING;
    }

    public @NonNull ITmfTrace getTrace() {
        return this.fTrace;
    }

    public EntryDisplayType getType() {
        return this.fType;
    }

    public int getDisplayQuark() {
        return this.fDisplayQuark;
    }

    public String getId() {
        return this.fId;
    }

    public String getParentId() {
        return this.fParentId;
    }

    public boolean hasTimeEvents() {
        return this.fType != EntryDisplayType.NULL;
    }

    public @NonNull ITmfStateSystem getStateSystem() {
        return this.fSs;
    }

    public String getAttributeValue(String name) {
        return name;
    }

    public Iterable<TmfXmlLocation> getLocations() {
        return Collections.EMPTY_SET;
    }

    public Iterator<@NonNull ITimeEvent> getTimeEventsIterator() {
        return super.getTimeEventsIterator();
    }

    public boolean matches(@NonNull Pattern pattern) {
        if (pattern.matcher(this.getName()).find()) {
            return true;
        }
        if (pattern.matcher(this.fId).find()) {
            return true;
        }
        return pattern.matcher(this.fParentId).find();
    }

    @Override
    public int compareTo(XmlEntry other) {
        String otherAttrib;
        int cmp = this.getType().compareTo(other.getType());
        if (cmp != 0) {
            return cmp;
        }
        Element element = this.fElement;
        String attrib = element == null ? EMPTY_STRING : element.getAttribute("path");
        cmp = attrib.compareTo(otherAttrib = (element = other.fElement) == null ? EMPTY_STRING : element.getAttribute("path"));
        if (cmp != 0) {
            return cmp;
        }
        return this.getName().compareTo(other.getName());
    }

    public static enum EntryDisplayType {
        NULL,
        DISPLAY;

    }
}

