/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statesystem;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.backends.partial.PartialHistoryBackend;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.backends.partial.PartialStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceCompleteness;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public abstract class TmfStateSystemAnalysisModule
extends TmfAbstractAnalysisModule
implements ITmfAnalysisModuleWithStateSystems {
    private static final Logger LOGGER = TraceCompassLog.getLogger(TmfStateSystemAnalysisModule.class);
    private static final String EXTENSION = ".ht";
    private final CountDownLatch fInitialized = new CountDownLatch(1);
    private final Object fRequestSyncObj = new Object();
    private @Nullable ITmfStateSystemBuilder fStateSystem;
    private @Nullable ITmfEventRequest fRequest;
    private @Nullable TmfTimeRange fTimeRange = null;
    private int fNbRead = 0;
    private boolean fInitializationSucceeded;
    private volatile @Nullable ITmfStateProvider fStateProvider;

    public static @Nullable ITmfStateSystem getStateSystem(ITmfTrace trace, String moduleId) {
        TmfStateSystemAnalysisModule module = TmfTraceUtils.getAnalysisModuleOfClass(trace, TmfStateSystemAnalysisModule.class, moduleId);
        if (module != null) {
            ITmfStateSystem ss = module.getStateSystem();
            if (ss != null) {
                return ss;
            }
            IStatus status = module.schedule();
            if (status.isOK()) {
                return module.waitForInitialization() ? module.getStateSystem() : null;
            }
        }
        return null;
    }

    protected abstract ITmfStateProvider createStateProvider();

    protected StateSystemBackendType getBackendType() {
        return StateSystemBackendType.FULL;
    }

    protected String getSsFileName() {
        return String.valueOf(this.getId()) + EXTENSION;
    }

    public @Nullable ITmfStateSystem getStateSystem() {
        return this.fStateSystem;
    }

    @Override
    public boolean waitForInitialization() {
        try {
            this.fInitialized.await();
        }
        catch (InterruptedException e) {
            return false;
        }
        return this.fInitializationSucceeded;
    }

    @Override
    protected void onFail() {
        super.onFail();
        if (this.fInitialized.getCount() > 0L) {
            this.analysisReady(false);
        }
    }

    @Override
    public boolean isQueryable(long ts) {
        ITmfStateProvider provider = this.fStateProvider;
        if (provider == null) {
            return true;
        }
        return ts <= provider.getLatestSafeTime();
    }

    @VisibleForTesting
    protected @Nullable File getSsFile() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return null;
        }
        String directory = TmfTraceManager.getSupplementaryFileDir(trace);
        File htFile = new File(String.valueOf(directory) + this.getSsFileName());
        return htFile;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        mon = monitor == null ? new NullProgressMonitor() : monitor;
        provider = this.createStateProvider();
        id = this.getId();
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                log = new TraceCompassLogUtils.ScopeLog(TmfStateSystemAnalysisModule.LOGGER, Level.FINE, "StateSystemAnalysis:executing", new Object[]{"id", id});
                try {
                    backend = this.getBackendType();
                    trace = this.getTrace();
                    if (trace == null) {
                        this.analysisReady(false);
                        return false;
                    }
                    switch (TmfStateSystemAnalysisModule.$SWITCH_TABLE$org$eclipse$tracecompass$tmf$core$statesystem$TmfStateSystemAnalysisModule$StateSystemBackendType()[backend.ordinal()]) {
                        case 1: {
                            htFile = this.getSsFile();
                            if (htFile == null) {
                                return false;
                            }
                            this.createFullHistory(id, provider, htFile);
                            ** break;
lbl22:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            htFile = this.getSsFile();
                            if (htFile == null) {
                                return false;
                            }
                            this.createPartialHistory(id, provider, htFile);
                            ** break;
lbl29:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            this.createInMemoryHistory(id, provider);
                            ** break;
lbl33:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            this.createNullHistory(id, provider);
                            ** break;
lbl37:
                            // 1 sources

                            break;
                        }
                    }
                }
                finally {
                    if (log == null) return false;
                    log.close();
                }
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                    throw var5_5;
                }
                if (var5_5 == var6_9) throw var5_5;
                var5_5.addSuppressed(var6_9);
                throw var5_5;
            }
        }
        catch (TmfTraceException e) {
            this.analysisReady(false);
            return false;
        }
        if (mon.isCanceled() == false) return true;
        return false;
    }

    private void analysisReady(boolean succeeded) {
        this.fInitializationSucceeded = succeeded;
        this.fInitialized.countDown();
    }

    @Override
    protected void canceling() {
        ITmfEventRequest req = this.fRequest;
        if (req != null && !req.isCompleted()) {
            req.cancel();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fStateSystem != null) {
            this.fStateSystem.dispose();
        }
    }

    private void createFullHistory(String id, ITmfStateProvider provider, File htFile) throws TmfTraceException {
        if (htFile.exists()) {
            int version = provider.getVersion();
            try {
                IStateHistoryBackend backend = StateHistoryBackendFactory.createHistoryTreeBackendExistingFile((String)id, (File)htFile, (int)version);
                this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend, (boolean)false);
                this.analysisReady(true);
                return;
            }
            catch (IOException backend) {
                // empty catch block
            }
        }
        int QUEUE_SIZE = 10000;
        try {
            IStateHistoryBackend backend = StateHistoryBackendFactory.createHistoryTreeBackendNewFile((String)id, (File)htFile, (int)provider.getVersion(), (long)provider.getStartTime(), (int)10000);
            this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
            provider.assignTargetStateSystem(this.fStateSystem);
            this.build(provider);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.toString(), e);
        }
    }

    private void createPartialHistory(String id, ITmfStateProvider provider, File htPartialFile) throws TmfTraceException {
        int QUEUE_SIZE = 10000;
        long granularity = 50000L;
        IStateHistoryBackend realBackend = null;
        try {
            realBackend = StateHistoryBackendFactory.createHistoryTreeBackendNewFile((String)id, (File)htPartialFile, (int)provider.getVersion(), (long)provider.getStartTime(), (int)10000);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.toString(), e);
        }
        ITmfStateProvider partialProvider = provider.getNewInstance();
        PartialStateSystem pss = new PartialStateSystem();
        partialProvider.assignTargetStateSystem((ITmfStateSystemBuilder)pss);
        PartialHistoryBackend partialBackend = new PartialHistoryBackend(String.valueOf(id) + ".partial", partialProvider, pss, realBackend, 50000L);
        ITmfStateSystemBuilder realSS = StateSystemFactory.newStateSystem((IStateHistoryBackend)partialBackend);
        pss.assignUpstream(realSS);
        provider.assignTargetStateSystem(realSS);
        this.fStateSystem = realSS;
        this.build(provider);
    }

    private void createNullHistory(String id, ITmfStateProvider provider) {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createNullBackend((String)id);
        this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
        provider.assignTargetStateSystem(this.fStateSystem);
        this.build(provider);
    }

    private void createInMemoryHistory(String id, ITmfStateProvider provider) {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)id, (long)provider.getStartTime());
        this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
        provider.assignTargetStateSystem(this.fStateSystem);
        this.build(provider);
    }

    private void disposeProvider(boolean deleteFiles) {
        ITmfStateProvider provider = this.fStateProvider;
        boolean shouldDeleteFiles = deleteFiles;
        if (provider != null) {
            provider.dispose();
            Throwable failureCause = provider.getFailureCause();
            if (failureCause != null) {
                this.fail(failureCause);
                shouldDeleteFiles = true;
            }
        }
        this.fStateProvider = null;
        if (shouldDeleteFiles && this.fStateSystem != null) {
            this.fStateSystem.removeFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(ITmfStateProvider provider) {
        if (this.fStateSystem == null) {
            throw new IllegalArgumentException();
        }
        ITmfEventRequest request = this.fRequest;
        if (request != null && !request.isCompleted()) {
            request.cancel();
        }
        this.fTimeRange = TmfTimeRange.ETERNITY;
        ITmfTrace trace = provider.getTrace();
        if (!TmfStateSystemAnalysisModule.isCompleteTrace(trace)) {
            this.fTimeRange = trace.getTimeRange();
        }
        this.fStateProvider = provider;
        Object object = this.fRequestSyncObj;
        synchronized (object) {
            this.startRequest();
            request = this.fRequest;
        }
        this.analysisReady(true);
        try {
            if (request != null) {
                request.waitForCompletion();
                if (request.isFailed()) {
                    Throwable failureCause = request.getFailureCause();
                    if (failureCause != null) {
                        this.fail(failureCause);
                    } else {
                        this.fail(new RuntimeException("Event request failed without a cause"));
                    }
                }
            }
        }
        catch (InterruptedException e) {
            this.fail(e);
        }
    }

    @Override
    public @Nullable ITmfStateSystem getStateSystem(String id) {
        if (id.equals(this.getId())) {
            return this.fStateSystem;
        }
        return null;
    }

    @Override
    public @NonNull Iterable<@NonNull ITmfStateSystem> getStateSystems() {
        ITmfStateSystemBuilder stateSystem = this.fStateSystem;
        if (stateSystem == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(stateSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        this.fTimeRange = signal.getRange();
        ITmfStateProvider stateProvider = this.fStateProvider;
        Object object = this.fRequestSyncObj;
        synchronized (object) {
            ITmfEventRequest request;
            if (signal.getTrace() == this.getTrace() && stateProvider != null && stateProvider.getAssignedStateSystem() != null && ((request = this.fRequest) == null || request.isCompleted())) {
                this.startRequest();
            }
        }
    }

    private void startRequest() {
        ITmfStateProvider stateProvider = this.fStateProvider;
        TmfTimeRange timeRange = this.fTimeRange;
        if (stateProvider == null || timeRange == null) {
            return;
        }
        ITmfEventRequest request = this.createEventRequest(stateProvider, timeRange, this.fNbRead);
        stateProvider.getTrace().sendRequest(request);
        this.fRequest = request;
    }

    @VisibleForTesting
    protected ITmfEventRequest createEventRequest(ITmfStateProvider stateProvider, TmfTimeRange timeRange, int nbRead) {
        return new StateSystemEventRequest(stateProvider, timeRange, nbRead);
    }

    private static boolean isCompleteTrace(ITmfTrace trace) {
        return !(trace instanceof ITmfTraceCompleteness) || ((ITmfTraceCompleteness)((Object)trace)).isComplete();
    }

    @Override
    public @NonNull Map<@NonNull String, @NonNull String> getProperties() {
        Map<@NonNull String, @NonNull String> properties = super.getProperties();
        StateSystemBackendType backend = this.getBackendType();
        properties.put((String)NonNullUtils.checkNotNull((Object)Messages.TmfStateSystemAnalysisModule_PropertiesBackend), backend.name());
        switch (backend) {
            case FULL: 
            case PARTIAL: {
                File htFile = this.getSsFile();
                if (htFile == null) break;
                if (htFile.exists()) {
                    properties.put((String)NonNullUtils.checkNotNull((Object)Messages.TmfStateSystemAnalysisModule_PropertiesFileSize), FileUtils.byteCountToDisplaySize((long)htFile.length()));
                    break;
                }
                properties.put((String)NonNullUtils.checkNotNull((Object)Messages.TmfStateSystemAnalysisModule_PropertiesFileSize), (String)NonNullUtils.checkNotNull((Object)Messages.TmfStateSystemAnalysisModule_PropertiesAnalysisNotExecuted));
                break;
            }
        }
        return properties;
    }

    protected static enum StateSystemBackendType {
        FULL,
        INMEM,
        NULL,
        PARTIAL;

    }

    @VisibleForTesting
    protected class StateSystemEventRequest
    extends TmfEventRequest {
        private final ITmfStateProvider sci;
        private final ITmfTrace trace;

        public StateSystemEventRequest(ITmfStateProvider sp, TmfTimeRange timeRange, int index) {
            super(ITmfEvent.class, timeRange, index, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, TmfStateSystemAnalysisModule.this.getDependencyLevel());
            this.sci = sp;
            this.trace = this.sci.getTrace();
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.trace) {
                this.sci.processEvent(event);
            } else if (this.trace instanceof TmfExperiment) {
                for (ITmfTrace childTrace : ((TmfExperiment)this.trace).getTraces()) {
                    if (childTrace != event.getTrace()) continue;
                    this.sci.processEvent(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleSuccess() {
            super.handleSuccess();
            if (TmfStateSystemAnalysisModule.isCompleteTrace(this.trace)) {
                TmfStateSystemAnalysisModule.this.disposeProvider(false);
            } else {
                TmfStateSystemAnalysisModule tmfStateSystemAnalysisModule = TmfStateSystemAnalysisModule.this;
                tmfStateSystemAnalysisModule.fNbRead = tmfStateSystemAnalysisModule.fNbRead + this.getNbRead();
                Object object = TmfStateSystemAnalysisModule.this.fRequestSyncObj;
                synchronized (object) {
                    TmfTimeRange timeRange = TmfStateSystemAnalysisModule.this.fTimeRange;
                    if (timeRange != null && this.getRange().getEndTime().getValue() < timeRange.getEndTime().getValue()) {
                        TmfStateSystemAnalysisModule.this.startRequest();
                    }
                }
            }
        }

        @Override
        public void handleCancel() {
            super.handleCancel();
            TmfStateSystemAnalysisModule.this.disposeProvider(true);
        }

        @Override
        public void handleFailure() {
            super.handleFailure();
            TmfStateSystemAnalysisModule.this.disposeProvider(true);
        }
    }
}

