/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;

public class StateItem {
    public static final String UNDEFINED_STATE_NAME = "Undefined";
    private static final int UNDEFINED_COLOR_VALUE = 255;
    private final Map<String, Object> fStyleMap;
    private final Map<String, Object> fReadOnlyStyleMap;

    public StateItem(RGB stateColor) {
        this(stateColor, UNDEFINED_STATE_NAME);
    }

    public StateItem(RGB stateColor, String stateString) {
        int stateColorInt = stateColor.red << 24 | stateColor.green << 16 | stateColor.blue << 8 | 0xFF;
        this.fStyleMap = new HashMap<String, Object>();
        this.fReadOnlyStyleMap = Collections.unmodifiableMap(this.fStyleMap);
        this.fStyleMap.put(ITimeEventStyleStrings.fillStyle(), ITimeEventStyleStrings.solidColorFillStyle());
        this.fStyleMap.put(ITimeEventStyleStrings.fillColor(), stateColorInt);
        this.fStyleMap.put(ITimeEventStyleStrings.label(), stateString);
    }

    public RGB getStateColor() {
        int rgbInt = (Integer)this.fStyleMap.getOrDefault(ITimeEventStyleStrings.fillColor(), 255);
        return new RGB(rgbInt >> 24 & 0xFF, rgbInt >> 16 & 0xFF, rgbInt >> 8 & 0xFF);
    }

    public void setStateColor(RGB stateColor) {
        this.fStyleMap.put(ITimeEventStyleStrings.fillColor(), stateColor);
    }

    public String getStateString() {
        return String.valueOf(this.fStyleMap.getOrDefault(ITimeEventStyleStrings.label(), UNDEFINED_STATE_NAME));
    }

    public void setStateString(String stateString) {
        this.fStyleMap.put(ITimeEventStyleStrings.label(), stateString);
    }

    public Map<String, Object> getStyleMap() {
        return this.fReadOnlyStyleMap;
    }
}

