/**
 * Copyright (c) 2010-2015, Denes Harmath, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Denes Harmath - initial API and implementation
 */
package org.eclipse.viatra.query.patternlanguage.emf.jvmmodel;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.EMFPatternLanguageJvmModelInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.specification.XBaseEvaluator;
import org.eclipse.viatra.query.patternlanguage.emf.specification.internal.PatternBodyTransformer;
import org.eclipse.viatra.query.patternlanguage.emf.specification.internal.PatternModelAcceptor;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Constraint;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Variable;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.output.ImportingStringConcatenation;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;

/**
 * {@link PatternModelAcceptor} implementation that generates body code for {@link IQuerySpecification} classes.
 * Implementation note: it extends {@link StringConcatenationClient} so that it can be used with {@link ImportingStringConcatenation}.
 * @since 1.1
 * @noreference
 */
@SuppressWarnings("all")
public class BodyCodeGenerator extends StringConcatenationClient {
  private final Pattern pattern;
  
  private final PatternBody body;
  
  @Extension
  private final EMFPatternLanguageJvmModelInferrerUtil util;
  
  private final IErrorFeedback feedback;
  
  private final Serializer serializer;
  
  private final JvmTypeReferenceBuilder typeReferences;
  
  private final static String INDENTATION = new Function0<String>() {
    public String apply() {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("    ");
      return _builder.toString();
    }
  }.apply();
  
  public BodyCodeGenerator(final Pattern pattern, final PatternBody body, final EMFPatternLanguageJvmModelInferrerUtil util, final IErrorFeedback feedback, final Serializer serializer, final JvmTypeReferenceBuilder typeReferences) {
    this.pattern = pattern;
    this.body = body;
    this.util = util;
    this.feedback = feedback;
    this.serializer = serializer;
    this.typeReferences = typeReferences;
  }
  
  @Override
  protected void appendTo(final StringConcatenationClient.TargetStringConcatenation target) {
    abstract class __BodyCodeGenerator_1 implements PatternModelAcceptor<Void> {
      int lastId;
      
      abstract StringConcatenationClient outputConstant(final Object constant);
      
      abstract String output(final List<String> variableNames);
      
      abstract void referPQuery(final Pattern calledPattern, final Pattern callerPattern, final StringConcatenationClient.TargetStringConcatenation target);
      
      abstract JvmTypeReference eraseGenerics(final JvmTypeReference reference);
    }
    
    try {
      final __BodyCodeGenerator_1 acceptor = new __BodyCodeGenerator_1() {
        {
          lastId = 0;
        }
        @Override
        public Void getResult() {
          return null;
        }
        
        @Override
        public String acceptVariable(final Variable variable) {
          String _xblockexpression = null;
          {
            String _name = variable.getName();
            BodyCodeGenerator.declareVariable(_name, target);
            _xblockexpression = variable.getName();
          }
          return _xblockexpression;
        }
        
        @Override
        public String createVirtualVariable() {
          String _xblockexpression = null;
          {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(".virtual{");
            _builder.append(this.lastId, "");
            _builder.append("}");
            final String virtualVariableName = _builder.toString();
            this.lastId++;
            BodyCodeGenerator.declareVariable(virtualVariableName, target);
            _xblockexpression = virtualVariableName;
          }
          return _xblockexpression;
        }
        
        @Override
        public String createConstantVariable(final Object value) {
          String _xblockexpression = null;
          {
            final String virtualVariable = this.createVirtualVariable();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("new ");
            target.append(_builder);
            target.append(ConstantValue.class);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("(body, ");
            String _escape = BodyCodeGenerator.escape(virtualVariable);
            _builder_1.append(_escape, "");
            _builder_1.append(", ");
            StringConcatenationClient _outputConstant = this.outputConstant(value);
            _builder_1.append(_outputConstant, "");
            _builder_1.append(");");
            _builder_1.newLineIfNotEmpty();
            target.append(_builder_1);
            _xblockexpression = virtualVariable;
          }
          return _xblockexpression;
        }
        
        StringConcatenationClient outputConstant(final Object constant) {
          StringConcatenationClient _switchResult = null;
          boolean _matched = false;
          if (!_matched) {
            if (constant instanceof EEnumLiteral) {
              _matched=true;
              StringConcatenationClient _xblockexpression = null;
              {
                final EEnum enumeration = ((EEnumLiteral)constant).getEEnum();
                final EPackage ePackage = enumeration.getEPackage();
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append("getEnumLiteral(\"");
                    String _nsURI = ePackage.getNsURI();
                    _builder.append(_nsURI, "");
                    _builder.append("\", \"");
                    String _name = enumeration.getName();
                    _builder.append(_name, "");
                    _builder.append("\", \"");
                    String _name_1 = ((EEnumLiteral)constant).getName();
                    _builder.append(_name_1, "");
                    _builder.append("\").getInstance()");
                  }
                };
                _xblockexpression = _client;
              }
              _switchResult = _xblockexpression;
            }
          }
          if (!_matched) {
            if (constant instanceof Enumerator) {
              _matched=true;
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  Class<? extends Enumerator> _class = ((Enumerator)constant).getClass();
                  String _canonicalName = _class.getCanonicalName();
                  _builder.append(_canonicalName, "");
                  _builder.append(".get(\"");
                  String _literal = ((Enumerator)constant).getLiteral();
                  _builder.append(_literal, "");
                  _builder.append("\")");
                }
              };
              _switchResult = _client;
            }
          }
          if (!_matched) {
            if (constant instanceof String) {
              _matched=true;
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("\"");
                  _builder.append(((String)constant), "");
                  _builder.append("\"");
                }
              };
              _switchResult = _client;
            }
          }
          if (!_matched) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(constant, "");
              }
            };
            _switchResult = _client;
          }
          return _switchResult;
        }
        
        @Override
        public void acceptExportedParameters(final List<Variable> parameters) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("body.setSymbolicParameters(");
          target.append(_builder);
          target.append(Arrays.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append(".<");
          target.append(_builder_1);
          target.append(ExportedParameter.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append(">asList(");
          _builder_2.newLine();
          target.append(_builder_2);
          final Procedure2<Variable, Integer> _function = new Procedure2<Variable, Integer>() {
            @Override
            public void apply(final Variable parameter, final Integer index) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("   ");
              _builder.append("new ");
              target.append(_builder);
              target.append(ExportedParameter.class);
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append("(body, ");
              String _name = parameter.getName();
              String _escape = BodyCodeGenerator.escape(_name);
              _builder_1.append(_escape, "");
              _builder_1.append(", ");
              String _pParameterName = BodyCodeGenerator.this.util.getPParameterName(parameter);
              _builder_1.append(_pParameterName, "");
              _builder_1.append(")");
              target.append(_builder_1);
              int _length = ((Object[])Conversions.unwrapArray(parameters, Object.class)).length;
              int _minus = (_length - 1);
              boolean _lessThan = ((index).intValue() < _minus);
              if (_lessThan) {
                target.append(",");
              }
              target.append("\n");
            }
          };
          IterableExtensions.<Variable>forEach(parameters, _function);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("));");
          _builder_3.newLine();
          target.append(_builder_3);
        }
        
        @Override
        public void acceptConstraint(final Constraint constraint) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("// ");
          String _serialize = BodyCodeGenerator.this.serializer.serialize(constraint);
          String _replaceAll = _serialize.replaceAll("\r\n?|\n", "");
          _builder.append(_replaceAll, "");
          _builder.newLineIfNotEmpty();
          target.append(_builder);
        }
        
        @Override
        public void acceptTypeConstraint(final List<String> variableNames, final IInputKey key) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(TypeConstraint.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          target.append(_builder_1);
          target.append(FlatTuple.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(");
          String _output = this.output(variableNames);
          _builder_2.append(_output, "");
          _builder_2.append("), ");
          target.append(_builder_2);
          BodyCodeGenerator.this.util.appendInputKey(target, key, false);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append(");");
          _builder_3.newLine();
          target.append(_builder_3);
        }
        
        @Override
        public void acceptTypeCheckConstraint(final List<String> variableNames, final IInputKey key) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(TypeFilterConstraint.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          target.append(_builder_1);
          target.append(FlatTuple.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(");
          String _output = this.output(variableNames);
          _builder_2.append(_output, "");
          _builder_2.append("), ");
          target.append(_builder_2);
          BodyCodeGenerator.this.util.appendInputKey(target, key, false);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append(");");
          _builder_3.newLine();
          target.append(_builder_3);
        }
        
        String output(final List<String> variableNames) {
          Joiner _on = Joiner.on(", ");
          final Function1<String, String> _function = new Function1<String, String>() {
            @Override
            public String apply(final String it) {
              return BodyCodeGenerator.escape(it);
            }
          };
          List<String> _map = ListExtensions.<String, String>map(variableNames, _function);
          return _on.join(_map);
        }
        
        @Override
        public void acceptPositivePatternCall(final List<String> argumentVariableNames, final Pattern calledPattern) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(PositivePatternCall.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          target.append(_builder_1);
          target.append(FlatTuple.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(");
          String _output = this.output(argumentVariableNames);
          _builder_2.append(_output, "");
          _builder_2.append("), ");
          target.append(_builder_2);
          this.referPQuery(calledPattern, BodyCodeGenerator.this.pattern, target);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append(");");
          _builder_3.newLine();
          target.append(_builder_3);
        }
        
        void referPQuery(final Pattern calledPattern, final Pattern callerPattern, final StringConcatenationClient.TargetStringConcatenation target) {
          boolean _equals = Objects.equal(calledPattern, callerPattern);
          if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("this");
            target.append(_builder);
          } else {
            JvmType _findInferredSpecification = BodyCodeGenerator.this.util.findInferredSpecification(calledPattern);
            target.append(_findInferredSpecification);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".instance().getInternalQueryRepresentation()");
            target.append(_builder_1);
          }
        }
        
        @Override
        public void acceptNegativePatternCall(final List<String> argumentVariableNames, final Pattern calledPattern) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(NegativePatternCall.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          target.append(_builder_1);
          target.append(FlatTuple.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(");
          String _output = this.output(argumentVariableNames);
          _builder_2.append(_output, "");
          _builder_2.append("), ");
          target.append(_builder_2);
          this.referPQuery(calledPattern, BodyCodeGenerator.this.pattern, target);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append(");");
          _builder_3.newLine();
          target.append(_builder_3);
        }
        
        @Override
        public void acceptBinaryTransitiveClosure(final List<String> argumentVariableNames, final Pattern calledPattern) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(BinaryTransitiveClosure.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          target.append(_builder_1);
          target.append(FlatTuple.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(");
          String _output = this.output(argumentVariableNames);
          _builder_2.append(_output, "");
          _builder_2.append("), ");
          target.append(_builder_2);
          this.referPQuery(calledPattern, BodyCodeGenerator.this.pattern, target);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append(");");
          _builder_3.newLine();
          target.append(_builder_3);
        }
        
        @Override
        public void acceptEquality(final String leftOperandVariableName, final String rightOperandVariableName) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(Equality.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, ");
          String _escape = BodyCodeGenerator.escape(leftOperandVariableName);
          _builder_1.append(_escape, "");
          _builder_1.append(", ");
          String _escape_1 = BodyCodeGenerator.escape(rightOperandVariableName);
          _builder_1.append(_escape_1, "");
          _builder_1.append(");");
          _builder_1.newLineIfNotEmpty();
          target.append(_builder_1);
        }
        
        @Override
        public void acceptInequality(final String leftOperandVariableName, final String rightOperandVariableName) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(Inequality.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, ");
          String _escape = BodyCodeGenerator.escape(leftOperandVariableName);
          _builder_1.append(_escape, "");
          _builder_1.append(", ");
          String _escape_1 = BodyCodeGenerator.escape(rightOperandVariableName);
          _builder_1.append(_escape_1, "");
          _builder_1.append(");");
          _builder_1.newLineIfNotEmpty();
          target.append(_builder_1);
        }
        
        @Override
        public void acceptExpressionEvaluation(final XExpression expression, final String outputVariableName) {
          try {
            final XBaseEvaluator xBaseEvaluator = new XBaseEvaluator(expression, BodyCodeGenerator.this.pattern);
            StringConcatenation _builder = new StringConcatenation();
            Iterable<String> _inputParameterNames = xBaseEvaluator.getInputParameterNames();
            boolean _isEmpty = IterableExtensions.isEmpty(_inputParameterNames);
            if (_isEmpty) {
              XExpression _expression = xBaseEvaluator.getExpression();
              BodyCodeGenerator.this.feedback.reportError(_expression, "No parameters defined", EMFPatternLanguageJvmModelInferrer.SPECIFICATION_BUILDER_CODE, Severity.WARNING, IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
            }
            _builder.newLineIfNotEmpty();
            _builder.append("new ");
            target.append(_builder);
            target.append(ExpressionEvaluation.class);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("(body, new ");
            target.append(_builder_1);
            target.append(IExpressionEvaluator.class);
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("() {");
            target.append(_builder_2);
            target.newLine();
            target.newLine();
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(BodyCodeGenerator.INDENTATION, "");
            _builder_3.append("@Override");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("public String getShortDescription() {");
            _builder_3.newLine();
            _builder_3.append("    ");
            _builder_3.append("return \"Expression evaluation from pattern ");
            String _name = BodyCodeGenerator.this.pattern.getName();
            _builder_3.append(_name, "    ");
            _builder_3.append("\";");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("}");
            _builder_3.newLine();
            _builder_3.newLine();
            _builder_3.append("@Override");
            _builder_3.newLine();
            _builder_3.append("public Iterable<String> getInputParameterNames() {");
            _builder_3.newLine();
            _builder_3.append("    ");
            _builder_3.append("return ");
            target.append(_builder_3, BodyCodeGenerator.INDENTATION);
            target.append(Arrays.class);
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append(".asList(");
            {
              Iterable<String> _inputParameterNames_1 = xBaseEvaluator.getInputParameterNames();
              boolean _hasElements = false;
              for(final String name : _inputParameterNames_1) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder_4.appendImmediate(", ", "");
                }
                _builder_4.append("\"");
                _builder_4.append(name, "");
                _builder_4.append("\"");
              }
            }
            _builder_4.append(");");
            target.append(_builder_4);
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("}");
            target.append(_builder_5, BodyCodeGenerator.INDENTATION);
            target.newLine();
            target.newLine();
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append(BodyCodeGenerator.INDENTATION, "");
            _builder_6.append("@Override");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("public Object evaluateExpression(");
            target.append(_builder_6, BodyCodeGenerator.INDENTATION);
            target.append(IValueProvider.class);
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append(" ");
            _builder_7.append("provider) throws Exception {");
            target.append(_builder_7);
            target.newLine();
            XExpression _expression_1 = xBaseEvaluator.getExpression();
            final List<Variable> variables = BodyCodeGenerator.this.util.variables(_expression_1);
            for (final Variable variable : variables) {
              {
                JvmTypeReference _calculateType = BodyCodeGenerator.this.util.calculateType(variable);
                final JvmTypeReference type = this.eraseGenerics(_calculateType);
                target.append(BodyCodeGenerator.INDENTATION);
                target.append(BodyCodeGenerator.INDENTATION);
                target.append(type);
                StringConcatenation _builder_8 = new StringConcatenation();
                _builder_8.append(" ");
                String _name_1 = variable.getName();
                _builder_8.append(_name_1, " ");
                _builder_8.append(" = (");
                target.append(_builder_8);
                target.append(type);
                StringConcatenation _builder_9 = new StringConcatenation();
                _builder_9.append(") provider.getValue(\"");
                String _name_2 = variable.getName();
                _builder_9.append(_name_2, "");
                _builder_9.append("\");");
                target.append(_builder_9);
                target.newLine();
              }
            }
            target.append(BodyCodeGenerator.INDENTATION);
            target.append(BodyCodeGenerator.INDENTATION);
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append("return ");
            XExpression _expression_2 = xBaseEvaluator.getExpression();
            String _expressionMethodName = BodyCodeGenerator.this.util.expressionMethodName(_expression_2);
            _builder_8.append(_expressionMethodName, "");
            _builder_8.append("(");
            {
              boolean _hasElements_1 = false;
              for(final Variable variable_1 : variables) {
                if (!_hasElements_1) {
                  _hasElements_1 = true;
                } else {
                  _builder_8.appendImmediate(", ", "");
                }
                String _name_1 = variable_1.getName();
                _builder_8.append(_name_1, "");
              }
            }
            _builder_8.append(");");
            target.append(_builder_8);
            target.newLine();
            target.append(BodyCodeGenerator.INDENTATION);
            target.append("}");
            target.newLine();
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append("}, ");
            {
              boolean _notEquals = (!Objects.equal(outputVariableName, null));
              if (_notEquals) {
                _builder_9.append(" ");
                String _escape = BodyCodeGenerator.escape(outputVariableName);
                _builder_9.append(_escape, "");
                _builder_9.append(" ");
              } else {
                _builder_9.append(" null");
              }
            }
            _builder_9.append("); ");
            target.append(_builder_9);
            target.newLine();
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
        
        JvmTypeReference eraseGenerics(final JvmTypeReference reference) {
          JvmTypeReference _xifexpression = null;
          if ((reference instanceof JvmParameterizedTypeReference)) {
            JvmType _type = ((JvmParameterizedTypeReference)reference).getType();
            EList<JvmTypeReference> _arguments = ((JvmParameterizedTypeReference)reference).getArguments();
            final Function1<JvmTypeReference, JvmTypeReference> _function = new Function1<JvmTypeReference, JvmTypeReference>() {
              @Override
              public JvmTypeReference apply(final JvmTypeReference it) {
                return BodyCodeGenerator.this.typeReferences.wildcard();
              }
            };
            List<JvmTypeReference> _map = ListExtensions.<JvmTypeReference, JvmTypeReference>map(_arguments, _function);
            _xifexpression = BodyCodeGenerator.this.typeReferences.typeRef(_type, ((JvmTypeReference[])Conversions.unwrapArray(_map, JvmTypeReference.class)));
          } else {
            _xifexpression = reference;
          }
          return _xifexpression;
        }
        
        @Override
        public void acceptPatternMatchCounter(final List<String> argumentVariableNames, final Pattern calledPattern, final String resultVariableName) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(PatternMatchCounter.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          target.append(_builder_1);
          target.append(FlatTuple.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(");
          String _output = this.output(argumentVariableNames);
          _builder_2.append(_output, "");
          _builder_2.append("), ");
          target.append(_builder_2);
          this.referPQuery(calledPattern, BodyCodeGenerator.this.pattern, target);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append(", ");
          String _escape = BodyCodeGenerator.escape(resultVariableName);
          _builder_3.append(_escape, "");
          _builder_3.append(");");
          _builder_3.newLineIfNotEmpty();
          target.append(_builder_3);
        }
        
        @Override
        public void acceptAggregator(final JvmType aggregatorFactoryType, final JvmType aggregatorParameterType, final List<String> argumentVariableNames, final Pattern calledPattern, final String resultVariableName, final int aggregatedColumn) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(AggregatorConstraint.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(");
          target.append(_builder_1);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("new ");
          target.append(_builder_2);
          target.append(aggregatorFactoryType);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("().getAggregatorLogic(");
          target.append(_builder_3);
          boolean _equals = Objects.equal(aggregatorParameterType, null);
          if (_equals) {
            target.append(Void.class);
          } else {
            target.append(aggregatorParameterType);
          }
          StringConcatenation _builder_4 = new StringConcatenation();
          _builder_4.append(".class), body, new ");
          target.append(_builder_4);
          target.append(FlatTuple.class);
          StringConcatenation _builder_5 = new StringConcatenation();
          _builder_5.append("(");
          String _output = this.output(argumentVariableNames);
          _builder_5.append(_output, "");
          _builder_5.append("), ");
          target.append(_builder_5);
          this.referPQuery(calledPattern, BodyCodeGenerator.this.pattern, target);
          StringConcatenation _builder_6 = new StringConcatenation();
          _builder_6.append(", ");
          String _escape = BodyCodeGenerator.escape(resultVariableName);
          _builder_6.append(_escape, "");
          _builder_6.append(", ");
          _builder_6.append(aggregatedColumn, "");
          _builder_6.append(");");
          _builder_6.newLineIfNotEmpty();
          target.append(_builder_6);
        }
      };
      PatternBodyTransformer _patternBodyTransformer = new PatternBodyTransformer(this.pattern);
      _patternBodyTransformer.<Void>transform(this.body, acceptor);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * Generates a {@link PVariable} declaration with the given name.
   */
  private static void declareVariable(final String variableName, final StringConcatenationClient.TargetStringConcatenation target) {
    target.append(PVariable.class);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    String _escape = BodyCodeGenerator.escape(variableName);
    _builder.append(_escape, " ");
    _builder.append(" = body.getOrCreateVariableByName(\"");
    _builder.append(variableName, " ");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    target.append(_builder);
  }
  
  private static String escape(final String name) {
    String _replaceAll = name.replaceAll("[\\.\\{\\}<>#]", "_");
    return ("var_" + _replaceAll);
  }
}
