/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.editor.color;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorsComposite;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorsGridComposite;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfo;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorsGridComposite;
import org.eclipse.wb.internal.core.xml.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.xwt.model.property.editor.color.ColorSupport;

public final class ColorPropertyEditor
extends PropertyEditor
implements IClipboardSourceProvider {
    public static final PropertyEditor INSTANCE = new ColorPropertyEditor();
    private static final int SAMPLE_SIZE = 10;
    private static final int SAMPLE_MARGIN = 3;
    private final PropertyEditorPresentation m_presentation = new ButtonPropertyEditorPresentation(){

        protected void onClick(PropertyTable propertyTable, Property property) throws Exception {
            ColorPropertyEditor.this.openDialog(property);
        }
    };
    private static final ColorDialog m_colorDialog = new ColorDialog();

    private ColorPropertyEditor() {
    }

    public PropertyEditorPresentation getPresentation() {
        return this.m_presentation;
    }

    public void paint(Property property, GC gc, int x, int y, int width, int height) throws Exception {
        Object value = property.getValue();
        if (value instanceof Color) {
            Color color = (Color)value;
            Color oldBackground = gc.getBackground();
            Color oldForeground = gc.getForeground();
            try {
                int width_c = 10;
                int height_c = 10;
                int x_c = x;
                int y_c = y + (height - height_c) / 2;
                int delta = 13;
                x += delta;
                width -= delta;
                gc.setBackground(color);
                gc.fillRectangle(x_c, y_c, width_c, height_c);
                gc.setForeground(IColorConstants.gray);
                gc.drawRectangle(x_c, y_c, width_c, height_c);
            }
            finally {
                gc.setBackground(oldBackground);
                gc.setForeground(oldForeground);
            }
            String text = this.getText(property);
            if (text != null) {
                DrawUtils.drawStringCV((GC)gc, (String)text, (int)x, (int)y, (int)width, (int)height);
            }
        }
    }

    private String getText(Property property) throws Exception {
        if (property instanceof GenericProperty && property.isModified()) {
            return ((GenericProperty)property).getExpression();
        }
        Object value = property.getValue();
        if (value instanceof Color) {
            Color color = (Color)value;
            return ColorSupport.toString(color);
        }
        return null;
    }

    public String getClipboardSource(GenericProperty property) throws Exception {
        return this.getText((Property)property);
    }

    public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
        if (location == null) {
            this.openDialog(property);
        }
        return false;
    }

    private void openDialog(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        Object value = property.getValue();
        if (value instanceof Color) {
            Color color = (Color)value;
            m_colorDialog.setColorInfo(ColorSupport.createInfo(color));
        }
        if (m_colorDialog.open() == 0) {
            ColorInfo colorInfo = m_colorDialog.getColorInfo();
            String expression = (String)colorInfo.getData();
            genericProperty.setExpression(expression, Property.UNKNOWN_VALUE);
        }
    }

    private static final class ColorDialog
    extends AbstractColorDialog {
        private static String m_lastPageTitle;

        public ColorDialog() {
            super(DesignerPlugin.getShell());
        }

        protected void addPages(Composite parent) {
            this.addPage("System colors", (AbstractColorsComposite)new SystemColorsPage(parent, 0, this));
            this.addPage("Named colors", (AbstractColorsComposite)new NamedColorsPage(parent, 0, this));
            this.selectPageByTitle(m_lastPageTitle);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                m_lastPageTitle = this.getSelectedPageTitle();
            }
            super.buttonPressed(buttonId);
        }
    }

    private static final class NamedColorsPage
    extends AbstractColorsGridComposite {
        public NamedColorsPage(Composite parent, int style, AbstractColorDialog colorDialog) {
            super(parent, style, colorDialog);
            ColorsGridComposite colorsGrid = this.createColorsGroup((Composite)this, null, ColorSupport.getNamedColors());
            colorsGrid.showNames(50);
            colorsGrid.setCellHeight(25);
            colorsGrid.setColumns(6);
            colorsGrid.setMaxNameWidth(100);
        }
    }

    private static final class SystemColorsPage
    extends AbstractColorsGridComposite {
        public SystemColorsPage(Composite parent, int style, AbstractColorDialog colorDialog) {
            super(parent, style, colorDialog);
            ColorsGridComposite colorsGrid = this.createColorsGroup((Composite)this, null, ColorSupport.getSystemColors());
            colorsGrid.showNames(50);
            colorsGrid.setCellHeight(25);
            colorsGrid.setColumns(2);
        }
    }
}

