/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client.impl.ser;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwtjsonrpc.client.impl.JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;
import com.google.gwtjsonrpc.client.impl.ser.PrimitiveResultDeserializers;
import java.sql.Timestamp;
import java.util.Date;

public final class JavaSqlTimestamp_JsonSerializer
extends JsonSerializer<Timestamp>
implements ResultDeserializer<Timestamp> {
    public static final JavaSqlTimestamp_JsonSerializer INSTANCE = new JavaSqlTimestamp_JsonSerializer();

    @Override
    public Timestamp fromJson(Object o) {
        if (o != null) {
            return JavaSqlTimestamp_JsonSerializer.parseTimestamp((String)o);
        }
        return null;
    }

    @Override
    public void printJson(StringBuilder sb, Timestamp o) {
        sb.append('\"');
        sb.append(JavaSqlTimestamp_JsonSerializer.toString(o.getTime()));
        sb.append('\"');
    }

    protected static String padTwo(int v) {
        if (v < 10) {
            return "0" + v;
        }
        return String.valueOf(v);
    }

    protected static String padThree(int v) {
        if (v < 10) {
            return "00" + v;
        }
        if (v < 100) {
            return "0" + v;
        }
        return String.valueOf(v);
    }

    private static native String toString(double var0);

    public static Timestamp parseTimestamp(String s) {
        String[] components = s.split(" ");
        if (components.length != 2) {
            throw new IllegalArgumentException("Invalid escape format: " + s);
        }
        String[] timeComponents = components[1].split("\\.");
        if (timeComponents.length != 2) {
            throw new IllegalArgumentException("Invalid escape format: " + s);
        }
        if (timeComponents[1].length() != 9) {
            throw new IllegalArgumentException("Invalid escape format: " + s);
        }
        String[] dSplit = components[0].split("-");
        String[] tSplit = timeComponents[0].split(":");
        if (dSplit.length != 3 || tSplit.length != 3) {
            throw new IllegalArgumentException("Invalid escape format: " + s);
        }
        JavaSqlTimestamp_JsonSerializer.trimLeading0(dSplit);
        JavaSqlTimestamp_JsonSerializer.trimLeading0(tSplit);
        if (timeComponents[1].startsWith("0")) {
            timeComponents[1] = timeComponents[1].replaceFirst("^00*", "");
            if (timeComponents[1].length() == 0) {
                timeComponents[1] = "0";
            }
        }
        try {
            int yy = Integer.parseInt(dSplit[0]) - 1900;
            int mm = Integer.parseInt(dSplit[1]) - 1;
            int dd = Integer.parseInt(dSplit[2]);
            int hh = Integer.parseInt(tSplit[0]);
            int mi = Integer.parseInt(tSplit[1]);
            int ss = Integer.parseInt(tSplit[2]);
            int ms = Integer.valueOf(timeComponents[1]) / 1000000;
            return new Timestamp(Date.UTC(yy, mm, dd, hh, mi, ss) + (long)ms);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid escape format: " + s);
        }
    }

    private static void trimLeading0(String[] dSplit) {
        for (int i = 0; i < 3; ++i) {
            if (!dSplit[i].startsWith("0")) continue;
            dSplit[i] = dSplit[i].substring(1);
        }
    }

    @Override
    public Timestamp fromResult(JavaScriptObject responseObject) {
        return this.fromJson(PrimitiveResultDeserializers.stringResult(responseObject));
    }
}

