/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingutils.ImmutableCollection;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.ProgressListener;

public final class TransientRequestAttributes {
    private final boolean colorOutput;
    private final OutputStream standardOutput;
    private final OutputStream standardError;
    private final InputStream standardInput;
    private final ImmutableList<ProgressListener> progressListeners;
    private final ImmutableList<org.gradle.tooling.events.ProgressListener> typedProgressListeners;
    private final CancellationToken cancellationToken;

    public TransientRequestAttributes(boolean colorOutput, OutputStream standardOutput, OutputStream standardError, InputStream standardInput, List<ProgressListener> progressListeners, List<org.gradle.tooling.events.ProgressListener> typedProgressListeners, CancellationToken cancellationToken) {
        this.colorOutput = colorOutput;
        this.standardOutput = standardOutput;
        this.standardError = standardError;
        this.standardInput = standardInput;
        this.progressListeners = ImmutableList.copyOf(progressListeners);
        this.typedProgressListeners = ImmutableList.copyOf(typedProgressListeners);
        this.cancellationToken = (CancellationToken)Preconditions.checkNotNull((Object)cancellationToken);
    }

    public boolean isColorOutput() {
        return this.colorOutput;
    }

    @Nullable
    public OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    @Nullable
    public OutputStream getStandardError() {
        return this.standardError;
    }

    @Nullable
    public InputStream getStandardInput() {
        return this.standardInput;
    }

    @ImmutableCollection
    public List<ProgressListener> getProgressListeners() {
        return this.progressListeners;
    }

    @ImmutableCollection
    public List<org.gradle.tooling.events.ProgressListener> getTypedProgressListeners() {
        return this.typedProgressListeners;
    }

    public CancellationToken getCancellationToken() {
        return this.cancellationToken;
    }

    public void apply(Request<?> request) {
        request.colorOutput(this.colorOutput);
        request.standardOutput(this.standardOutput);
        request.standardError(this.standardError);
        request.standardInput(this.standardInput);
        request.progressListeners((ProgressListener[])this.progressListeners.toArray((Object[])new ProgressListener[this.progressListeners.size()]));
        request.typedProgressListeners((org.gradle.tooling.events.ProgressListener[])this.typedProgressListeners.toArray((Object[])new org.gradle.tooling.events.ProgressListener[this.typedProgressListeners.size()]));
        request.cancellationToken(this.cancellationToken);
    }
}

