/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.actf.util.resources.DefaultResourceLocator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class EclipseResourceLocator
extends DefaultResourceLocator {
    private List _bundles = new LinkedList();
    private File metadataDir;
    private Logger logger = Logger.getLogger("org.eclipse.actf.core");

    public void registerBundleName(String string) {
        this._bundles.add(string);
    }

    public InputStream getResourceAsStream(String string, ClassLoader classLoader) {
        return this.getResourceAsStream(string, null, null, classLoader);
    }

    public InputStream getResourceAsStream(String string, String string2, String string3, ClassLoader classLoader) {
        return classLoader != null ? super.getResourceAsStream(string, string2, string3, classLoader) : this.getResourceAsStream(string, string2, string3);
    }

    private InputStream getResourceAsStream(String string, String string2, String string3) {
        InputStream inputStream = null;
        ListIterator listIterator = this._bundles.listIterator();
        while (listIterator.hasNext() & inputStream == null) {
            String string4 = (String)listIterator.next();
            inputStream = this.getResourceAsStream(string, string2, string3, string4);
        }
        return inputStream;
    }

    public InputStream getResourceAsStream(String string, String string2, String string3, String string4) {
        FileInputStream fileInputStream = null;
        String string5 = this.getRelativePath(string2, string, string3);
        IPath iPath = null;
        if (string4 != null) {
            iPath = this.getPathToFile(string4, string5);
        }
        if (iPath != null) {
            try {
                fileInputStream = new FileInputStream(iPath.toFile());
                this.logger.log(Level.FINE, "Created stream for file - " + string5 + " using bundle " + string4);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            this.logger.log(Level.FINE, "unable to create stream for file - " + string5 + " using bundle " + string4);
        }
        return fileInputStream;
    }

    private String getRelativePath(String string, String string2, String string3) {
        String string4 = null;
        if (string == null) {
            string = "resources";
        }
        string4 = string3 != null ? String.valueOf(string) + File.separator + string2 + "." + string3 : String.valueOf(string) + File.separator + string2 + ".properties";
        return string4;
    }

    public URL getResource(String string) {
        Object object;
        File file;
        URL uRL = super.getResource(string);
        if (uRL == null) {
            file = null;
            object = this._bundles.listIterator();
            while (object.hasNext() & file == null) {
                String string2 = (String)object.next();
                file = string2.equals(string) ? this.getPathToBundle(string) : this.getPathToFile(string2, string);
            }
            if (file == null) {
                file = this.getPathToBundle(string);
            }
            if (file != null) {
                try {
                    uRL = file.toFile().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        if (uRL == null) {
            file = new File(string);
            if (string.endsWith(".xml")) {
                this.metadataDir = file.getParentFile();
            } else {
                object = this.metadataDir.getAbsolutePath();
                file = new File(String.valueOf(object) + "/" + string);
            }
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        return uRL;
    }

    public String getPath(String string) {
        String string2 = null;
        URL uRL = this.getResource(string);
        string2 = this.convertToFileURL(uRL);
        return string2;
    }

    public String[] getPaths(String string) {
        String[] stringArray = null;
        URL[] uRLArray = this.getResources(string);
        if (uRLArray != null) {
            stringArray = new String[uRLArray.length];
            int n = 0;
            while (n < uRLArray.length) {
                stringArray[n] = this.convertToFileURL(uRLArray[n]);
                ++n;
            }
        }
        return stringArray;
    }

    private String convertToFileURL(URL uRL) {
        String string = null;
        if (uRL != null) {
            try {
                URL uRL2 = FileLocator.toFileURL((URL)uRL);
                string = uRL2.getFile().substring(1);
            }
            catch (IOException iOException) {
                string = null;
            }
        }
        return string;
    }

    public IPath getPathToFile(String string, String string2) {
        Bundle bundle;
        Path path = null;
        if (string != null && string.length() > 0 && (bundle = Platform.getBundle((String)string)) != null) {
            Path path2 = new Path(string2);
            URL uRL = Platform.find((Bundle)bundle, (IPath)path2);
            if (uRL == null) {
                path2 = new Path("resources/" + string2);
                uRL = Platform.find((Bundle)bundle, (IPath)path2);
            }
            if (uRL != null) {
                try {
                    uRL = Platform.resolve((URL)uRL);
                    path = new Path(new File(uRL.getFile()).getAbsolutePath());
                    this.logger.log(Level.FINE, "getPathToFile(), absolute path to " + string2 + " = " + path.toString());
                }
                catch (IOException iOException) {
                    this.logger.log(Level.WARNING, iOException.getMessage(), iOException);
                }
            }
        }
        return path;
    }

    public IPath getPathToBundle(String string) {
        Bundle bundle;
        Path path = null;
        if (string != null && string.length() > 0 && (bundle = Platform.getBundle((String)string)) != null) {
            try {
                String string2 = FileLocator.resolve((URL)bundle.getEntry("/")).getFile();
                if (string2.startsWith("file:")) {
                    string2 = string2.substring("file:".length());
                }
                if (string2.startsWith("/") && Platform.getOS().equals("win32")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith("jar!/")) {
                    path = new Path(string2.substring(0, string2.length() - 2));
                } else if (string2.endsWith("/")) {
                    path = new Path(string2.substring(0, string2.length() - 1));
                }
                this.logger.log(Level.FINE, "getPathToBundle(), path to bundle " + string + " = " + path.toString());
            }
            catch (IOException iOException) {
                this.logger.log(Level.WARNING, "Could not retrieve location for a bundle", iOException);
            }
        }
        return path;
    }
}

