/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Coord;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LabeledImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Neighbor;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;

public class ConnectedComponent {
    public static final short CONNECTIVITY_UNSET = 0;
    public static final short CONNECTIVITY_4 = 1;
    public static final short CONNECTIVITY_8 = 2;
    public static final short THINNING_HILDITCH = 10;
    public static final short THINNING_DEFAULT = 10;
    int left;
    int top;
    BinaryImage shape;
    private int count;
    short connectivity = 0;

    public ConnectedComponent(int n, int n2, int n3, int n4, int n5) {
        this.left = n;
        this.top = n2;
        this.count = n5;
        this.shape = new BinaryImage(n3, n4);
    }

    public ConnectedComponent(int n, int n2, BinaryImage binaryImage, short s) {
        this.left = n;
        this.top = n2;
        this.shape = binaryImage;
        this.connectivity = s;
        if (binaryImage.getArea() == -1) {
            binaryImage.measureArea();
        }
        this.count = binaryImage.getArea();
    }

    public ConnectedComponent deepCopy() {
        ConnectedComponent connectedComponent = new ConnectedComponent(this.left, this.top, this.shape.width, this.shape.height, this.count);
        connectedComponent.shape = this.shape.deepCopy();
        connectedComponent.connectivity = this.connectivity;
        return connectedComponent;
    }

    public int getLeft() {
        return this.left;
    }

    void setLeft(int n) {
        this.left = n;
    }

    public int getTop() {
        return this.top;
    }

    void setTop(int n) {
        this.top = n;
    }

    public int getWidth() {
        return this.shape.width;
    }

    public int getHeight() {
        return this.shape.height;
    }

    public BinaryImage getShape() {
        return this.shape;
    }

    public int getCount() {
        return this.count;
    }

    public boolean equals(ConnectedComponent connectedComponent) {
        if (this.left != connectedComponent.left) {
            return false;
        }
        if (this.top != connectedComponent.top) {
            return false;
        }
        return this.shape.equals(connectedComponent.shape);
    }

    public static boolean includes(ConnectedComponent connectedComponent, ConnectedComponent connectedComponent2) {
        if (connectedComponent.left > connectedComponent2.left) {
            return false;
        }
        if (connectedComponent.top > connectedComponent2.top) {
            return false;
        }
        if (connectedComponent.left + connectedComponent.shape.width < connectedComponent2.left + connectedComponent2.shape.width) {
            return false;
        }
        if (connectedComponent.top + connectedComponent.shape.height < connectedComponent2.top + connectedComponent2.shape.height) {
            return false;
        }
        int n = connectedComponent2.shape.width;
        int n2 = connectedComponent2.shape.height;
        int n3 = connectedComponent2.left - connectedComponent.left;
        int n4 = connectedComponent2.top - connectedComponent.top;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n) {
                if (connectedComponent2.shape.data[n5][n6] != 0 && connectedComponent.shape.data[n5 + n4][n6 + n3] == 0) {
                    return false;
                }
                ++n6;
            }
            ++n5;
        }
        return true;
    }

    public boolean includes(ConnectedComponent connectedComponent) {
        return ConnectedComponent.includes(this, connectedComponent);
    }

    public boolean isIncludedBy(ConnectedComponent connectedComponent) {
        return ConnectedComponent.includes(connectedComponent, this);
    }

    public double getDensity() {
        return (double)this.count / ((double)this.shape.width * (double)this.shape.height);
    }

    public void adjustShape() {
        LabeledImage labeledImage = new LabeledImage(this.shape);
        ConnectedComponent connectedComponent = labeledImage.components[0];
        this.left += connectedComponent.left;
        this.top += connectedComponent.top;
        this.shape = connectedComponent.shape;
    }

    public ConnectedComponent calcContour() throws ImageException {
        if (this.connectivity == 0) {
            throw new ImageException("Information on connectivity is needed to calculate genus");
        }
        int n = this.shape.width;
        int n2 = this.shape.height;
        if (n <= 2 || n2 <= 2) {
            return this.deepCopy();
        }
        BinaryImage binaryImage = new BinaryImage(n, n2);
        int n3 = 0;
        while (n3 < n2) {
            if (this.shape.data[n3][0] != 0) {
                binaryImage.data[n3][0] = 1;
            }
            if (this.shape.data[n3][n - 1] != 0) {
                binaryImage.data[n3][n - 1] = 1;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            if (this.shape.data[0][n3] != 0) {
                binaryImage.data[0][n3] = 1;
            }
            if (this.shape.data[n2 - 1][n3] != 0) {
                binaryImage.data[n2 - 1][n3] = 1;
            }
            ++n3;
        }
        if (this.connectivity == 1) {
            n3 = 1;
            while (n3 < n2 - 1) {
                int n4 = 1;
                while (n4 < n - 1) {
                    if (this.shape.data[n3][n4] != 0 && (this.shape.data[n3 - 1][n4 - 1] == 0 || this.shape.data[n3 - 1][n4] == 0 || this.shape.data[n3 - 1][n4 + 1] == 0 || this.shape.data[n3][n4 - 1] == 0 || this.shape.data[n3][n4 + 1] == 0 || this.shape.data[n3 + 1][n4 - 1] == 0 || this.shape.data[n3 + 1][n4] == 0 || this.shape.data[n3 + 1][n4 + 1] == 0)) {
                        binaryImage.data[n3][n4] = 1;
                    }
                    ++n4;
                }
                ++n3;
            }
        } else if (this.connectivity == 2) {
            n3 = 1;
            while (n3 < n2 - 1) {
                int n5 = 1;
                while (n5 < n - 1) {
                    if (this.shape.data[n3][n5] != 0 && (this.shape.data[n3 - 1][n5] == 0 || this.shape.data[n3 + 1][n5] == 0 || this.shape.data[n3][n5 - 1] == 0 || this.shape.data[n3][n5 + 1] == 0)) {
                        binaryImage.data[n3][n5] = 1;
                    }
                    ++n5;
                }
                ++n3;
            }
        } else {
            throw new ImageException("Unknown connectivity");
        }
        ConnectedComponent connectedComponent = new ConnectedComponent(this.left, this.top, binaryImage, this.connectivity);
        return connectedComponent;
    }

    public ConnectedComponent thinning() throws ImageException {
        return this.thinning((short)10);
    }

    public ConnectedComponent thinning(short s) throws ImageException {
        if (s == 10) {
            return this.thinningHilditch();
        }
        throw new ImageException("Unknown thinning method: " + s);
    }

    public ConnectedComponent thinningHilditch() {
        int n;
        int n2 = this.shape.width;
        int n3 = this.shape.height;
        BinaryImage binaryImage = new BinaryImage(n2 + 2, n3 + 2);
        BinaryImage binaryImage2 = new BinaryImage(n2 + 2, n3 + 2);
        int n4 = 0;
        while (n4 < n3) {
            n = 0;
            while (n < n2) {
                binaryImage.data[n4 + 1][n + 1] = this.shape.data[n4][n];
                ++n;
            }
            ++n4;
        }
        while (this.scanForThinningHilditch(binaryImage, binaryImage2) > 0) {
            binaryImage = binaryImage2;
            binaryImage2 = new BinaryImage(n2 + 2, n3 + 2);
        }
        BinaryImage binaryImage3 = new BinaryImage(n2, n3);
        n = 0;
        while (n < n3) {
            int n5 = 0;
            while (n5 < n2) {
                binaryImage3.data[n][n5] = binaryImage.data[n + 1][n5 + 1];
                ++n5;
            }
            ++n;
        }
        return new ConnectedComponent(this.left, this.top, binaryImage3, 2);
    }

    private int scanForThinningHilditch(BinaryImage binaryImage, BinaryImage binaryImage2) {
        int n = binaryImage.width;
        int n2 = binaryImage.height;
        int n3 = 0;
        int n4 = 1;
        while (n4 < n2 - 1) {
            int n5 = 1;
            while (n5 < n - 1) {
                if (binaryImage.data[n4][n5] != 0) {
                    Neighbor neighbor = new Neighbor(binaryImage, n5, n4);
                    if (neighbor.numBackground4() == 0) {
                        binaryImage2.data[n4][n5] = 1;
                    } else if (neighbor.connectivityNumber8() != 1) {
                        binaryImage2.data[n4][n5] = 1;
                    } else if (neighbor.numForeground8() < 2) {
                        binaryImage2.data[n4][n5] = 1;
                    } else {
                        Neighbor neighbor2 = neighbor.deepCopy();
                        neighbor2.x[2] = binaryImage2.data[n4 - 1][n5 + 1];
                        neighbor2.x[3] = binaryImage2.data[n4 - 1][n5];
                        neighbor2.x[4] = binaryImage2.data[n4 - 1][n5 - 1];
                        neighbor2.x[5] = binaryImage2.data[n4][n5 - 1];
                        if (neighbor2.numForeground8() == 0) {
                            binaryImage2.data[n4][n5] = 1;
                        } else {
                            Neighbor neighbor3 = neighbor.deepCopy();
                            neighbor3.x[3] = binaryImage2.data[n4 - 1][n5];
                            if (neighbor3.connectivityNumber8() != 1) {
                                binaryImage2.data[n4][n5] = 1;
                            } else {
                                Neighbor neighbor4 = neighbor.deepCopy();
                                neighbor4.x[5] = binaryImage2.data[n4][n5 - 1];
                                if (neighbor4.connectivityNumber8() != 1) {
                                    binaryImage2.data[n4][n5] = 1;
                                } else {
                                    ++n3;
                                }
                            }
                        }
                    }
                }
                ++n5;
            }
            ++n4;
        }
        return n3;
    }

    public Topology calcTopology() throws ImageException {
        return new Topology(this);
    }

    public ConnectedComponent calcConvexHull() throws ImageException {
        ConnectedComponent connectedComponent = this.calcContour();
        Coord[] coordArray = connectedComponent.shape.extractPoints();
        if (coordArray == null) {
            return null;
        }
        int n = coordArray.length;
        if (n == 0) {
            return null;
        }
        if (n < 5) {
            return this.deepCopy();
        }
        Vector<Coord> vector = new Vector<Coord>();
        Coord coord = this.shape.topLeftPoint();
        vector.addElement(coord);
        Coord coord2 = coord;
        Coord coord3 = new Coord(1, 0);
        Coord coord4 = this.nextConvexHullVertex(coordArray, coord2, coord3);
        while (!coord4.equals(coord)) {
            vector.addElement(coord4);
            coord3.set(coord4.x - coord2.x, coord4.y - coord2.y);
            coord2 = coord4;
            coord4 = this.nextConvexHullVertex(coordArray, coord2, coord3);
        }
        int n2 = vector.size();
        Coord[] coordArray2 = new Coord[n2];
        int n3 = 0;
        while (n3 < n2) {
            coordArray2[n3] = (Coord)vector.elementAt(n3);
            ++n3;
        }
        BinaryImage binaryImage = new BinaryImage(this.shape.width, this.shape.height, coordArray2);
        return new ConnectedComponent(this.left, this.top, binaryImage, this.connectivity);
    }

    private Coord nextConvexHullVertex(Coord[] coordArray, Coord coord, Coord coord2) throws ImageException {
        if (coordArray == null) {
            throw new ImageException("Empty vertex set.");
        }
        int n = coordArray.length;
        if (n == 0) {
            throw new ImageException("No vertex");
        }
        Coord coord3 = new Coord(-1, -1);
        Coord coord4 = new Coord(-1, -1);
        double d = -2.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            Coord coord5 = coordArray[n2];
            if (!coord5.equals(coord)) {
                double d3;
                coord4.set(coord5.x - coord.x, coord5.y - coord.y);
                double d4 = Coord.cosine(coord2, coord4);
                if (d < d4) {
                    d = d4;
                    d2 = Coord.distance(coord, coord5);
                    coord3.copy(coord5);
                } else if (d == d4 && (d3 = Coord.distance(coord, coord5)) > d2) {
                    d2 = d3;
                    coord3.copy(coord5);
                }
            }
            ++n2;
        }
        return coord3;
    }

    public int calcGenus() throws ImageException {
        if (this.connectivity == 0) {
            throw new ImageException("Information on connectivity is needed to calculate genus");
        }
        int n = this.shape.width;
        int n2 = this.shape.height;
        if (n <= 2 || n2 <= 2) {
            return 1;
        }
        int n3 = this.shape.measureArea();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.connectivity == 1) {
            int n8 = 0;
            while (n8 < n2 - 1) {
                int n9 = 0;
                while (n9 < n - 1) {
                    if (this.shape.data[n8][n9] != 0) {
                        if (this.shape.data[n8 + 1][n9] != 0) {
                            ++n4;
                        }
                        if (this.shape.data[n8][n9 + 1] != 0) {
                            ++n4;
                        }
                        if (this.shape.data[n8 + 1][n9] != 0 && this.shape.data[n8][n9 + 1] != 0 && this.shape.data[n8 + 1][n9 + 1] != 0) {
                            ++n7;
                        }
                    }
                    ++n9;
                }
                if (this.shape.data[n8][n - 1] != 0 && this.shape.data[n8 + 1][n - 1] != 0) {
                    ++n4;
                }
                ++n8;
            }
            n8 = 0;
            while (n8 < n - 1) {
                if (this.shape.data[n2 - 1][n8] != 0 && this.shape.data[n2 - 1][n8 + 1] != 0) {
                    ++n4;
                }
                ++n8;
            }
            return n3 - n4 + n7;
        }
        if (this.connectivity == 2) {
            int n10 = 0;
            while (n10 < n2 - 1) {
                int n11 = 0;
                while (n11 < n - 1) {
                    if (this.shape.data[n10][n11] != 0) {
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (this.shape.data[n10 + 1][n11] != 0) {
                            bl2 = true;
                            ++n4;
                        }
                        if (this.shape.data[n10][n11 + 1] != 0) {
                            bl = true;
                            ++n4;
                        }
                        if (this.shape.data[n10 + 1][n11 + 1] != 0) {
                            bl3 = true;
                            ++n5;
                        }
                        if (bl && bl2) {
                            ++n6;
                        }
                        if (bl && bl3) {
                            ++n6;
                        }
                        if (bl2 && bl3) {
                            ++n6;
                        }
                        if (bl && bl2 && bl3) {
                            ++n7;
                        }
                    }
                    if (this.shape.data[n10][n11 + 1] != 0 && this.shape.data[n10 + 1][n11] != 0) {
                        ++n5;
                        if (this.shape.data[n10 + 1][n11 + 1] != 0) {
                            ++n6;
                        }
                    }
                    ++n11;
                }
                if (this.shape.data[n10][n - 1] != 0 && this.shape.data[n10 + 1][n - 1] != 0) {
                    ++n4;
                }
                ++n10;
            }
            n10 = 0;
            while (n10 < n - 1) {
                if (this.shape.data[n2 - 1][n10] != 0 && this.shape.data[n2 - 1][n10 + 1] != 0) {
                    ++n4;
                }
                ++n10;
            }
            return n3 - n4 - n5 + n6 - n7;
        }
        throw new ImageException("Unknown connectivity");
    }

    public void dump(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dump(printWriter);
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("-------------------------------");
        printWriter.println("Dumping a ConnectedComponent");
        printWriter.println("Left = " + this.left + ", Top = " + this.top + ", Width = " + this.shape.width + ", Height = " + this.shape.height);
        int n = 0;
        while (n < this.shape.height) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.shape.width) {
                if (this.shape.data[n][n2] == 0) {
                    stringBuffer.append(".");
                } else {
                    stringBuffer.append("#");
                }
                ++n2;
            }
            printWriter.println(stringBuffer.toString());
            ++n;
        }
        printWriter.println("-------------------------------");
    }

    public void dump(PrintStream printStream, int n, int n2, int n3, int n4) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dump(printWriter, n, n2, n3, n4);
    }

    public void dump(PrintWriter printWriter, int n, int n2, int n3, int n4) {
        printWriter.println("-------------------------------");
        printWriter.println("Dumping a part of a ConnectedComponent");
        printWriter.println("Left = " + this.left + ", Top = " + this.top + ", Width = " + this.shape.width + ", Height = " + this.shape.height);
        printWriter.println("Start point = ( " + n + ", " + n2 + ")");
        printWriter.println("Printed width = " + n3 + ", Printed height = " + n4);
        int n5 = 0;
        while (n5 < n4) {
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = 0;
            while (n6 < n3) {
                if (this.shape.data[n5 + n2][n6 + n] == 0) {
                    stringBuffer.append(".");
                } else {
                    stringBuffer.append("#");
                }
                ++n6;
            }
            printWriter.println(stringBuffer.toString());
            ++n5;
        }
        printWriter.println("-------------------------------");
    }

    public Int2D drawShape(Int2D int2D, int n) {
        int n2 = 0;
        while (n2 < this.shape.height) {
            int n3 = 0;
            while (n3 < this.shape.width) {
                if (this.shape.data[n2][n3] != 0) {
                    int2D.getData()[n2 + this.top][n3 + this.left] = n;
                }
                ++n3;
            }
            ++n2;
        }
        return int2D;
    }
}

