/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.amalgam.explorer.contextual.core.ExplorerActivator;
import org.eclipse.amalgam.explorer.contextual.core.category.CategoryRegistry;
import org.eclipse.amalgam.explorer.contextual.core.category.ICategory;
import org.eclipse.amalgam.explorer.contextual.core.model.IExplorerContextualModel;
import org.eclipse.amalgam.explorer.contextual.core.provider.AbstractGroupedAdapterFactoryContentProvider;
import org.eclipse.amalgam.explorer.contextual.core.provider.IExplorerContentProvider;
import org.eclipse.amalgam.explorer.contextual.core.provider.wrapper.CategoryWrapper;
import org.eclipse.amalgam.explorer.contextual.core.provider.wrapper.EObjectWrapper;
import org.eclipse.amalgam.explorer.contextual.core.provider.wrapper.ExplorerElementWrapper;
import org.eclipse.amalgam.explorer.contextual.core.query.impl.QueryAdapter;
import org.eclipse.amalgam.explorer.contextual.core.util.ViewerHelper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractContentProvider
extends AbstractGroupedAdapterFactoryContentProvider
implements IExplorerContentProvider {
    protected EObject _rootElement;
    protected boolean _inputHasChanged;
    protected HashMap<ExplorerElementWrapper, ExplorerElementWrapper> _semanticParentHashMap;
    protected boolean refreshRequired = false;
    protected IExplorerContextualModel model;

    public AbstractContentProvider(AdapterFactory adapterFactory_p, IExplorerContextualModel model_p) {
        super(adapterFactory_p);
        this.model = model_p;
        this._semanticParentHashMap = new HashMap(0);
    }

    public void dispose() {
        this._semanticParentHashMap.clear();
        super.dispose();
    }

    protected void getCategoryChildren(ICategory category_p, ExplorerElementWrapper wrapper, Set<Object> gatheredElements) {
        EObject elementToQuery = this.lookUpEObject(wrapper);
        gatheredElements.addAll(category_p.compute(elementToQuery));
        gatheredElements.addAll(CategoryRegistry.getInstance().gatherSubCategories(this.getExplorerId(), elementToQuery, category_p));
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = new Object[]{};
        try {
            if (parentElement instanceof ExplorerElementWrapper) {
                ExplorerElementWrapper wrapper = (ExplorerElementWrapper)parentElement;
                Object element = ((ExplorerElementWrapper)parentElement).getElement();
                HashSet<Object> gatheredElements = new HashSet<Object>(0);
                if (wrapper instanceof EObjectWrapper) {
                    if (element == this._rootElement && this._inputHasChanged) {
                        this._semanticParentHashMap.put(wrapper, null);
                        this._inputHasChanged = false;
                        if (this.getExplorerId().equalsIgnoreCase("CurrentElementExplorer")) {
                            return new Object[]{wrapper};
                        }
                    }
                    this.getElementChildren((EObject)element, wrapper, gatheredElements);
                } else if (wrapper instanceof CategoryWrapper) {
                    this.getCategoryChildren((ICategory)element, wrapper, gatheredElements);
                }
                HashSet<ExplorerElementWrapper> wrappers = new HashSet<ExplorerElementWrapper>(0);
                for (Object e : gatheredElements) {
                    if (e == null) continue;
                    ExplorerElementWrapper elementWrapper = this.wrapElement(e);
                    wrappers.add(elementWrapper);
                    this._semanticParentHashMap.put(elementWrapper, wrapper);
                    boolean shouldRemovedEmptyCategoryWrapper = false;
                    if (e instanceof ICategory) {
                        if (!this.model.doesShowCategory((ICategory)e)) {
                            shouldRemovedEmptyCategoryWrapper = true;
                        } else {
                            HashSet<Object> categoryChildren = new HashSet<Object>(0);
                            this.getCategoryChildren((ICategory)e, elementWrapper, categoryChildren);
                            if (categoryChildren.isEmpty()) {
                                shouldRemovedEmptyCategoryWrapper = true;
                            }
                        }
                    }
                    if (!shouldRemovedEmptyCategoryWrapper) continue;
                    wrappers.remove(elementWrapper);
                    this._semanticParentHashMap.remove(elementWrapper);
                }
                result = wrappers.toArray();
            } else {
                result = this.getChildren(new EObjectWrapper(parentElement));
            }
        }
        catch (Exception exception_p) {
            ExplorerActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.amalgam.explorer.contextual.core", "Error while getting children for " + parentElement, (Throwable)exception_p));
            result = new Object[]{};
        }
        return result;
    }

    protected void getElementChildren(EObject eObject, ExplorerElementWrapper wrapper, Set<Object> gatheredElements) {
        ExplorerElementWrapper parentWrapper;
        Object semanticParent;
        ExplorerElementWrapper semanticParentWrapper;
        if (eObject != this._rootElement && (semanticParentWrapper = this._semanticParentHashMap.get(wrapper)) != null && (semanticParent = semanticParentWrapper.getElement()) instanceof ICategory) {
            for (Object query : ((ICategory)semanticParent).getItemQueries()) {
                gatheredElements.addAll(QueryAdapter.getInstance().compute(eObject, query));
            }
        }
        if (this._semanticParentHashMap.get(parentWrapper = this._semanticParentHashMap.get(wrapper)) == null) {
            gatheredElements.addAll(CategoryRegistry.getInstance().gatherCategories(this.getExplorerId(), eObject));
        }
    }

    public Object[] getElements(Object rootElement_p) {
        return this.getChildren(rootElement_p);
    }

    public Object getParent(Object element_p) {
        return this._semanticParentHashMap.get(element_p);
    }

    public boolean hasChildren(Object element_p) {
        return true;
    }

    public void inputChanged(Viewer viewer_p, Object oldInput, Object newInput) {
        if (this.viewer == null) {
            this.viewer = viewer_p;
        }
        if (newInput instanceof ExplorerElementWrapper) {
            if (oldInput == null) {
                this.inputChanged(viewer_p, new EObjectWrapper(null), ((ExplorerElementWrapper)newInput).getElement());
            } else if (oldInput instanceof ExplorerElementWrapper) {
                this.inputChanged(viewer_p, ((ExplorerElementWrapper)oldInput).getElement(), ((ExplorerElementWrapper)newInput).getElement());
            } else if (oldInput instanceof EObject) {
                this.inputChanged(viewer_p, oldInput, ((ExplorerElementWrapper)newInput).getElement());
            }
        } else if (newInput instanceof EObject) {
            this._semanticParentHashMap.clear();
            this._inputHasChanged = true;
            this._rootElement = (EObject)newInput;
        } else if (newInput == null) {
            this._inputHasChanged = false;
            this._rootElement = null;
            this._semanticParentHashMap.clear();
        }
    }

    private EObject lookUpEObject(ExplorerElementWrapper wrapper_p) {
        ExplorerElementWrapper parentWrapper = this._semanticParentHashMap.get(wrapper_p);
        if (parentWrapper instanceof CategoryWrapper) {
            return this.lookUpEObject(parentWrapper);
        }
        return (EObject)parentWrapper.getElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean refreshRequired(ResourceSetChangeEvent event_p) {
        boolean result = false;
        AbstractContentProvider abstractContentProvider = this;
        synchronized (abstractContentProvider) {
            if (this.refreshRequired) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChanged(Notification notification_p) {
        if (notification_p instanceof IViewerNotification) {
            IViewerNotification viewerNotification = (IViewerNotification)notification_p;
            if (!viewerNotification.isContentRefresh()) {
                Object element = viewerNotification.getElement();
                ExplorerElementWrapper wrappedElement = this.wrapElement(element);
                if (wrappedElement != null) {
                    super.notifyChanged(ViewerNotification.wrapNotification((Notification)viewerNotification, (Object)wrappedElement));
                }
            } else {
                AbstractContentProvider abstractContentProvider = this;
                synchronized (abstractContentProvider) {
                    if (!this.refreshRequired) {
                        this.refreshRequired = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRefresh() {
        boolean refresh = false;
        AbstractContentProvider abstractContentProvider = this;
        synchronized (abstractContentProvider) {
            refresh = this.refreshRequired;
            this.refreshRequired = false;
            if (this.refreshRequired) {
                this.notifications = null;
                this.toRefresh = null;
            }
        }
        if (!refresh) {
            super.processRefresh();
        } else if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            ViewerHelper.run((StructuredViewer)this.viewer, new Runnable(){

                @Override
                public void run() {
                    Object input = AbstractContentProvider.this.viewer.getInput();
                    AbstractContentProvider.this.viewer.setInput(input);
                }
            });
        }
    }

    private ExplorerElementWrapper wrapElement(Object gatherElement_p) {
        ExplorerElementWrapper wrapper = null;
        if (gatherElement_p != null && gatherElement_p instanceof EObject) {
            wrapper = new EObjectWrapper(gatherElement_p);
        } else if (gatherElement_p instanceof ICategory) {
            wrapper = new CategoryWrapper(gatherElement_p);
        }
        return wrapper;
    }

    public EObject getRootElement() {
        return this._rootElement;
    }
}

